/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor;

import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.monitor.BaseMonitorMBean;
import com.sun.enterprise.admin.monitor.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.types.MonitoredAttributeType;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

public class GenericMonitorMBean
extends BaseMonitorMBean {
    private static GenericMonitorMBean root;
    private static MBeanInfo genericMBeanInfo;
    private static StringManager localStrings;

    public Object getAttribute(String str) throws AttributeNotFoundException {
        String msg = localStrings.getString("admin.monitor.unknown_attribute", str);
        throw new AttributeNotFoundException(msg);
    }

    public MonitoredAttributeType getAttributeType(String str) {
        String msg = localStrings.getString("admin.monitor.unsupported_getattributetype");
        throw new UnsupportedOperationException(msg);
    }

    public AttributeList getAttributes(String[] str) {
        return new AttributeList();
    }

    public MBeanInfo getMBeanInfo() {
        if (genericMBeanInfo == null) {
            genericMBeanInfo = GenericMonitorMBean.createMBeanInfo(new HashMap());
        }
        return genericMBeanInfo;
    }

    public Map getMonitoringMetaData() {
        return new HashMap();
    }

    public void startMonitoring() {
        for (BaseMonitorMBean mBean : this.childList) {
            mBean.startMonitoring();
        }
    }

    public void stopMonitoring() {
        for (BaseMonitorMBean mBean : this.childList) {
            mBean.stopMonitoring();
        }
    }

    public void startMonitoring(MonitoredObjectType[] typeList) {
        HashMap typeMap = this.getMonitoredObjectTypeMap(typeList);
        this.startMonitoring(typeMap);
    }

    public void stopMonitoring(MonitoredObjectType[] typeList) {
        HashMap typeMap = this.getMonitoredObjectTypeMap(typeList);
        this.stopMonitoring(typeMap);
    }

    private void startMonitoring(HashMap typeMap) {
        for (BaseMonitorMBean mBean : this.childList) {
            if (!typeMap.containsKey(mBean.getNodeType())) continue;
            if (mBean.getClass() == GenericMonitorMBean.class) {
                ((GenericMonitorMBean)mBean).startMonitoring(typeMap);
                continue;
            }
            mBean.startMonitoring();
        }
    }

    private void stopMonitoring(HashMap typeMap) {
        for (BaseMonitorMBean mBean : this.childList) {
            if (!typeMap.containsKey(mBean.getNodeType())) continue;
            if (mBean.getClass() == GenericMonitorMBean.class) {
                ((GenericMonitorMBean)mBean).stopMonitoring(typeMap);
                continue;
            }
            mBean.stopMonitoring();
        }
    }

    private HashMap getMonitoredObjectTypeMap(MonitoredObjectType[] typeList) {
        HashMap<String, MonitoredObjectType> map = new HashMap<String, MonitoredObjectType>();
        int size = typeList != null ? typeList.length : 0;
        for (int i = 0; i < size; ++i) {
            map.put(typeList[i].getTypeName(), typeList[i]);
        }
        return map;
    }

    public static GenericMonitorMBean getRoot() {
        if (root == null) {
            root = new GenericMonitorMBean();
            root.setNodeName("root");
            root.setNodeType("root");
            String instName = AdminService.getAdminService().getInstanceName();
            ObjectName objName = ObjectNames.getRootMonitorMBeanName(instName);
            objectNameMap.put(objName, root);
            root.setObjectName(objName);
        }
        return root;
    }

    static {
        genericMBeanInfo = null;
        localStrings = StringManager.getManager(GenericMonitorMBean.class);
    }
}

