/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.configuration;

import com.sun.enterprise.config.serverbeans.ElementProperty;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.ErrorManager;

public class JavaBeanConfigurator {
    private static final JavaBeanConfigurator singleton = new JavaBeanConfigurator();

    private JavaBeanConfigurator() {
    }

    public static JavaBeanConfigurator getInstance() {
        return singleton;
    }

    public Object configureBean(Object bean, ElementProperty[] properties) {
        this.setProperties(bean, properties);
        return bean;
    }

    private final Method[] getDeclaredMethods(final Class clz) {
        return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clz.getDeclaredMethods();
            }
        });
    }

    private void setProperties(Object o, ElementProperty[] properties) {
        if (properties == null) {
            return;
        }
        Method[] methods = null;
        try {
            methods = this.getDeclaredMethods(o.getClass());
            for (int i = 0; i < properties.length; ++i) {
                ElementProperty property = properties[i];
                String propertyName = property.getName().toLowerCase();
                String propertyValue = property.getValue();
                for (int j = 0; j < methods.length; ++j) {
                    String methodName = methods[j].getName().toLowerCase();
                    if (!methodName.startsWith("set") || !methodName.endsWith(propertyName)) continue;
                    Class<?>[] parameterTypes = methods[j].getParameterTypes();
                    if (parameterTypes.length != 1) {
                        new ErrorManager().error("Only one Parameter is allowed for the setter  Method: " + methodName + " has invalid signature", new Exception(), 0);
                    }
                    String parameterType = parameterTypes[0].getName();
                    Object[] parameters = new Object[1];
                    if (parameterType.equals("java.lang.String")) {
                        parameters[0] = propertyValue;
                    } else if (parameterType.equals("byte")) {
                        parameters[0] = new Byte(propertyValue.getBytes()[0]);
                    } else if (parameterType.equals("int")) {
                        parameters[0] = new Integer(propertyValue);
                    } else if (parameterType.equals("float")) {
                        parameters[0] = new Float(propertyValue);
                    } else if (parameterType.equals("double")) {
                        parameters[0] = new Double(propertyValue);
                    } else if (parameterType.equals("char")) {
                        parameters[0] = new Character(propertyValue.charAt(0));
                    } else if (parameterType.equals("boolean")) {
                        parameters[0] = new Boolean(propertyValue);
                    } else if (parameterType.equals("long")) {
                        parameters[0] = new Long(propertyValue);
                    } else if (parameterType.equals("short")) {
                        parameters[0] = new Short(propertyValue);
                    } else {
                        new ErrorManager().error("Only the basic primitive types can be set as properties to NotificationListener and  NotificationFilter ", new Exception(), 0);
                        continue;
                    }
                    methods[j].invoke(o, parameters);
                }
            }
        }
        catch (Exception e) {
            new ErrorManager().error("Error While Setting properties to Notification Listener or  Filter ", e, 0);
        }
    }
}

