/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.loader.InstrumentableClassLoader;
import com.sun.enterprise.server.PersistenceUnitInfoImpl;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitLoaderImpl {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.appclient");
    private String applicationLocation;
    private InstrumentableClassLoader classLoader;
    private ApplicationClientDescriptor appClient;

    public PersistenceUnitLoaderImpl(String applicationLocation, InstrumentableClassLoader classLoader, ApplicationClientDescriptor appClient) {
        this.applicationLocation = applicationLocation;
        this.classLoader = classLoader;
        this.appClient = appClient;
    }

    public void load() {
        logger.info("Loading persistence units for application: " + this.applicationLocation);
        for (PersistenceUnitDescriptor pu : this.findReferencedPUs()) {
            this.load(pu);
        }
    }

    public void unload() {
        logger.info("Unloading persistence units for application: " + this.applicationLocation);
        if (this.appClient.getApplication() != null) {
            this.closeEMFs(this.appClient.getApplication().getEntityManagerFactories());
        }
        logger.info("Unloading persistence units for appclient module called " + this.appClient.getModuleDescriptor().getArchiveUri() + " in application " + this.applicationLocation);
        this.closeEMFs(this.appClient.getEntityManagerFactories());
        logger.info("Finished unloading persistence units for application: " + this.applicationLocation);
    }

    private List<PersistenceUnitDescriptor> findReferencedPUs() {
        ArrayList<PersistenceUnitDescriptor> result = new ArrayList<PersistenceUnitDescriptor>();
        for (EntityManagerFactoryReferenceDescriptor emfRef : this.appClient.getEntityManagerFactoryReferenceDescriptors()) {
            String unitName = emfRef.getUnitName();
            PersistenceUnitDescriptor pu = this.appClient.findReferencedPU(unitName);
            if (pu == null) {
                throw new RuntimeException("No suitable persistence unit called " + unitName + " found in the scope of this " + "application client.");
            }
            if (pu.getTransactionType() == "JTA") {
                throw new RuntimeException("Application client is referencing a persistence unit called " + unitName + ", but that" + "is of transaction-type JTA. Application client " + "can only use RESOURCE_LOCAL persistence unit.");
            }
            if (result.contains(pu)) continue;
            result.add(pu);
        }
        return result;
    }

    private void load(PersistenceUnitDescriptor pud) {
        PersistenceProvider provider;
        logger.info("loading pud " + pud.getAbsolutePuRoot());
        PersistenceUnitInfoImpl pInfo = new PersistenceUnitInfoImpl(pud, this.applicationLocation, this.classLoader);
        logger.info("PersistenceInfo for this pud is :\n" + pInfo);
        try {
            provider = (PersistenceProvider)PersistenceProvider.class.cast(((ClassLoader)ClassLoader.class.cast(this.classLoader)).loadClass(pInfo.getPersistenceProviderClassName()).newInstance());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)pInfo, null);
        logger.logp(Level.INFO, "PersistenceUnitLoaderImpl", "load", "emf = {0}", emf);
        RootDeploymentDescriptor rootDD = pud.getParent().getParent();
        if (rootDD.isApplication()) {
            ((Application)Application.class.cast(rootDD)).addEntityManagerFactory(pInfo.getPersistenceUnitName(), pud.getPuRoot(), emf);
        } else {
            ((BundleDescriptor)BundleDescriptor.class.cast(rootDD)).addEntityManagerFactory(pInfo.getPersistenceUnitName(), emf);
        }
    }

    private void closeEMFs(Collection<EntityManagerFactory> entityManagerFactories) {
        for (EntityManagerFactory emf : entityManagerFactories) {
            try {
                emf.close();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }
}

