/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployapi.actions;

import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployapi.SunTargetModuleID;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.InputStream;
import javax.enterprise.deploy.spi.exceptions.ClientExecuteException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;

public class ClientConfigurationImpl
implements ClientConfiguration {
    SunTargetModuleID targetModuleID;
    String originalArchivePath;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ClientConfigurationImpl.class);

    public ClientConfigurationImpl(SunTargetModuleID targetModuleID) {
        this.targetModuleID = targetModuleID;
    }

    public void execute() throws ClientExecuteException {
        if (this.targetModuleID == null) {
            throw new ClientExecuteException(localStrings.getLocalString("enterprise.deployapi.actions.clientconfigurationimpl.nomoduleid", "No moduleID for deployed application found"));
        }
        SunTarget target = (SunTarget)this.targetModuleID.getTarget();
        String moduleID = this.targetModuleID.getParentTargetModuleID() != null ? this.targetModuleID.getParentTargetModuleID().getModuleID() : this.targetModuleID.getModuleID();
        try {
            String location = target.exportClientStubs(moduleID, 0, System.getProperty("java.io.tmpdir"));
            String id = this.targetModuleID.getModuleID();
            if (id.indexOf(35) != -1) {
                id = id.substring(id.indexOf(35) + 1);
            }
            String j2eeHome = System.getProperty("com.sun.aas.installRoot");
            String appClientBinary = j2eeHome + File.separatorChar + "bin" + File.separatorChar + "appclient";
            String command = appClientBinary + " -client " + location;
            Process p = Runtime.getRuntime().exec(command);
            InputStream is = p.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ClientExecuteException(localStrings.getLocalString("enterprise.deployapi.actions.clientconfigurationimpl.exception", "Exception while invoking application client : \n {0}", new Object[]{e.getMessage()}));
        }
    }
}

