/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.LicenseDescriptor;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.deployment.node.connector.ConnectorNode;
import com.sun.enterprise.deployment.runtime.connector.SunConnector;
import com.sun.enterprise.deployment.util.ConnectorVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DescriptorVisitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import javax.enterprise.deploy.shared.ModuleType;

public class ConnectorDescriptor
extends BundleDescriptor {
    private boolean isDirty = false;
    private String displayName = "";
    private String connectorDescription = "";
    private String largeIcon = "";
    private String smallIcon = "";
    private String vendorName = "";
    private String eisType = "";
    private String resourceAdapterVersion = "";
    private LicenseDescriptor licenseDescriptor = null;
    private Set configProperties = new OrderedSet();
    private Set authMechanisms = new OrderedSet();
    private Set securityPermissions = new OrderedSet();
    private String managedConnectionFactoryImpl = "";
    private int transactionSupport = 1;
    private boolean reauthenticationSupport = false;
    private String connectionInterface;
    private String connectionClass;
    private String connectionFactoryInterface;
    private String connectionFactoryClass;
    private String resourceAdapterClass = "";
    private EnvironmentProperty configProperty = null;
    private OutboundResourceAdapter outboundRA = null;
    private InboundResourceAdapter inboundRA = null;
    private Set adminObjects = new OrderedSet();
    private String inboundResourceAdapterClass = "";
    private Set messageListeners = new OrderedSet();
    private SunConnector sunConnector = null;

    public String getDefaultSpecVersion() {
        return ConnectorNode.SPEC_VERSION;
    }

    public String getConnectionFactoryInterface() {
        throw new UnsupportedOperationException();
    }

    public void setConnectionFactoryInterface(String connectionFactoryInterface) {
        throw new UnsupportedOperationException();
    }

    public String getConnectionFactoryImpl() {
        throw new UnsupportedOperationException();
    }

    public void setConnectionFactoryImpl(String connectionFactoryImpl) {
        throw new UnsupportedOperationException();
    }

    public String getConnectionInterface() {
        throw new UnsupportedOperationException();
    }

    public void setConnectionInterface(String connectionInterface) {
        throw new UnsupportedOperationException();
    }

    public String getConnectionImpl() {
        throw new UnsupportedOperationException();
    }

    public void setConnectionImpl(String connectionImpl) {
        throw new UnsupportedOperationException();
    }

    public String getManagedConnectionFactoryImpl() {
        throw new UnsupportedOperationException();
    }

    public void setManagedConnectionFactoryImpl(String managedConnectionFactoryImpl) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsReauthentication() {
        throw new UnsupportedOperationException();
    }

    public String getReauthenticationSupport() {
        throw new UnsupportedOperationException();
    }

    public void setReauthenticationSupport(boolean reauthenticationSupport) {
        throw new UnsupportedOperationException();
    }

    public void setReauthenticationSupport(String reauthSupport) {
        throw new UnsupportedOperationException();
    }

    public String getTransSupport() {
        throw new UnsupportedOperationException();
    }

    public int getTransactionSupport() {
        throw new UnsupportedOperationException();
    }

    public void setTransactionSupport(int transactionSupport) {
        throw new UnsupportedOperationException();
    }

    public void setTransactionSupport(String support) {
        throw new UnsupportedOperationException();
    }

    public Set getAuthMechanisms() {
        throw new UnsupportedOperationException();
    }

    public Set getServiceReferenceDescriptors() {
        return new OrderedSet();
    }

    public Set getSecurityPermissions() {
        if (this.securityPermissions == null) {
            this.securityPermissions = new OrderedSet();
        }
        return this.securityPermissions;
    }

    public boolean addAuthMechanism(AuthMechanism mech) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAuthMechanism(AuthMechanism mech) {
        throw new UnsupportedOperationException();
    }

    public boolean addAuthMechanism(int mech) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAuthMechanism(int mech) {
        throw new UnsupportedOperationException();
    }

    public void addSecurityPermission(SecurityPermission permission) {
        this.securityPermissions.add(permission);
        this.setDirty();
        this.changed();
    }

    public void removeSecurityPermission(SecurityPermission permission) {
        this.securityPermissions.remove(permission);
        this.setDirty();
        this.changed();
    }

    public String getResourceAdapterClass() {
        return this.resourceAdapterClass;
    }

    public void setResourceAdapterClass(String raClass) {
        this.resourceAdapterClass = raClass;
        this.setDirty();
        this.changed();
    }

    public Set getConfigProperties() {
        return this.configProperties;
    }

    public void addConfigProperty(EnvironmentProperty configProperty) {
        this.configProperties.add(configProperty);
        this.setDirty();
        this.changed();
    }

    public void removeConfigProperty(EnvironmentProperty configProperty) {
        this.configProperties.remove(configProperty);
        this.setDirty();
        this.changed();
    }

    public LicenseDescriptor getLicenseDescriptor() {
        return this.licenseDescriptor;
    }

    public void setLicenseDescriptor(LicenseDescriptor licenseDescriptor) {
        this.licenseDescriptor = licenseDescriptor;
        this.setDirty();
        this.changed();
    }

    public OutboundResourceAdapter getOutboundResourceAdapter() {
        return this.outboundRA;
    }

    public void setOutboundResourceAdapter(OutboundResourceAdapter outboundRA) {
        this.outboundRA = outboundRA;
    }

    public InboundResourceAdapter getInboundResourceAdapter() {
        return this.inboundRA;
    }

    public void setInboundResourceAdapter(InboundResourceAdapter inboundRA) {
        this.inboundRA = inboundRA;
    }

    public Set getAdminObjects() {
        return this.adminObjects;
    }

    public void addAdminObject(AdminObject admin) {
        this.adminObjects.add(admin);
        this.setDirty();
        this.changed();
    }

    public void removeAdminObject(AdminObject admin) {
        this.adminObjects.remove(admin);
        this.setDirty();
        this.changed();
    }

    public boolean hasAdminObjects() {
        return this.adminObjects.size() > 0;
    }

    public boolean getOutBoundDefined() {
        return this.outboundRA != null;
    }

    public boolean getInBoundDefined() {
        return this.inboundRA != null;
    }

    public void setDescription(String description) {
        this.setDirty();
        super.setDescription(description);
    }

    public String getConnectorDescription() {
        return this.connectorDescription;
    }

    public void setConnectorDescription(String description) {
        this.connectorDescription = description;
        this.setDirty();
        this.changed();
    }

    public void setLargeIconUri(String largeIconUri) {
        this.setDirty();
        super.setLargeIconUri(largeIconUri);
    }

    public void setSmallIconUri(String smallIconUri) {
        this.setDirty();
        super.setSmallIconUri(smallIconUri);
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
        this.setDirty();
        this.changed();
    }

    public void setSpecVersion(String specVersion) {
        super.setSpecVersion(specVersion);
        this.setDirty();
        this.changed();
    }

    public String getEisType() {
        return this.eisType;
    }

    public void setEisType(String eisType) {
        this.eisType = eisType;
        this.setDirty();
        this.changed();
    }

    public String getVersion() {
        throw new UnsupportedOperationException();
    }

    public void setVersion(String version) {
        throw new UnsupportedOperationException();
    }

    public String getResourceAdapterVersion() {
        return this.resourceAdapterVersion;
    }

    public void setResourceAdapterVersion(String resourceAdapterVersion) {
        this.resourceAdapterVersion = resourceAdapterVersion;
        this.setDirty();
        this.changed();
    }

    public String getDeployName() {
        return this.getModuleDescriptor().getArchiveUri();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private void setDirty() {
        this.isDirty = true;
    }

    void doneOpening() {
        this.isDirty = false;
        this.changed();
    }

    void doneSaving() {
        this.isDirty = false;
        this.changed();
    }

    public void setName(String name) {
        if (!this.getName().equals(name)) {
            this.setDirty();
            super.setName(name);
        }
    }

    public void visit(DescriptorVisitor aVisitor) {
        if (aVisitor instanceof ConnectorVisitor) {
            this.visit((ConnectorVisitor)((Object)aVisitor));
        } else {
            super.visit(aVisitor);
        }
    }

    public void visit(ConnectorVisitor aVisitor) {
        aVisitor.accept(this);
    }

    private static void printEntry(ZipEntry e) throws IOException {
        DOLUtils.getDefaultLogger().log(Level.FINE, e.getName());
    }

    public ConnectionDefDescriptor getConnectionDefinitionByCFType(String type) {
        return this.getConnectionDefinitionByCFType(type, true);
    }

    public ConnectionDefDescriptor getConnectionDefinitionByCFType(String type, boolean useDefault) {
        for (ConnectionDefDescriptor desc : this.outboundRA.getConnectionDefs()) {
            if (type == null) {
                if (useDefault && this.outboundRA.getConnectionDefs().size() == 1) {
                    return desc;
                }
                return null;
            }
            if (!desc.getConnectionFactoryIntf().equals(type)) continue;
            return desc;
        }
        return null;
    }

    public int getNumOfSupportedCFs() {
        return this.outboundRA.getConnectionDefs().size();
    }

    public AdminObject getAdminObjectByType(String type) {
        for (AdminObject ao : this.getAdminObjects()) {
            if (!type.equals(ao.getAdminObjectInterface())) continue;
            return ao;
        }
        return null;
    }

    public void print(StringBuffer toStringBuffer) {
        Iterator i;
        StringBuffer buf = toStringBuffer;
        super.print(buf);
        buf.append("\n displayName : " + super.getName());
        buf.append("\n connector_description : " + this.connectorDescription);
        buf.append("\n smallIcon : " + super.getSmallIconUri());
        buf.append("\n largeIcon : " + super.getLargeIconUri());
        buf.append("\n vendorName : " + this.vendorName);
        buf.append("\n eisType : " + this.eisType);
        buf.append("\n resourceadapter version : " + this.resourceAdapterVersion);
        if (this.getLicenseDescriptor() != null) {
            buf.append("\n license_description : " + this.getLicenseDescriptor().getDescription());
            buf.append("\n licenseRequired : " + this.getLicenseDescriptor().getLicenseRequiredValue());
        }
        buf.append("\n resourceAdapterClass : " + this.resourceAdapterClass);
        buf.append("\n resourceAdapterClass [" + this.resourceAdapterClass + "] config properties :");
        this.appendConfigProperties(this.configProperties, buf);
        if (this.outboundRA == null) {
            buf.append("\n Outbound Resource Adapter NOT available");
        } else {
            buf.append("\n Outbound Resource Adapter Info : ");
            buf.append("\n connection-definitions: ");
            i = this.outboundRA.getConnectionDefs().iterator();
            while (i.hasNext()) {
                buf.append("\n------------\n");
                ConnectionDefDescriptor conDef = (ConnectionDefDescriptor)i.next();
                buf.append("MCF : " + conDef.getManagedConnectionFactoryImpl() + ", ");
                buf.append("\n MCF [" + conDef.getManagedConnectionFactoryImpl() + "] config properties :");
                this.appendConfigProperties(conDef.getConfigProperties(), buf);
                buf.append("[CF Interface : " + conDef.getConnectionFactoryIntf() + "], ");
                buf.append("[CF Class : " + conDef.getConnectionFactoryImpl() + "], ");
                buf.append("[Connection Interface : " + conDef.getConnectionIntf() + "], ");
                buf.append("[Connection Class : " + conDef.getConnectionImpl() + "] ");
                buf.append("\n------------\n");
            }
            buf.append("\n transaction-support : " + this.outboundRA.getTransSupport());
            buf.append("\n authentication-mechanism: ");
            for (Descriptor conf : this.outboundRA.getAuthMechanisms()) {
                buf.append("\n------------\n");
                buf.append("[Type : " + ((AuthMechanism)conf).getAuthMechType() + "], ");
                buf.append("[Interface : " + ((AuthMechanism)conf).getCredentialInterface() + "]");
                buf.append("\n------------");
            }
            buf.append("\n reauthenticate-support : " + this.outboundRA.getReauthenticationSupport());
            buf.append("\n security-permission : ");
            for (Descriptor conf : this.getSecurityPermissions()) {
                buf.append("\n------------\n");
                buf.append("[persmission : " + ((SecurityPermission)conf).getPermission() + "], ");
                buf.append("[discription : " + conf.getDescription() + "]");
                buf.append("\n------------");
            }
        }
        if (this.inboundRA == null) {
            buf.append("\n Inbound Resource Adapter NOT available");
        } else {
            buf.append("\n Inbound Resource Adapter Info : ");
            buf.append("\n Message Listeners Info : ");
            i = this.inboundRA.getMessageListeners().iterator();
            while (i.hasNext()) {
                buf.append("\n------------\n");
                MessageListener l = (MessageListener)i.next();
                buf.append("[Type : " + l.getMessageListenerType() + "], ");
                buf.append("[AS Class : " + l.getActivationSpecClass() + "]");
                buf.append("\n------------ ");
            }
        }
        if (this.adminObjects.size() == 0) {
            buf.append("\n Admin Objects NOT available");
        } else {
            buf.append("\n Admin Objects Info : ");
            i = this.adminObjects.iterator();
            while (i.hasNext()) {
                buf.append("\n------------\n");
                AdminObject a = (AdminObject)i.next();
                buf.append("[Type : " + a.getAdminObjectInterface() + "], ");
                buf.append("[Class : " + a.getAdminObjectClass() + "]");
                this.appendConfigProperties(a.getConfigProperties(), buf);
                buf.append("\n------------ ");
            }
        }
    }

    private StringBuffer appendConfigProperties(Set props, StringBuffer buf) {
        buf.append("\n------------");
        for (EnvironmentProperty config : props) {
            buf.append("[Name : " + config.getName() + "], ");
            buf.append("[Value: " + config.getValue() + "], ");
            buf.append("[Type : " + config.getType() + "]");
        }
        buf.append("\n------------");
        return buf;
    }

    public ModuleType getModuleType() {
        return ModuleType.RAR;
    }

    public MessageListener getSupportedMessageListener(String type) {
        if (this.inboundRA == null) {
            return null;
        }
        for (MessageListener l : this.inboundRA.getMessageListeners()) {
            if (!l.getMessageListenerType().equals(type)) continue;
            return l;
        }
        return null;
    }

    public boolean isMessageListenerSupported(String type) {
        throw new UnsupportedOperationException();
    }

    public SunConnector getSunDescriptor() {
        return this.sunConnector;
    }

    public void setSunDescriptor(SunConnector connector) {
        this.sunConnector = connector;
    }
}

