/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.shared.ArchivistUtils;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientJarMakerUtils {
    ClientJarMakerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void populateStubs(AbstractArchive target, ZipItem[] stubs) throws IOException {
        HashSet<String> elements = new HashSet<String>();
        for (ZipItem item : stubs) {
            if (elements.contains(item.getName())) continue;
            elements.add(item.getName());
            OutputStream os = null;
            InputStream is = null;
            try {
                os = target.putNextEntry(item.getName());
                is = new BufferedInputStream(new FileInputStream(item.getFile()));
                ArchivistUtils.copyWithoutClose(is, os);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    target.closeEntry();
                }
            }
        }
    }

    static void populateModuleJar(AbstractArchive original, AbstractArchive generated, AbstractArchive target) throws IOException {
        String excludeFileName = target.getArchiveUri().substring(target.getArchiveUri().lastIndexOf(File.separatorChar) + 1);
        HashSet<String> excludeList = new HashSet<String>();
        excludeList.add(excludeFileName);
        if (generated != null) {
            ClientJarMakerUtils.copyArchive(generated, target, excludeList);
        }
        ClientJarMakerUtils.copyArchive(original, target, excludeList);
        ClientJarMakerUtils.copy(original, target, "META-INF/MANIFEST.MF");
    }

    static void copyDeploymentDescriptors(Archivist archivist, AbstractArchive original, AbstractArchive generated, AbstractArchive target) throws IOException {
        AbstractArchive source = generated == null ? original : generated;
        ClientJarMakerUtils.copy(source, target, archivist.getStandardDDFile().getDeploymentDescriptorPath());
        ClientJarMakerUtils.copy(source, target, archivist.getConfigurationDDFile().getDeploymentDescriptorPath());
    }

    static List<String> getLibraryEntries(Application app, AbstractArchive appSource) throws IOException {
        File[] files;
        File appArchive = new File(appSource.getArchiveUri());
        Vector<String> excludeList = new Vector<String>();
        Iterator modules = app.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)modules.next();
            String moduleRoot = appArchive.getAbsolutePath() + File.separator + FileUtils.makeFriendlyFilename(md.getArchiveUri());
            excludeList.add(moduleRoot);
        }
        Vector<String> libraries = new Vector<String>();
        for (File file : files = appArchive.listFiles()) {
            if (!file.isDirectory() && file.getName().endsWith(".jar")) {
                libraries.add(file.getName());
                continue;
            }
            if (!file.isDirectory() || ClientJarMakerUtils.isExcluded(file.getAbsolutePath(), excludeList)) continue;
            ClientJarMakerUtils.getLibraryEntries(appArchive.getAbsolutePath(), file, libraries);
        }
        if (DeploymentLogger.get().isLoggable(Level.FINEST)) {
            for (String lib : libraries) {
                DeploymentLogger.get().fine("Adding to the appclient jar, library [" + lib + "]");
            }
        }
        return libraries;
    }

    private static boolean isExcluded(String path, List excludeList) {
        for (String exclude : excludeList) {
            if (!path.startsWith(exclude)) continue;
            return true;
        }
        return false;
    }

    private static void getLibraryEntries(String topDir, File directory, List libraries) {
        File[] files;
        for (File file : files = directory.listFiles()) {
            if (!file.isDirectory() && file.getName().endsWith(".jar")) {
                String entryName = file.getAbsolutePath().substring(topDir.length() + 1);
                libraries.add(entryName);
                continue;
            }
            if (!file.isDirectory()) continue;
            ClientJarMakerUtils.getLibraryEntries(topDir, file, libraries);
        }
    }

    static void copy(AbstractArchive source, AbstractArchive target, String entryName) throws IOException {
        block20: {
            InputStream is = null;
            OutputStream os = null;
            try {
                is = source.getEntry(entryName);
                if (is == null) break block20;
                try {
                    os = target.putNextEntry(entryName);
                }
                catch (ZipException ze) {
                    IOException closeEntryIOException = null;
                    if (os != null) {
                        try {
                            target.closeEntry();
                        }
                        catch (IOException ioe) {
                            closeEntryIOException = ioe;
                        }
                    }
                    if (is != null) {
                        is.close();
                    }
                    if (closeEntryIOException != null) {
                        throw closeEntryIOException;
                    }
                    return;
                }
                ArchivistUtils.copyWithoutClose(is, os);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                IOException closeEntryIOException = null;
                if (os != null) {
                    try {
                        target.closeEntry();
                    }
                    catch (IOException ioe) {
                        closeEntryIOException = ioe;
                    }
                }
                if (is != null) {
                    is.close();
                }
                if (closeEntryIOException != null) {
                    throw closeEntryIOException;
                }
            }
        }
    }

    private static void copyArchive(AbstractArchive source, AbstractArchive target, Set excludeList) {
        Enumeration e = source.entries();
        while (e.hasMoreElements()) {
            String entryName = (String)String.class.cast(e.nextElement());
            if (excludeList.contains(entryName)) continue;
            try {
                ClientJarMakerUtils.copy(source, target, entryName);
            }
            catch (IOException ioe) {}
        }
    }
}

