/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.node.DeploymentExtensionNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.EjbReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerFactoryReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerReferenceNode;
import com.sun.enterprise.deployment.node.EnvEntryNode;
import com.sun.enterprise.deployment.node.LifecycleCallbackNode;
import com.sun.enterprise.deployment.node.LocalizedInfoNode;
import com.sun.enterprise.deployment.node.MessageDestinationRefNode;
import com.sun.enterprise.deployment.node.ResourceEnvRefNode;
import com.sun.enterprise.deployment.node.ResourceRefNode;
import com.sun.enterprise.deployment.node.ServiceReferenceNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.node.ejb.AroundInvokeNode;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeploymentDescriptorNode
implements XMLNode {
    private static final String QNAME_SEPARATOR = ":";
    protected Hashtable handlers = null;
    private Hashtable addMethods = null;
    private XMLElement xmlTag;
    protected XMLNode parentNode = null;
    protected Object abstractDescriptor;
    protected static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeploymentDescriptorNode.class);

    public DeploymentDescriptorNode() {
        this.registerElementHandler(new XMLElement("description"), LocalizedInfoNode.class);
    }

    @Override
    public Object getDescriptor() {
        if (this.abstractDescriptor == null) {
            this.abstractDescriptor = DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.abstractDescriptor;
    }

    @Override
    public void addDescriptor(Object descriptor) {
        if (this.getParentNode() == null) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{descriptor, this.toString()});
            throw new RuntimeException("Cannot add " + descriptor + " to " + this.toString());
        }
        this.getParentNode().addDescriptor(descriptor);
    }

    protected void addNodeDescriptor(DeploymentDescriptorNode node) {
        block7: {
            if (this.getDescriptor() == null) {
                this.addDescriptor(node.getDescriptor());
                return;
            }
            String xmlRootTag = node.getXMLRootTag().getQName();
            if (this.addMethods != null && this.addMethods.containsKey(xmlRootTag)) {
                try {
                    Method toInvoke = this.getDescriptor().getClass().getMethod((String)this.addMethods.get(xmlRootTag), node.getDescriptor().getClass());
                    toInvoke.invoke(this.getDescriptor(), node.getDescriptor());
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t instanceof IllegalArgumentException) {
                        DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{node.getDescriptor().getClass(), this.getDescriptor().getClass()});
                        break block7;
                    }
                    t.printStackTrace();
                    DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{t.toString(), null});
                }
                catch (Throwable t) {
                    DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{node.getDescriptor().getClass(), this.getDescriptor().getClass()});
                    t.printStackTrace();
                    DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{t.toString(), null});
                }
            } else {
                this.addDescriptor(node.getDescriptor());
            }
        }
    }

    public void setParentNode(XMLNode parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public XMLNode getParentNode() {
        return this.parentNode;
    }

    protected void registerElementHandler(XMLElement element, Class handler) {
        if (this.handlers == null) {
            this.handlers = new Hashtable();
        }
        this.handlers.put(element.getQName(), handler);
    }

    protected void registerElementHandler(XMLElement element, Class handler, String addMethodName) {
        this.registerElementHandler(element, handler);
        if (this.addMethods == null) {
            this.addMethods = new Hashtable();
        }
        this.addMethods.put(element.getQName(), addMethodName);
    }

    protected XMLElement getXMLRootTag() {
        return this.xmlTag;
    }

    protected void setXMLRootTag(XMLElement element) {
        this.xmlTag = element;
    }

    @Override
    public XMLNode getHandlerFor(XMLElement element) {
        DeploymentDescriptorNode node;
        if (this.handlers == null) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{this, "No handler registered"});
            return null;
        }
        Class c = (Class)this.handlers.get(element.getQName());
        if (c == null) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{element.getQName(), "No handler registered"});
            return null;
        }
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINER)) {
            DOLUtils.getDefaultLogger().finer("New Handler requested for " + c);
        }
        try {
            node = (DeploymentDescriptorNode)c.newInstance();
            node.setParentNode(this);
            node.setXMLRootTag(element);
            node.getDescriptor();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return node;
    }

    @Override
    public void startElement(XMLElement element, Attributes attributes) {
        if (!this.getXMLRootTag().equals(element)) {
            return;
        }
        if (attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (DOLUtils.getDefaultLogger().isLoggable(Level.FINER)) {
                    DOLUtils.getDefaultLogger().finer("With attribute " + attributes.getQName(i));
                    DOLUtils.getDefaultLogger().finer("With value " + attributes.getValue(i));
                }
                if (this.setAttributeValue(element, new XMLElement(attributes.getQName(i)), attributes.getValue(i))) continue;
                this.setElementValue(new XMLElement(attributes.getQName(i)), attributes.getValue(i));
            }
        }
    }

    protected boolean setAttributeValue(XMLElement elementName, XMLElement attributeName, String value) {
        return attributeName.getQName().equals("id");
    }

    @Override
    public boolean endElement(XMLElement element) {
        boolean allDone = element.equals(this.getXMLRootTag());
        if (allDone) {
            this.postParsing();
            if (this.getParentNode() != null && this.getDescriptor() != null) {
                ((DeploymentDescriptorNode)this.getParentNode()).addNodeDescriptor(this);
            }
        }
        return allDone;
    }

    public void postParsing() {
    }

    @Override
    public boolean handlesElement(XMLElement element) {
        if (this.handlers == null) {
            return true;
        }
        Enumeration handlersIterator = this.handlers.keys();
        while (handlersIterator.hasMoreElements()) {
            String subElement = (String)handlersIterator.nextElement();
            if (!element.getQName().equals(subElement)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        Map dispatchTable = this.getDispatchTable();
        if (dispatchTable != null && dispatchTable.containsKey(element.getQName())) {
            if (dispatchTable.get(element.getQName()) == null) {
                if (DOLUtils.getDefaultLogger().isLoggable(Level.FINER)) {
                    DOLUtils.getDefaultLogger().finer("Deprecated element " + element.getQName() + " with value " + value + " is ignored");
                }
                return;
            }
            try {
                Object descriptor = this.getDescriptor();
                if (descriptor != null) {
                    this.setDescriptorInfo(descriptor, (String)dispatchTable.get(element.getQName()), value);
                } else {
                    DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{element.getQName(), value});
                }
                return;
            }
            catch (InvocationTargetException e) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{dispatchTable.get(element.getQName()), this.getDescriptor().getClass()});
                Throwable t = e.getTargetException();
                if (t instanceof IllegalArgumentException) {
                    DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{element, value});
                } else {
                    t.printStackTrace();
                    DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{t.toString(), null});
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{t.toString(), null});
            }
        }
        if (value.trim().length() != 0) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{element.getQName(), value});
        }
    }

    protected Map getDispatchTable() {
        HashMap<String, String> table = new HashMap<String, String>();
        table.put("description", "setDescription");
        return table;
    }

    protected void setDescriptorInfo(Object target, String methodName, String value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("in " + target.getClass() + "  method  " + methodName + " with  " + value);
        }
        try {
            Method toInvoke = target.getClass().getMethod(methodName, String.class);
            toInvoke.invoke(target, value);
        }
        catch (NoSuchMethodException e1) {
            try {
                Method toInvoke = target.getClass().getMethod(methodName, Integer.TYPE);
                toInvoke.invoke(target, Integer.valueOf(value));
            }
            catch (NumberFormatException nfe) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{this.getXMLPath().toString(), nfe.toString()});
            }
            catch (NoSuchMethodException e2) {
                Method toInvoke = target.getClass().getMethod(methodName, Boolean.TYPE);
                toInvoke.invoke(target, Boolean.valueOf(value));
            }
        }
    }

    @Override
    public String getXMLPath() {
        if (this.getParentNode() != null) {
            return this.getParentNode().getXMLPath() + "/" + this.getXMLRootTag().getQName();
        }
        return this.getXMLRootTag().getQName();
    }

    @Override
    public Node writeDescriptor(Node parent, Descriptor descriptor) {
        return this.writeDescriptor(parent, this.getXMLRootTag().getQName(), descriptor);
    }

    public Node writeDescriptor(Node parent, String nodeName, Descriptor descriptor) {
        Element node = DeploymentDescriptorNode.appendChild(parent, nodeName);
        return node;
    }

    protected static Document getOwnerDocument(Node node) {
        if (node instanceof Document) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static Element appendChild(Node parent, String elementName) {
        Element child = DeploymentDescriptorNode.getOwnerDocument(parent).createElement(elementName);
        parent.appendChild(child);
        return child;
    }

    public static Node appendTextChild(Node parent, String elementName, String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        Element child = DeploymentDescriptorNode.appendChild(parent, elementName);
        child.appendChild(DeploymentDescriptorNode.getOwnerDocument(child).createTextNode(text));
        return child;
    }

    public static Node appendTextChild(Node parent, String elementName, int value) {
        return DeploymentDescriptorNode.appendTextChild(parent, elementName, String.valueOf(value));
    }

    public static Node forceAppendTextChild(Node parent, String elementName, String text) {
        Element child = DeploymentDescriptorNode.appendChild(parent, elementName);
        if (text != null && text.length() != 0) {
            child.appendChild(DeploymentDescriptorNode.getOwnerDocument(child).createTextNode(text));
        }
        return child;
    }

    public static void setAttribute(Element parent, String elementName, String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        parent.setAttribute(elementName, text);
    }

    public static void setAttributeNS(Element element, String prefix, String namespaceURI) {
        String nsPrefix = prefix.equals("") ? "xmlns" : "xmlns:" + prefix;
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", nsPrefix, namespaceURI);
    }

    protected void writeEnvEntryDescriptors(Node parentNode, Iterator envEntries) {
        if (envEntries == null || !envEntries.hasNext()) {
            return;
        }
        EnvEntryNode subNode = new EnvEntryNode();
        while (envEntries.hasNext()) {
            EnvironmentProperty envProp = (EnvironmentProperty)envEntries.next();
            subNode.writeDescriptor(parentNode, "env-entry", envProp);
        }
    }

    protected void writeEjbReferenceDescriptors(Node parentNode, Iterator refs) {
        if (refs == null || !refs.hasNext()) {
            return;
        }
        EjbReferenceNode subNode = new EjbReferenceNode();
        HashSet<EjbReference> localRefDescs = new HashSet<EjbReference>();
        while (refs.hasNext()) {
            EjbReference ejbRef = (EjbReference)refs.next();
            if (ejbRef.isLocal()) {
                localRefDescs.add(ejbRef);
                continue;
            }
            subNode.writeDescriptor(parentNode, "ejb-ref", ejbRef);
        }
        for (EjbReference ejbRef : localRefDescs) {
            subNode.writeDescriptor(parentNode, "ejb-local-ref", ejbRef);
        }
    }

    protected void writeServiceReferenceDescriptors(Node parentNode, Iterator refs) {
        if (refs == null || !refs.hasNext()) {
            return;
        }
        ServiceReferenceNode serviceRefNode = new ServiceReferenceNode();
        while (refs.hasNext()) {
            ServiceReferenceDescriptor next = (ServiceReferenceDescriptor)refs.next();
            serviceRefNode.writeDescriptor(parentNode, "service-ref", next);
        }
    }

    protected void writeResourceRefDescriptors(Node parentNode, Iterator resRefs) {
        if (resRefs == null || !resRefs.hasNext()) {
            return;
        }
        ResourceRefNode subNode = new ResourceRefNode();
        while (resRefs.hasNext()) {
            ResourceReferenceDescriptor aResRef = (ResourceReferenceDescriptor)resRefs.next();
            subNode.writeDescriptor(parentNode, "resource-ref", aResRef);
        }
    }

    protected void writeResourceEnvRefDescriptors(Node parentNode, Iterator resRefs) {
        if (resRefs == null || !resRefs.hasNext()) {
            return;
        }
        ResourceEnvRefNode subNode = new ResourceEnvRefNode();
        while (resRefs.hasNext()) {
            JmsDestinationReferenceDescriptor aResRef = (JmsDestinationReferenceDescriptor)resRefs.next();
            subNode.writeDescriptor(parentNode, "resource-env-ref", aResRef);
        }
    }

    protected void writeMessageDestinationRefDescriptors(Node parentNode, Iterator msgDestRefs) {
        if (msgDestRefs == null || !msgDestRefs.hasNext()) {
            return;
        }
        MessageDestinationRefNode subNode = new MessageDestinationRefNode();
        while (msgDestRefs.hasNext()) {
            MessageDestinationReferenceDescriptor next = (MessageDestinationReferenceDescriptor)msgDestRefs.next();
            subNode.writeDescriptor(parentNode, "message-destination-ref", next);
        }
    }

    protected void writeEntityManagerReferenceDescriptors(Node parentNode, Iterator entityMgrRefs) {
        if (entityMgrRefs == null || !entityMgrRefs.hasNext()) {
            return;
        }
        EntityManagerReferenceNode subNode = new EntityManagerReferenceNode();
        while (entityMgrRefs.hasNext()) {
            EntityManagerReferenceDescriptor aEntityMgrRef = (EntityManagerReferenceDescriptor)entityMgrRefs.next();
            subNode.writeDescriptor(parentNode, "persistence-context-ref", aEntityMgrRef);
        }
    }

    protected void writeEntityManagerFactoryReferenceDescriptors(Node parentNode, Iterator entityMgrFactoryRefs) {
        if (entityMgrFactoryRefs == null || !entityMgrFactoryRefs.hasNext()) {
            return;
        }
        EntityManagerFactoryReferenceNode subNode = new EntityManagerFactoryReferenceNode();
        while (entityMgrFactoryRefs.hasNext()) {
            EntityManagerFactoryReferenceDescriptor aEntityMgrFactoryRef = (EntityManagerFactoryReferenceDescriptor)entityMgrFactoryRefs.next();
            subNode.writeDescriptor(parentNode, "persistence-unit-ref", aEntityMgrFactoryRef);
        }
    }

    protected void writeAroundInvokeDescriptors(Node parentNode, Iterator aroundInvokeDescs) {
        if (aroundInvokeDescs == null || !aroundInvokeDescs.hasNext()) {
            return;
        }
        AroundInvokeNode subNode = new AroundInvokeNode();
        while (aroundInvokeDescs.hasNext()) {
            LifecycleCallbackDescriptor next = (LifecycleCallbackDescriptor)aroundInvokeDescs.next();
            subNode.writeDescriptor(parentNode, "around-invoke", next);
        }
    }

    protected void writePostActivateDescriptors(Node parentNode, Iterator postActivateDescs) {
        if (postActivateDescs == null || !postActivateDescs.hasNext()) {
            return;
        }
        LifecycleCallbackNode subNode = new LifecycleCallbackNode();
        while (postActivateDescs.hasNext()) {
            LifecycleCallbackDescriptor next = (LifecycleCallbackDescriptor)postActivateDescs.next();
            subNode.writeDescriptor(parentNode, "post-activate", next);
        }
    }

    protected void writePrePassivateDescriptors(Node parentNode, Iterator prePassivateDescs) {
        if (prePassivateDescs == null || !prePassivateDescs.hasNext()) {
            return;
        }
        LifecycleCallbackNode subNode = new LifecycleCallbackNode();
        while (prePassivateDescs.hasNext()) {
            LifecycleCallbackDescriptor next = (LifecycleCallbackDescriptor)prePassivateDescs.next();
            subNode.writeDescriptor(parentNode, "pre-passivate", next);
        }
    }

    protected void writePostConstructDescriptors(Node parentNode, Iterator<LifecycleCallbackDescriptor> postConstructDescs) {
        if (postConstructDescs == null || !postConstructDescs.hasNext()) {
            return;
        }
        LifecycleCallbackNode subNode = new LifecycleCallbackNode();
        while (postConstructDescs.hasNext()) {
            LifecycleCallbackDescriptor next = postConstructDescs.next();
            subNode.writeDescriptor(parentNode, "post-construct", next);
        }
    }

    protected void writePreDestroyDescriptors(Node parentNode, Iterator<LifecycleCallbackDescriptor> preDestroyDescs) {
        if (preDestroyDescs == null || !preDestroyDescs.hasNext()) {
            return;
        }
        LifecycleCallbackNode subNode = new LifecycleCallbackNode();
        while (preDestroyDescs.hasNext()) {
            LifecycleCallbackDescriptor next = preDestroyDescs.next();
            subNode.writeDescriptor(parentNode, "pre-destroy", next);
        }
    }

    protected void writeLocalizedDescriptions(Node node, Descriptor desc) {
        LocalizedInfoNode localizedNode = new LocalizedInfoNode();
        localizedNode.writeLocalizedMap(node, "description", desc.getLocalizedDescriptions());
    }

    protected void writeJNDIEnvironmentRefs(Node node, JndiNameEnvironment descriptor) {
        this.writeEnvEntryDescriptors(node, descriptor.getEnvironmentProperties().iterator());
        this.writeEjbReferenceDescriptors(node, descriptor.getEjbReferenceDescriptors().iterator());
        this.writeServiceReferenceDescriptors(node, descriptor.getServiceReferenceDescriptors().iterator());
        this.writeResourceRefDescriptors(node, descriptor.getResourceReferenceDescriptors().iterator());
        this.writeResourceEnvRefDescriptors(node, descriptor.getJmsDestinationReferenceDescriptors().iterator());
        this.writeMessageDestinationRefDescriptors(node, descriptor.getMessageDestinationReferenceDescriptors().iterator());
        this.writeEntityManagerReferenceDescriptors(node, descriptor.getEntityManagerReferenceDescriptors().iterator());
        this.writeEntityManagerFactoryReferenceDescriptors(node, descriptor.getEntityManagerFactoryReferenceDescriptors().iterator());
        this.writePostConstructDescriptors(node, descriptor.getPostConstructDescriptors().iterator());
        this.writePreDestroyDescriptors(node, descriptor.getPreDestroyDescriptors().iterator());
    }

    private void writeDeploymentExtensionDescriptor(Node parentNode, Descriptor descriptor) {
        Iterator itr = descriptor.getDeploymentExtensions();
        if (itr == null) {
            return;
        }
        DeploymentExtensionNode subNode = new DeploymentExtensionNode();
        subNode.writeDescriptor(parentNode, itr);
    }

    protected void addNamespaceDeclaration(Element node, Descriptor descriptor) {
        Map prefixMapping;
        Map map = prefixMapping = descriptor != null ? descriptor.getPrefixMapping() : null;
        if (prefixMapping != null) {
            for (String prefix : prefixMapping.keySet()) {
                String namespaceURI = (String)prefixMapping.get(prefix);
                DeploymentDescriptorNode.setAttributeNS(node, prefix, namespaceURI);
            }
        }
    }

    @Override
    public void addPrefixMapping(String prefix, String uri) {
        Object o = this.getDescriptor();
        if (o instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)o;
            descriptor.addPrefixMapping(prefix, uri);
        }
    }

    @Override
    public String resolvePrefix(XMLElement element, String prefix) {
        return element.getPrefixURIMapping(prefix);
    }

    public String getPrefixFromQName(String qname) {
        StringTokenizer tokenizer = new StringTokenizer(qname, QNAME_SEPARATOR);
        return tokenizer.countTokens() == 2 ? tokenizer.nextToken() : "";
    }

    public String getLocalPartFromQName(String qname) {
        StringTokenizer tokenizer = new StringTokenizer(qname, QNAME_SEPARATOR);
        String localPart = qname;
        if (tokenizer.countTokens() == 2) {
            tokenizer.nextToken();
            localPart = tokenizer.nextToken();
        }
        return localPart;
    }

    public String composeQNameValue(String prefix, String localPart) {
        return prefix != null && !prefix.equals("") ? prefix + QNAME_SEPARATOR + localPart : localPart;
    }

    public void appendQNameChild(String elementName, Node parent, String namespaceUri, String localPart, String prefix) {
        if (prefix == null) {
            prefix = elementName + "_ns__";
        }
        String elementValue = this.composeQNameValue(prefix, localPart);
        Element element = (Element)DeploymentDescriptorNode.appendTextChild(parent, elementName, elementValue);
        DeploymentDescriptorNode.setAttributeNS(element, prefix, namespaceUri);
    }
}

