/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Constants;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.util.DiagnosticServiceHelper;
import com.sun.enterprise.diagnostics.util.XmlUtils;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainXMLHelper {
    private Document configDoc;
    private static final String PASSWORD = "password";
    private static final String NAME = "name";
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    private String repositoryDir;

    public DomainXMLHelper(String repositoryDir) {
        this.repositoryDir = repositoryDir;
    }

    public List<String> getAttrs() throws DiagnosticException {
        if (this.configDoc == null) {
            this.loadXML();
        }
        ArrayList<String> list = new ArrayList<String>(5);
        XmlUtils.getAttributes(this.configDoc.getDocumentElement(), PASSWORD, list);
        return list;
    }

    private void loadXML() throws DiagnosticException {
        try {
            String configFile = this.repositoryDir + Constants.DOMAIN_XML;
            String configDtdFile = DiagnosticServiceHelper.getInstallationRoot() + Constants.DOMAIN_XML_DTD;
            logger.log(Level.FINE, "diagnostic-service.loadxml_configfile", configFile);
            this.configDoc = XmlUtils.loadXML(configFile, configDtdFile);
        }
        catch (SAXException ex) {
            logger.log(Level.SEVERE, "diagnostic-service.error_loading_xml", ex.getMessage());
            throw new DiagnosticException(ex.getMessage());
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "diagnostic-service.error_loading_xml", ioe.getMessage());
            throw new DiagnosticException(ioe.getMessage());
        }
        catch (ParserConfigurationException pce) {
            logger.log(Level.SEVERE, "diagnostic-service.error_loading_xml", pce.getMessage());
            throw new DiagnosticException(pce.getMessage());
        }
    }

    public Element getElement(String tagName, String elementName) throws DiagnosticException {
        NodeList list;
        if (tagName == null && elementName == null) {
            return null;
        }
        if (this.configDoc == null) {
            this.loadXML();
        }
        if ((list = this.configDoc.getDocumentElement().getElementsByTagName(tagName)) != null) {
            int length = list.getLength();
            Element element = null;
            for (int i = 0; i < length; ++i) {
                element = (Element)list.item(i);
                if (!element.getAttribute(NAME).equals(elementName)) continue;
                return element;
            }
        }
        return null;
    }

    public Element getElement(Element element, String tagName) {
        NodeList list = element.getElementsByTagName(tagName);
        if (list != null) {
            return (Element)list.item(0);
        }
        return null;
    }

    public String getAttribute(Element element, String attrName) {
        if (element != null) {
            return element.getAttribute(attrName);
        }
        return null;
    }
}

