/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.Defaults;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.ServiceConfig;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.FileData;
import com.sun.enterprise.diagnostics.util.FileUtils;
import com.sun.enterprise.diagnostics.util.LogNameComparator;
import com.sun.enterprise.diagnostics.util.LogNameFilter;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogCollector
implements Collector {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private ServiceConfig config;
    private Date startDate;
    private Date endDate;
    private String destFolder;
    private boolean partialPrevEntry = false;
    private boolean prevEntryCopied = false;
    private String logFileName;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public LogCollector(Date startDate, Date endDate, String destFolder, ServiceConfig config) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.destFolder = destFolder;
        this.config = config;
    }

    public LogCollector(String destFolder, String logFile) {
        this.destFolder = destFolder;
        this.logFileName = logFile;
    }

    public Data capture() throws DiagnosticException {
        int noOfCapturedEntries = 0;
        int maxNoOfEntries = 500;
        int minLogLevel = Defaults.MIN_LOG_LEVEL;
        if (this.config != null) {
            maxNoOfEntries = this.config.getMaxNoOfEntries();
            minLogLevel = this.config.getMinLogLevel();
            this.logFileName = this.config.getLogFile();
            if (this.logFileName.indexOf(this.config.getRepositoryDir()) == -1) {
                this.logFileName = this.config.getRepositoryDir() + this.logFileName;
            }
        }
        String destLogFile = this.destFolder + Defaults.DEST_LOG_FILE;
        try {
            PrintWriter out;
            List<File> logFiles;
            if (this.startDate != null) {
                String fileNamePrefix;
                File logFile = new File(this.logFileName);
                File logDir = new File(logFile.getParent());
                logFiles = FileUtils.getFileListing(logDir, false, new LogNameFilter(fileNamePrefix = logFile.getName(), this.startDate, this.endDate), new LogNameComparator());
                if (logFiles != null && logFiles.size() == 0) {
                    logFiles = Arrays.asList(new File(this.logFileName));
                }
            } else {
                logFiles = Arrays.asList(new File(this.logFileName));
            }
            logger.log(Level.FINE, "diagnostic-service.dest_log_file", new Object[]{destLogFile});
            Iterator<File> filesIterator = logFiles.iterator();
            try {
                out = new PrintWriter(new BufferedWriter(new FileWriter(destLogFile)));
            }
            catch (IOException ioe1) {
                File parent = new File(destLogFile).getParentFile();
                parent.mkdirs();
                out = new PrintWriter(new BufferedWriter(new FileWriter(destLogFile)));
            }
            while (filesIterator.hasNext() && noOfCapturedEntries < maxNoOfEntries) {
                String logEntry;
                BufferedReader inFile = new BufferedReader(new FileReader(filesIterator.next()));
                while ((logEntry = inFile.readLine()) != null) {
                    try {
                        if (!this.isValid(logEntry, this.startDate, this.endDate, minLogLevel)) continue;
                        out.println(logEntry);
                        if (!this.partialPrevEntry) {
                            ++noOfCapturedEntries;
                        }
                        if (noOfCapturedEntries < maxNoOfEntries) continue;
                        break;
                    }
                    catch (Exception pe) {
                    }
                }
                out.flush();
            }
            return new FileData(destLogFile, "log info");
        }
        catch (FileNotFoundException fnfe) {
            throw new DiagnosticException(fnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new DiagnosticException(ioe.getMessage());
        }
    }

    private boolean isValid(String entry, Date startDate, Date endDate, int minLogLevel) throws ParseException {
        Date entryDate;
        if (entry.length() <= 0) {
            return false;
        }
        if (this.partialPrevEntry) {
            if (this.hasEndOfEntry(entry)) {
                this.partialPrevEntry = false;
            }
            return this.prevEntryCopied;
        }
        int logLevelSepBeginIndex = entry.indexOf(124, 3) + 1;
        String entryLogLevelStr = entry.substring(logLevelSepBeginIndex, entry.indexOf(124, logLevelSepBeginIndex));
        int entryLogLevel = Level.parse(entryLogLevelStr).intValue();
        this.prevEntryCopied = entryLogLevel >= minLogLevel ? (startDate != null && endDate != null ? (entryDate = dateFormat.parse(entry.substring(3, 13))).compareTo(startDate) >= 0 && entryDate.compareTo(endDate) <= 0 : true) : false;
        if (!this.hasEndOfEntry(entry)) {
            this.partialPrevEntry = true;
        }
        return this.prevEntryCopied;
    }

    private boolean hasEndOfEntry(String entry) {
        return entry.indexOf("|#]") > -1;
    }
}

