/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.util;

import com.sun.enterprise.diagnostics.DiagnosticException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogNameFilter
implements FilenameFilter {
    private Date startDate;
    private Date endDate;
    private String fileNamePrefix;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public LogNameFilter(String fileName, Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.fileNamePrefix = fileName;
    }

    public boolean accept(File aDir, String fileName) {
        if (aDir == null || fileName == null) {
            return false;
        }
        if (fileName.indexOf(this.fileNamePrefix) < 0) {
            return false;
        }
        int datePatternIndex = fileName.indexOf(95);
        if (datePatternIndex > 0) {
            try {
                Date fileDate = dateFormat.parse(fileName.substring(datePatternIndex + 1, datePatternIndex + 11));
                return fileDate.compareTo(this.startDate) >= 0 && fileDate.compareTo(this.endDate) <= 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        try {
            return this.endDate.after(this.getDateOfFirstLogEntry(aDir, fileName));
        }
        catch (DiagnosticException de) {
            return false;
        }
    }

    private Date getDateOfFirstLogEntry(File aDir, String fileName) throws DiagnosticException {
        if (aDir == null || fileName == null) {
            return null;
        }
        try {
            File file = new File(aDir, fileName);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String firstEntry = reader.readLine();
            return dateFormat.parse(firstEntry.substring(3, 10));
        }
        catch (FileNotFoundException fnf) {
            throw new DiagnosticException(fnf.getMessage());
        }
        catch (IOException io) {
            throw new DiagnosticException(io.getMessage());
        }
        catch (ParseException pe) {
            throw new DiagnosticException(pe.getMessage());
        }
    }
}

