/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.loader;

import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLoaderUtils {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");

    public static ClassLoader getClassLoader(File[] dirs, File[] jarDirs, ClassLoader parent) throws IOException {
        URLClassLoader loader = null;
        URL[] urls = ClassLoaderUtils.getUrls(dirs, jarDirs);
        if (urls != null) {
            loader = parent != null ? new URLClassLoader(urls, parent) : new URLClassLoader(urls);
        }
        return loader;
    }

    public static URL[] getUrls(File[] dirs, File[] jarDirs) throws IOException {
        int i;
        URL[] urls = null;
        ArrayList<URL> list = new ArrayList<URL>();
        if (dirs != null) {
            for (i = 0; i < dirs.length; ++i) {
                File dir = dirs[i];
                if (!dir.isDirectory() && !dir.canRead()) continue;
                URL url = dir.toURI().toURL();
                list.add(url);
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Adding directory to class path:" + url.toString());
            }
        }
        if (jarDirs != null) {
            for (i = 0; i < jarDirs.length; ++i) {
                File jarDir = jarDirs[i];
                if (!jarDir.isDirectory() && !jarDir.canRead()) continue;
                File[] files = jarDir.listFiles();
                for (int j = 0; j < files.length; ++j) {
                    File jar = files[j];
                    if (!FileUtils.isJar(jar) && !FileUtils.isZip(jar)) continue;
                    list.add(jar.toURI().toURL());
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "Adding jar to class path:" + jar.toURL());
                }
            }
        }
        if (list.size() > 0) {
            urls = new URL[list.size()];
            urls = list.toArray(urls);
        }
        return urls;
    }

    public static List getUrlList(File[] dirs, File[] jarDirs) throws IOException {
        return ClassLoaderUtils.getUrlList(dirs, jarDirs, false);
    }

    public static List getUrlList(File[] dirs, File[] jarDirs, boolean ignoreZip) throws IOException {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        if (dirs != null) {
            for (i = 0; i < dirs.length; ++i) {
                File dir = dirs[i];
                if (!dir.isDirectory() && !dir.canRead()) continue;
                list.add(dir.getCanonicalPath());
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Adding directory to class path:" + dir.getCanonicalPath());
            }
        }
        if (jarDirs != null) {
            for (i = 0; i < jarDirs.length; ++i) {
                File jarDir = jarDirs[i];
                if (!jarDir.isDirectory() && !jarDir.canRead()) continue;
                File[] files = jarDir.listFiles();
                for (int j = 0; j < files.length; ++j) {
                    File jar = files[j];
                    if (!FileUtils.isJar(jar) && (ignoreZip || !FileUtils.isZip(jar))) continue;
                    list.add(jar.getCanonicalPath());
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "Adding jar to class path:" + jar.getCanonicalPath());
                }
            }
        }
        return list;
    }

    public static URL[] getUrlsFromClasspath(String classpath) {
        URL[] ret;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (classpath == null) {
            return (URL[])urls.toArray();
        }
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            try {
                File f = new File(st.nextToken());
                urls.add(f.toURI().toURL());
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "loader.unexpected_error_while_creating_urls", e);
            }
        }
        if (urls.size() > 0) {
            ret = new URL[urls.size()];
            ret = urls.toArray(ret);
        } else {
            ret = new URL[]{};
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            URL[] urls = ClassLoaderUtils.getUrls(new File[]{new File(args[0])}, new File[]{new File(args[1])});
            for (int i = 0; i < urls.length; ++i) {
                System.out.println(urls[i]);
            }
            URLClassLoader loader = (URLClassLoader)ClassLoaderUtils.getClassLoader(new File[]{new File(args[0])}, new File[]{new File(args[1])}, null);
            Class<?> c = loader.loadClass(args[2]);
            System.out.println("Loaded: " + c.getName());
            System.out.println("Loaded class has the following methods...");
            Method[] m = c.getDeclaredMethods();
            for (int i = 0; i < m.length; ++i) {
                System.out.println(m[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

