/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.agent;

import com.sun.enterprise.management.agent.ListenerRegistry;
import com.sun.enterprise.management.util.J2EEModuleUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.j2ee.ListenerRegistration;

public class MEJBUtility {
    private MBeanServer server;
    private ListenerRegistry listenerRegistry = null;
    private static MEJBUtility mejbUtility = null;

    private MEJBUtility() {
        ArrayList mbservers = (ArrayList)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MBeanServerFactory.findMBeanServer(null);
            }
        });
        this.server = mbservers.isEmpty() ? null : (MBeanServer)mbservers.get(0);
    }

    public static MEJBUtility getMEJBUtility() {
        if (mejbUtility == null) {
            mejbUtility = new MEJBUtility();
        }
        return mejbUtility;
    }

    public Set queryNames(ObjectName name, QueryExp query) throws Exception {
        return this.server.queryNames(name, query);
    }

    public boolean isRegistered(ObjectName name) throws Exception {
        return this.server.isRegistered(name);
    }

    public Integer getMBeanCount() throws Exception {
        return this.server.getMBeanCount();
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, RemoteException {
        return this.server.getMBeanInfo(name);
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, RemoteException {
        return this.server.getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, RemoteException {
        return this.server.getAttributes(name, attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, RemoteException {
        this.server.setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, RemoteException {
        return this.server.setAttributes(name, attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, RemoteException {
        return this.server.invoke(name, operationName, params, signature);
    }

    public String getDefaultDomain() {
        return this.server.getDefaultDomain();
    }

    public ListenerRegistration getListenerRegistry() {
        if (this.listenerRegistry == null) {
            try {
                this.listenerRegistry = new ListenerRegistry(InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {
                this.listenerRegistry = new ListenerRegistry(J2EEModuleUtil.getDomainName());
            }
        }
        return this.listenerRegistry;
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException, RemoteException {
        return this.server.instantiate(className);
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException, RemoteException {
        return this.server.instantiate(className, loaderName);
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException, RemoteException {
        return this.server.instantiate(className, params, signature);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException, RemoteException {
        return this.server.instantiate(className, loaderName, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, RemoteException {
        return this.server.createMBean(className, name);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, RemoteException {
        return this.server.createMBean(className, name, loaderName);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, RemoteException {
        return this.server.createMBean(className, name, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, RemoteException {
        return this.server.createMBean(className, name, loaderName, params, signature);
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, RemoteException {
        return this.server.registerMBean(object, name);
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, RemoteException {
        this.server.unregisterMBean(name);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, RemoteException {
        return this.server.getObjectInstance(name);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws RemoteException {
        return this.server.queryMBeans(name, query);
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, RemoteException {
        this.server.addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, RemoteException {
        this.server.addNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, RemoteException {
        this.server.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, RemoteException {
        this.server.removeNotificationListener(name, listener);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, RemoteException {
        return this.server.isInstanceOf(name, className);
    }
}

