/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.selfmanagement.reconfig;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.selfmanagement.ManagementRuleEvent;
import com.sun.enterprise.admin.event.selfmanagement.ManagementRuleEventListener;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigDelete;
import com.sun.enterprise.config.ConfigSet;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.serverbeans.Action;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ManagementRule;
import com.sun.enterprise.config.serverbeans.ManagementRules;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.management.selfmanagement.SelfManagementService;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ManagementRuleReconfig
implements ManagementRuleEventListener {
    private static SelfManagementService service = SelfManagementService.getService();
    private static Logger _logger = null;

    public void handleCreate(ManagementRuleEvent event) throws AdminEventListenerException {
        _logger.log(Level.FINE, "sgmt.reconfig_handlecreatereceived");
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            Object configAdd = null;
            ConfigChange configChange = null;
            ArrayList configChangeList = event.getConfigChangeList();
            ManagementRule rule = null;
            String xpath = null;
            String pXPath = null;
            for (int i = 0; i < configChangeList.size(); ++i) {
                configChange = (ConfigChange)configChangeList.get(i);
                if (configChange instanceof ConfigAdd) {
                    _logger.log(Level.INFO, "sgmt.reconfig_handlecreaterulereceived");
                    xpath = configChange.getXPath();
                    if (xpath == null) continue;
                    _logger.log(Level.INFO, "sgmt.reconfig_handlexpath", xpath);
                    rule = (ManagementRule)configContext.exactLookup(xpath);
                    if (rule.isEnabled()) {
                        service.addRule(rule, configContext);
                        continue;
                    }
                    service.addDisabledRule(rule);
                    continue;
                }
                if (!(configChange instanceof ConfigSet)) continue;
                pXPath = configChange.getParentXPath();
                String name = configChange.getName();
                if (!name.equals("Action")) continue;
                _logger.log(Level.INFO, "smgt.handleactionadd", pXPath);
                rule = (ManagementRule)configContext.exactLookup(pXPath);
                service.handleActionAdd(rule, configContext);
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void handleUpdate(ManagementRuleEvent event) throws AdminEventListenerException {
        _logger.log(Level.INFO, "sgmt.reconfig_handleupdatereceived");
        try {
            ConfigContext configContext = event.getConfigContext();
            ConfigContext oldConfigContext = event.getOldConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            ConfigUpdate configUp = null;
            ArrayList configChangeList = event.getConfigChangeList();
            String xPath = null;
            for (int i = 0; i < configChangeList.size(); ++i) {
                configUp = (ConfigUpdate)configChangeList.get(i);
                xPath = configUp.getXPath();
                if (xPath == null) continue;
                _logger.log(Level.INFO, "sgmt.handleupdatexpath", xPath);
                ConfigBean object = configContext.exactLookup(xPath);
                if (object instanceof ManagementRules) {
                    ManagementRules rules = (ManagementRules)object;
                    service.handleRulesUpdate(configContext, configUp);
                    continue;
                }
                if (object instanceof ManagementRule) {
                    ManagementRule rule = (ManagementRule)oldConfigContext.exactLookup(xPath);
                    service.handleRuleUpdate(rule, configUp, configContext);
                    continue;
                }
                if (!(object instanceof Action)) continue;
                String pXPath = xPath.substring(0, xPath.lastIndexOf("/"));
                ManagementRule rule = (ManagementRule)configContext.exactLookup(pXPath);
                service.handleActionUpdate(rule, configUp);
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void handleDelete(ManagementRuleEvent event) throws AdminEventListenerException {
        _logger.log(Level.INFO, "sgmt.reconfig_handledeletereceived");
        try {
            ConfigContext configContext = event.getOldConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            ConfigDelete configDel = null;
            ArrayList configChangeList = event.getConfigChangeList();
            ManagementRule rule = null;
            String xpath = null;
            for (int i = 0; i < configChangeList.size(); ++i) {
                configDel = (ConfigDelete)configChangeList.get(i);
                xpath = configDel.getXPath();
                if (xpath == null) continue;
                _logger.log(Level.INFO, "sgmt.reconfig_handledelxpath", xpath);
                ConfigBean object = configContext.exactLookup(xpath);
                if (object instanceof Action || !(object instanceof ManagementRule)) continue;
                rule = (ManagementRule)object;
                String ruleName = rule.getName();
                service.deleteRule(ruleName);
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");
    }
}

