/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.monitor;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.JDBCConnectionPoolStats;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.resource.MonitorableResourcePool;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.resource.monitor.JDBCConnectionPoolStatsImpl;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ResourcesUtil;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.Stats;

public class JDBCPoolMonitoringLevelListener
implements MonitoringLevelListener {
    private PoolManager poolManager_;
    private MonitoringRegistry registry_;
    private static final MonitoringLevel OFF = MonitoringLevel.OFF;
    private static final MonitoringLevel HIGH = MonitoringLevel.HIGH;
    private static final MonitoringLevel LOW = MonitoringLevel.LOW;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public void setLevel(MonitoringLevel level) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, Stats handback) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType type) {
        if (from == to) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServerContext ctxt = ApplicationServer.getServerContext();
                if (ctxt != null) {
                    JDBCPoolMonitoringLevelListener.this.registry_ = ctxt.getMonitoringRegistry();
                }
                return null;
            }
        });
        if ((from == OFF || from == LOW) && to == HIGH) {
            this.logFine("Changing level from " + from + "  to HIGH");
            this.transitionToHigh();
        }
        if ((from == HIGH || from == LOW) && to == OFF) {
            this.logFine("Switching level from " + from + " to OFF");
            this.switchOffMonitoring();
        }
        if ((from == OFF || from == HIGH) && to == LOW) {
            this.logFine("Changing level from " + from + " to LOW");
            this.transitionToLow();
        }
    }

    private MonitorableResourcePool[] getPoolList() {
        ResourcesUtil resUtil = ResourcesUtil.getInstance();
        JdbcConnectionPool[] jp = resUtil.getJdbcConnectionPools();
        if (jp == null) {
            return null;
        }
        MonitorableResourcePool[] pools = new MonitorableResourcePool[jp.length];
        ConcurrentHashMap poolTable = this.getPoolManager().getPoolTable();
        for (int i = 0; i < jp.length; ++i) {
            ResourcePool p = (ResourcePool)poolTable.get(jp[i].getName());
            if (p == null || !(p instanceof MonitorableResourcePool)) continue;
            pools[i] = (MonitorableResourcePool)p;
        }
        return pools;
    }

    private PoolManager getPoolManager() {
        return Switch.getSwitch().getPoolManager();
    }

    private void transitionToHigh() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MonitorableResourcePool[] pools = JDBCPoolMonitoringLevelListener.this.getPoolList();
                if (pools == null) {
                    return null;
                }
                for (int i = 0; i < pools.length; ++i) {
                    if (pools[i] == null) continue;
                    try {
                        JDBCConnectionPoolStatsImpl stats = new JDBCConnectionPoolStatsImpl(pools[i]);
                        JDBCPoolMonitoringLevelListener.this.getPoolManager().setMonitoringEnabledHigh(pools[i].getPoolName());
                        JDBCPoolMonitoringLevelListener.this.registry_.registerJDBCConnectionPoolStats((JDBCConnectionPoolStats)stats, pools[i].getPoolName(), null);
                        continue;
                    }
                    catch (Exception mre) {
                        try {
                            _logger.log(Level.INFO, "poolmon.cannot_reg: " + pools[i].getPoolName(), mre.getMessage());
                            JDBCPoolMonitoringLevelListener.this.getPoolManager().disableMonitoring(pools[i].getPoolName());
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                return null;
            }
        });
    }

    private void switchOffMonitoring() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MonitorableResourcePool[] pools = JDBCPoolMonitoringLevelListener.this.getPoolList();
                if (pools == null) {
                    return null;
                }
                for (int i = 0; i < pools.length; ++i) {
                    if (pools[i] == null) continue;
                    try {
                        JDBCPoolMonitoringLevelListener.this.registry_.unregisterJDBCConnectionPoolStats(pools[i].getPoolName());
                        JDBCPoolMonitoringLevelListener.this.getPoolManager().disableMonitoring(pools[i].getPoolName());
                        continue;
                    }
                    catch (Exception mre) {
                        _logger.log(Level.WARNING, "poolmon.cannot_unreg: " + pools[i].getPoolName(), mre.getMessage());
                    }
                }
                return null;
            }
        });
    }

    private void transitionToLow() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MonitorableResourcePool[] pools = JDBCPoolMonitoringLevelListener.this.getPoolList();
                if (pools == null) {
                    return null;
                }
                for (int i = 0; i < pools.length; ++i) {
                    if (pools[i] == null) continue;
                    try {
                        JDBCConnectionPoolStatsImpl stats = new JDBCConnectionPoolStatsImpl(pools[i]);
                        JDBCPoolMonitoringLevelListener.this.getPoolManager().setMonitoringEnabledLow(pools[i].getPoolName());
                        JDBCPoolMonitoringLevelListener.this.registry_.registerJDBCConnectionPoolStats((JDBCConnectionPoolStats)stats, pools[i].getPoolName(), null);
                        continue;
                    }
                    catch (Exception mre) {
                        try {
                            _logger.log(Level.INFO, "poolmon.cannot_reg: " + pools[i].getPoolName(), mre.getMessage());
                            JDBCPoolMonitoringLevelListener.this.getPoolManager().disableMonitoring(pools[i].getPoolName());
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                return null;
            }
        });
    }

    private void logFine(String msg) {
        if (msg != null && _logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }
}

