/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.ModuleLogLevels;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.logging.BaseLogManager;
import com.sun.enterprise.server.logging.DeploymentAuditLogHandler;
import com.sun.enterprise.server.logging.FileandSyslogHandler;
import com.sun.enterprise.server.logging.LogRotationTimer;
import com.sun.enterprise.server.logging.LogRotationTimerTask;
import com.sun.enterprise.server.logging.ModuleToLoggerNameMapper;
import com.sun.enterprise.server.logging.SystemLogHandler;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerLogManager
extends BaseLogManager {
    private static FileandSyslogHandler handlerSingleton;
    private static ConsoleHandler consoleHandler;
    private static SystemLogHandler syslogHandler;
    private static DeploymentAuditLogHandler deploymentAuditHandler;
    private static boolean syslogLibraryLoadError;
    private static Handler customHandler;
    private static Filter customFilter;
    private static ServerLogManager thisInstance;
    private static List listOfUnInitializedLoggers;
    private static Boolean verboseMode;
    private static boolean customFilterError;
    private static boolean customHandlerError;
    private static final String SUN_OS = "SunOS";
    private static final String LINUX_OS = "Linux";
    private static final String OS_NAME_PROPERTY = "os.name";
    private Object lockObj = new Object();
    private static final String ORG_APACHE_CATALINA = "org.apache.catalina.";
    private static final String ORG_APACHE_COYOTE = "org.apache.coyote.";
    private static final String ORG_APACHE_JASPER = "org.apache.jasper.";
    private static final String SYNCHRONIZATION = "javax.ee.enterprise.system.tools.synchronization";

    public ServerLogManager() {
        thisInstance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeLogger(Logger logger) {
        Object object = this.lockObj;
        synchronized (object) {
            this.internalInitializeLogger(logger);
            if (ServerLogManager.getLogService() == null) {
                listOfUnInitializedLoggers.add(logger);
            }
        }
    }

    private void internalInitializeLogger(final Logger logger) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Level logLevel;
                Handler[] h = logger.getHandlers();
                for (int i = 0; i < h.length; ++i) {
                    logger.removeHandler(h[i]);
                }
                if (logger.getName().equals("javax.enterprise.system.tools.deployment.audit")) {
                    logger.addHandler(ServerLogManager.getDeploymentAuditHandler());
                    logger.setUseParentHandlers(false);
                }
                if (logger.getName().intern() == "".intern()) {
                    Handler syslogHandler;
                    logger.addHandler(ServerLogManager.getFileandSyslogHandler());
                    if (ServerLogManager.logToStderr()) {
                        logger.addHandler(ServerLogManager.getConsoleHandler());
                    }
                    if (ServerLogManager.logToSyslog() && (syslogHandler = ServerLogManager.getSyslogHandler()) != null) {
                        logger.addHandler(syslogHandler);
                    }
                    logger.setUseParentHandlers(false);
                }
                if ((logLevel = ServerLogManager.getConfiguredLogLevel(logger.getName())) != null) {
                    logger.setLevel(logLevel);
                }
                ServerLogManager.this.postInitializeLogger(logger);
                return null;
            }
        });
    }

    private void postInitializeLogger(final Logger logger) {
        final Handler customHandler = ServerLogManager.getCustomHandler();
        final Filter customFilter = ServerLogManager.getCustomFilter();
        if (customHandler == null && customFilter == null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (customHandler != null) {
                    logger.addHandler(customHandler);
                }
                if (customFilter != null) {
                    logger.setFilter(customFilter);
                }
                return null;
            }
        });
    }

    public static void initializeServerLogger(Logger logger) {
    }

    private static synchronized Handler getFileandSyslogHandler() {
        if (handlerSingleton == null) {
            try {
                handlerSingleton = FileandSyslogHandler.getInstance();
                handlerSingleton.setLevel(Level.ALL);
            }
            catch (Exception e) {
                new ErrorManager().error("Exception caught in getHandler ", e, 0);
            }
        }
        return handlerSingleton;
    }

    private static synchronized Handler getDeploymentAuditHandler() {
        if (deploymentAuditHandler == null) {
            try {
                deploymentAuditHandler = DeploymentAuditLogHandler.getInstance();
                deploymentAuditHandler.setLevel(DeploymentAuditLogHandler.getConfiguredLevel());
            }
            catch (Exception e) {
                new ErrorManager().error("Exception caught in getHandler ", e, 0);
            }
        }
        return deploymentAuditHandler;
    }

    private static synchronized Handler getConsoleHandler() {
        if (consoleHandler == null) {
            try {
                consoleHandler = new ConsoleHandler();
                consoleHandler.setLevel(Level.ALL);
                consoleHandler.setFormatter(new UniformLogFormatter());
            }
            catch (Exception e) {
                new ErrorManager().error("Exception caught in getConsoleHandler ", e, 0);
            }
        }
        return consoleHandler;
    }

    private static synchronized Handler getSyslogHandler() {
        if (syslogLibraryLoadError) {
            return null;
        }
        if (syslogHandler == null) {
            try {
                syslogHandler = new SystemLogHandler();
                syslogHandler.setLevel(Level.ALL);
                syslogHandler.setFormatter(new UniformLogFormatter());
            }
            catch (Exception e) {
                syslogLibraryLoadError = true;
            }
        }
        return syslogHandler;
    }

    private static synchronized Handler getCustomHandler() {
        if (customHandler != null || customHandlerError) {
            return customHandler;
        }
        LogService logService = ServerLogManager.getLogService();
        if (logService == null) {
            return null;
        }
        String customHandlerClassName = null;
        try {
            customHandlerClassName = logService.getLogHandler();
            customHandler = (Handler)ServerLogManager.getInstance(customHandlerClassName);
            if (customHandler != null) {
                customHandler.setFormatter(new UniformLogFormatter());
            }
        }
        catch (Exception e) {
            customHandlerError = true;
            new ErrorManager().error("Error In Initializing Custom Handler " + customHandlerClassName, e, 0);
        }
        return customHandler;
    }

    private static Filter getCustomFilter() {
        if (customFilter != null || customFilterError) {
            return customFilter;
        }
        LogService logService = ServerLogManager.getLogService();
        if (logService == null) {
            return null;
        }
        String customFilterClassName = null;
        try {
            customFilterClassName = logService.getLogFilter();
            customFilter = (Filter)ServerLogManager.getInstance(customFilterClassName);
        }
        catch (Exception e) {
            customFilterError = true;
            new ErrorManager().error("Error In Instantiating Custom Filter " + customFilterClassName, e, 0);
        }
        return customFilter;
    }

    static LogService getLogService() {
        try {
            ServerContext sc = ApplicationServer.getServerContext();
            if (sc == null) {
                return null;
            }
            return ServerBeansFactory.getConfigBean(sc.getConfigContext()).getLogService();
        }
        catch (Exception e) {
            new ErrorManager().error("Error In getLogService  ", e, 0);
            return null;
        }
    }

    private static Object getInstance(final String className) {
        if (className == null) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl == null) {
                        cl = ClassLoader.getSystemClassLoader();
                    }
                    return Class.forName(className, true, cl).newInstance();
                }
                catch (Exception e) {
                    new ErrorManager().error("Error In Instantiating Class " + className, e, 0);
                    return null;
                }
            }
        });
    }

    private static boolean logToSyslog() {
        boolean sunOS = System.getProperty(OS_NAME_PROPERTY).equals(SUN_OS);
        boolean linuxOS = System.getProperty(OS_NAME_PROPERTY).equals(LINUX_OS);
        if (!sunOS && !linuxOS) {
            return false;
        }
        if (syslogLibraryLoadError) {
            return false;
        }
        LogService logService = ServerLogManager.getLogService();
        if (logService != null) {
            return logService.isUseSystemLogging();
        }
        return false;
    }

    private static boolean logToStderr() {
        try {
            if (verboseMode == null) {
                verboseMode = Boolean.FALSE;
                String verbose = System.getProperty("com.sun.aas.verboseMode");
                if (verbose != null && verbose.equals("true")) {
                    verboseMode = Boolean.TRUE;
                }
            }
            if (verboseMode.booleanValue()) {
                return true;
            }
            ServerContext sc = ApplicationServer.getServerContext();
            if (sc == null) {
                return false;
            }
            Config cfg = ServerBeansFactory.getConfigBean(sc.getConfigContext());
            return cfg.getLogService().isLogToConsole();
        }
        catch (Exception ex) {
            new ErrorManager().error("Error while geting echo-log-messages-to-stderr attribute of  log-service ", ex, 0);
            return false;
        }
    }

    public static Level getConfiguredLogLevel(String loggerName) {
        ServerContext sc = ApplicationServer.getServerContext();
        if (sc == null) {
            if (loggerName.startsWith(SYNCHRONIZATION)) {
                try {
                    String level = System.getProperty(SYNCHRONIZATION, "INFO");
                    return Level.parse(level);
                }
                catch (Exception e) {
                    return Level.INFO;
                }
            }
            return Level.INFO;
        }
        if (loggerName.equals("javax.enterprise.system.tools.deployment.audit")) {
            try {
                Level level = DeploymentAuditLogHandler.getConfiguredLevel();
                return level;
            }
            catch (Throwable thr) {
                return Level.OFF;
            }
        }
        Level logLevel = null;
        try {
            String logModName;
            Config cfg = ServerBeansFactory.getConfigBean(sc.getConfigContext());
            ModuleLogLevels allModulesLogLevels = cfg.getLogService().getModuleLogLevels();
            if (allModulesLogLevels == null) {
                return Level.INFO;
            }
            if (allModulesLogLevels.getRoot().equals("OFF")) {
                return Level.OFF;
            }
            ElementProperty[] elementProperties = cfg.getLogService().getModuleLogLevels().getElementProperty();
            if (elementProperties != null) {
                for (int i = 0; i < elementProperties.length; ++i) {
                    if (!elementProperties[i].getName().equals(loggerName)) continue;
                    return Level.parse(elementProperties[i].getValue());
                }
            }
            if ((logModName = ModuleToLoggerNameMapper.getModuleName(loggerName)) != null) {
                try {
                    String val = allModulesLogLevels.getAttributeValue(logModName);
                    logLevel = Level.parse(val);
                }
                catch (Exception noSuch) {}
            }
        }
        catch (Exception e) {
            new ErrorManager().error("Error In Setting Initial Loglevel", e, 0);
        }
        return logLevel;
    }

    public static void reInitializeServerLoggers() {
        try {
            FileandSyslogHandler handler = (FileandSyslogHandler)ServerLogManager.getFileandSyslogHandler();
            handler.changeFileName(ServerLogManager.getLogService().getFile());
            Long rotationTimeLimitValue = new Long(ServerLogManager.getLogService().getLogRotationTimelimitInMinutes().trim());
            if (rotationTimeLimitValue != 0L) {
                LogRotationTimer.getInstance().startTimer(new LogRotationTimerTask(rotationTimeLimitValue));
                handler.setLimitForRotation(0);
            } else {
                Integer rotationLimitAttrValue = new Integer(ServerLogManager.getLogService().getLogRotationLimitInBytes().trim());
                handler.setLimitForRotation(rotationLimitAttrValue);
            }
            if (listOfUnInitializedLoggers.size() == 0) {
                return;
            }
            Iterator listIterator = listOfUnInitializedLoggers.iterator();
            while (listIterator.hasNext()) {
                thisInstance.initializeLogger((Logger)listIterator.next());
            }
        }
        catch (Exception e) {
            new ErrorManager().error("Exception caught in reInitializeServerLoggers ", e, 0);
        }
    }

    static {
        syslogLibraryLoadError = false;
        customHandler = null;
        customFilter = null;
        listOfUnInitializedLoggers = new ArrayList();
        verboseMode = null;
        customFilterError = false;
        customHandlerError = false;
    }
}

