/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.collection;

import com.sun.enterprise.util.collection.Bucket;
import com.sun.enterprise.util.collection.IntEntry;
import java.util.ArrayList;
import java.util.Iterator;

public class SortedArrayListBucket
implements Bucket {
    protected ArrayList entries = new ArrayList();

    SortedArrayListBucket() {
    }

    public Object put(long searchKey, Object object) {
        return this.put((int)searchKey, object);
    }

    public Object put(int searchKey, Object object) {
        int low = 0;
        int high = this.entries.size() - 1;
        int entryKey = 0;
        IntEntry entry = null;
        while (low <= high) {
            int mid = (low + high) / 2;
            entry = (IntEntry)this.entries.get(mid);
            entryKey = entry.key;
            if (entryKey == searchKey) {
                Object oldObject = entry.object;
                entry.object = object;
                return oldObject;
            }
            if (searchKey < entryKey) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        this.entries.add(low, new IntEntry(searchKey, object));
        return null;
    }

    public Object get(long searchKey) {
        return this.get((int)searchKey);
    }

    public Object get(int searchKey) {
        int low = 0;
        int high = this.entries.size() - 1;
        int entryKey = 0;
        IntEntry entry = null;
        while (low <= high) {
            int mid = (low + high) / 2;
            entry = (IntEntry)this.entries.get(mid);
            entryKey = entry.key;
            if (entryKey == searchKey) {
                return entry.object;
            }
            if (searchKey < entryKey) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return null;
    }

    public Object remove(long searchKey) {
        return this.remove((int)searchKey);
    }

    public Object remove(int searchKey) {
        int low = 0;
        int high = this.entries.size() - 1;
        int entryKey = 0;
        IntEntry entry = null;
        while (low <= high) {
            int mid = (low + high) / 2;
            entry = (IntEntry)this.entries.get(mid);
            entryKey = entry.key;
            if (entryKey == searchKey) {
                this.entries.remove(mid);
                return entry.object;
            }
            if (searchKey < entryKey) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return null;
    }

    public int size() {
        return this.entries.size();
    }

    public boolean containsKey(int searchKey) {
        return this.get((long)searchKey) != null;
    }

    public boolean containsKey(long searchKey) {
        return this.get(searchKey) != null;
    }

    public Iterator iterator() {
        return new BucketIterator(this.entries, false);
    }

    public Iterator entryIterator() {
        return new BucketIterator(this.entries, true);
    }

    private class BucketIterator
    implements Iterator {
        ArrayList entries;
        int index = 0;
        boolean iterateEntry;

        BucketIterator(ArrayList entries, boolean iterateEntry) {
            this.entries = entries;
            this.index = 0;
            this.iterateEntry = iterateEntry;
        }

        public boolean hasNext() {
            return this.index < this.entries.size();
        }

        public Object next() {
            return this.iterateEntry ? this.entries.get(this.index++) : ((IntEntry)this.entries.get((int)this.index++)).object;
        }

        public void remove() {
        }
    }
}

