/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.web.MemoryStrategyBuilder;
import com.sun.enterprise.web.PersistenceStrategyBuilder;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Context;

public class PersistenceStrategyBuilderFactory {
    protected final String DEFAULT_EE_BUILDER_PATH = "com.sun.enterprise.ee.web.initialization";
    private static Logger _logger = null;
    private String _eeBuilderPath = null;

    private String getEEBuilderPath() {
        if (this._eeBuilderPath == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this._eeBuilderPath = lookup.getEEBuilderPathFromConfig();
        }
        _logger.finest("_eeBuilderPath = " + this._eeBuilderPath);
        return this._eeBuilderPath;
    }

    public PersistenceStrategyBuilderFactory() {
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        }
    }

    PersistenceStrategyBuilder createPersistenceStrategyBuilder(String persistenceType, String frequency, String scope, Context ctx) {
        PersistenceStrategyBuilder builder = new MemoryStrategyBuilder();
        String className = this.createClassNameFrom(persistenceType, frequency, scope);
        _logger.finest("PersistenceStrategyBuilderFactory>>createPersistenceStrategyBuilder: CandidateBuilderClassName = " + className);
        try {
            builder = (PersistenceStrategyBuilder)Class.forName(className).newInstance();
        }
        catch (Exception ex) {
            Object[] params = new Object[]{this.getApplicationId(ctx), persistenceType, frequency, scope};
            _logger.log(Level.WARNING, "webcontainer.invalidSessionManagerConfig", params);
        }
        builder.setPersistenceFrequency(frequency);
        builder.setPersistenceScope(scope);
        return builder;
    }

    PersistenceStrategyBuilder createPersistenceStrategyBuilder(String persistenceType, String frequency, String scope) {
        PersistenceStrategyBuilder builder = new MemoryStrategyBuilder();
        String className = this.createClassNameFrom(persistenceType, frequency, scope);
        _logger.finest("PersistenceStrategyBuilderFactory>>createPersistenceStrategyBuilder: CandidateBuilderClassName = " + className);
        try {
            builder = (PersistenceStrategyBuilder)Class.forName(className).newInstance();
        }
        catch (Exception ex) {
            Object[] params = new Object[]{persistenceType, frequency, scope};
            _logger.log(Level.WARNING, "webcontainer.invalidSessionManagerConfig", params);
        }
        builder.setPersistenceFrequency(frequency);
        builder.setPersistenceScope(scope);
        return builder;
    }

    public String getApplicationId(Context ctx) {
        WebModule wm = (WebModule)ctx;
        return wm.getID();
    }

    public PersistenceStrategyBuilder testCreatePersistenceStategyBuilder(String persistenceType, String frequency, String scope) {
        return this.createPersistenceStrategyBuilder(persistenceType, frequency, scope);
    }

    private String createClassNameFrom(String persistenceType, String frequency, String scope) {
        StringBuffer sb = new StringBuffer();
        String pkg = this.getClass().getPackage().getName();
        if (!(persistenceType.equalsIgnoreCase("memory") | persistenceType.equalsIgnoreCase("file"))) {
            pkg = this.getEEBuilderPath();
        }
        sb.append(pkg + ".");
        sb.append(this.camelCase(persistenceType));
        if (frequency != null) {
            sb.append(this.camelCase(frequency));
        }
        if (scope != null) {
            sb.append(this.camelCase(scope));
        }
        sb.append("StrategyBuilder");
        String classname = sb.toString();
        return classname;
    }

    private String camelCase(String inputString) {
        String strippedString = this.stripNonAlphas(inputString);
        String firstLetter = strippedString.substring(0, 1).toUpperCase();
        String remainingPart = strippedString.substring(1, strippedString.length()).toLowerCase();
        return firstLetter + remainingPart;
    }

    private String stripNonAlphas(String inputString) {
        StringBuffer sb = new StringBuffer(50);
        for (int i = 0; i < inputString.length(); ++i) {
            char nextChar = inputString.charAt(i);
            if (!Character.isLetter(nextChar)) continue;
            sb.append(nextChar);
        }
        return sb.toString();
    }
}

