/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.coyote;

import com.sun.enterprise.web.PwcWebModule;
import com.sun.enterprise.web.logging.pwc.LogDomains;
import com.sun.enterprise.web.session.SessionCookieConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import org.apache.catalina.Context;
import org.apache.coyote.tomcat5.CoyoteConnector;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteResponse;

public class PwcCoyoteRequest
extends CoyoteRequest {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web.pwc");
    private boolean requestEncodingSet = false;
    private byte[] formData = null;
    private int formDataLen = 0;

    public void setContext(Context ctx) {
        if (ctx == null) {
            return;
        }
        super.setContext(ctx);
        CoyoteResponse response = (CoyoteResponse)this.getResponse();
        if (response != null) {
            String[] cacheControls = ((PwcWebModule)ctx).getCacheControls();
            for (int i = 0; cacheControls != null && i < cacheControls.length; ++i) {
                response.addHeader("Cache-Control", cacheControls[i]);
            }
        }
        this.requestEncodingSet = false;
    }

    public BufferedReader getReader() throws IOException {
        this.setRequestEncoding();
        return super.getReader();
    }

    public String getCharacterEncoding() {
        String enc = super.getCharacterEncoding();
        if (enc != null) {
            return enc;
        }
        this.setRequestEncoding();
        return super.getCharacterEncoding();
    }

    public void configureSessionCookie(Cookie cookie) {
        super.configureSessionCookie(cookie);
        PwcWebModule wm = (PwcWebModule)this.getContext();
        SessionCookieConfig cookieConfig = wm.getSessionCookieConfig();
        if (cookieConfig != null) {
            String name = cookieConfig.getName();
            if (name != null && !name.equals("JSESSIONID")) {
                logger.log(Level.WARNING, "pe_coyote.request.illegal_cookie_name", new String[]{name, "JSESSIONID"});
            }
            if (cookieConfig.getPath() != null) {
                cookie.setPath(cookieConfig.getPath());
            }
            cookie.setMaxAge(cookieConfig.getMaxAge());
            if (cookieConfig.getDomain() != null) {
                cookie.setDomain(cookieConfig.getDomain());
            }
            if (cookieConfig.getComment() != null) {
                cookie.setVersion(1);
                cookie.setComment(cookieConfig.getComment());
            }
        }
    }

    public void recycle() {
        super.recycle();
        this.formDataLen = 0;
    }

    private void setRequestEncoding() {
        if (this.requestEncodingSet) {
            return;
        }
        this.requestEncodingSet = true;
        if (super.getCharacterEncoding() != null) {
            return;
        }
        PwcWebModule wm = (PwcWebModule)this.getContext();
        String encoding = this.getFormHintFieldEncoding(wm);
        if (encoding == null && (encoding = wm.getDefaultCharset()) == null && wm.hasLocaleToCharsetMapping()) {
            encoding = wm.mapLocalesToCharset(this.getLocales());
        }
        if (encoding != null) {
            try {
                this.setCharacterEncoding(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                logger.log(Level.WARNING, "pe_coyote.request.encoding", uee);
            }
        }
    }

    private String getFormHintFieldEncoding(PwcWebModule wm) {
        String encoding = null;
        String formHintField = wm.getFormHintField();
        if (formHintField == null) {
            return null;
        }
        if ("POST".equalsIgnoreCase(this.getMethod())) {
            encoding = this.getPostDataEncoding(formHintField);
        } else {
            String query = this.getQueryString();
            if (query != null) {
                encoding = this.parseFormHintField(query, formHintField);
            }
        }
        return encoding;
    }

    private String getPostDataEncoding(String formHintField) {
        int semicolon;
        if (!this.getMethod().equalsIgnoreCase("POST")) {
            return null;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        if (!"application/x-www-form-urlencoded".equals(contentType = (semicolon = contentType.indexOf(59)) >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim())) {
            return null;
        }
        int len = this.getContentLength();
        if (len <= 0) {
            return null;
        }
        int maxPostSize = ((CoyoteConnector)this.connector).getMaxPostSize();
        if (maxPostSize > 0 && len > maxPostSize) {
            logger.log(Level.WARNING, "peCoyoteRequest.postTooLarge");
            throw new IllegalStateException("Post too large");
        }
        String encoding = null;
        try {
            this.formData = null;
            if (len < CACHED_POST_LEN) {
                if (this.postData == null) {
                    this.postData = new byte[CACHED_POST_LEN];
                }
                this.formData = this.postData;
            } else {
                this.formData = new byte[len];
            }
            int actualLen = this.readPostBody(this.formData, len);
            if (actualLen == len) {
                this.formDataLen = actualLen;
                String formDataString = new String(this.formData).substring(0, len);
                encoding = this.parseFormHintField(formDataString, formHintField);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return encoding;
    }

    private String parseFormHintField(String paramsString, String formHintField) {
        String encoding = null;
        int index = paramsString.indexOf(formHintField = formHintField + "=");
        if (index != -1) {
            int endIndex = paramsString.indexOf(38, index);
            encoding = endIndex != -1 ? paramsString.substring(index + formHintField.length(), endIndex) : paramsString.substring(index + formHintField.length());
        }
        return encoding;
    }

    protected byte[] getPostBody() throws IOException {
        if (this.formDataLen > 0) {
            return this.formData;
        }
        return super.getPostBody();
    }
}

