/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.AsyncHandler;
import com.sun.enterprise.web.connector.grizzly.AsyncReadTask;
import com.sun.enterprise.web.connector.grizzly.Constants;
import com.sun.enterprise.web.connector.grizzly.FileCacheFactory;
import com.sun.enterprise.web.connector.grizzly.KeepAlivePipeline;
import com.sun.enterprise.web.connector.grizzly.KeepAliveStats;
import com.sun.enterprise.web.connector.grizzly.LinkedListPipeline;
import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.PipelineStatistic;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.ReadBlockingTask;
import com.sun.enterprise.web.connector.grizzly.ReadTask;
import com.sun.enterprise.web.connector.grizzly.SelectorFactory;
import com.sun.enterprise.web.connector.grizzly.SelectorReadThread;
import com.sun.enterprise.web.connector.grizzly.SelectorThreadConfig;
import com.sun.enterprise.web.connector.grizzly.StreamAlgorithm;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.algorithms.NoParsingAlgorithm;
import com.sun.org.apache.commons.modeler.Registry;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.coyote.Adapter;
import org.apache.coyote.RequestGroupInfo;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.ServerSocketFactory;

public class SelectorThread
extends Thread
implements MBeanRegistration {
    private int serverTimeout = 0;
    private InetAddress inet;
    protected int port;
    private ServerSocketFactory factory;
    private ServerSocket serverSocket;
    protected SSLImplementation sslImplementation = null;
    private ServerSocketChannel serverSocketChannel;
    protected volatile boolean running = false;
    private volatile boolean paused = false;
    private boolean initialized = false;
    private boolean reinitializing = false;
    protected String domain;
    protected ObjectName oname;
    protected ObjectName globalRequestProcessorName;
    private ObjectName keepAliveMbeanName;
    private ObjectName pwcConnectionQueueMbeanName;
    private ObjectName pwcFileCacheMbeanName;
    protected MBeanServer mserver;
    protected ObjectName processorWorkerThreadName;
    protected boolean tcpNoDelay = false;
    protected int linger = 100;
    protected int socketTimeout = -1;
    protected int maxKeepAliveRequests = 256;
    protected int maxHttpHeaderSize = 8192;
    protected int minReadQueueLength = 10;
    protected int minProcessorQueueLength = 10;
    protected Selector selector;
    protected Adapter adapter = null;
    private boolean secure = false;
    protected Pipeline readPipeline;
    protected Pipeline processorPipeline;
    protected PipelineStatistic pipelineStat;
    protected String pipelineClassName = LinkedListPipeline.class.getName();
    protected int maxProcessorWorkerThreads = 20;
    protected int maxReadWorkerThreads = -1;
    protected int minWorkerThreads = 5;
    protected int minSpareThreads = 2;
    protected int threadsIncrement = 1;
    protected int threadsTimeout = 30;
    protected boolean useNioNonBlocking = true;
    protected boolean useDirectByteBuffer = false;
    private RequestGroupInfo globalRequestProcessor = new RequestGroupInfo();
    private KeepAliveStats keepAliveStats = new KeepAliveStats();
    protected boolean displayConfiguration = false;
    private boolean isMonitoringEnabled = false;
    protected int currentConnectionNumber;
    protected volatile boolean isWaiting = false;
    protected int requestBufferSize = 4096;
    protected boolean useByteBufferView = false;
    private int keepAliveTimeoutInSeconds = 30;
    private int kaTimeout = 30000;
    protected boolean recycleTasks = true;
    protected static int selectorTimeout = 1000;
    protected int maxQueueSizeInBytes = 4096;
    protected Class algorithmClass;
    protected String algorithmClassName = DEFAULT_ALGORITHM;
    public static final String DEFAULT_ALGORITHM = NoParsingAlgorithm.class.getName();
    protected int ssBackLog = 4096;
    private long nextKeysExpiration = 0L;
    protected String defaultResponseType = "text/plain; charset=iso-8859-1";
    protected String forcedResponseType = "text/plain; charset=iso-8859-1";
    protected static String rootFolder = "";
    private ConcurrentLinkedQueue<SelectionKey> keysToEnable = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<ProcessorTask> processorTasks = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<ReadTask> readTasks = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<ProcessorTask> activeProcessorTasks = new ConcurrentLinkedQueue();
    protected int selectorReadThreadsCount = 0;
    protected SelectorReadThread[] readThreads;
    int curReadThread;
    protected static Logger logger = Logger.getLogger("GRIZZLY");
    protected KeepAlivePipeline keepAlivePipeline;
    protected FileCacheFactory fileCacheFactory;
    protected int secondsMaxAge = -1;
    protected int maxCacheEntries = 1024;
    protected long minEntrySize = 2048L;
    protected long maxEntrySize = 537600L;
    protected long maxLargeFileCacheSize = 0xA00000L;
    protected long maxSmallFileCacheSize = 0x100000L;
    protected boolean isFileCacheEnabled = true;
    protected boolean isLargeFileCacheEnabled = true;
    protected boolean asyncExecution = false;
    protected AsyncHandler asyncHandler;

    public void enableSelectionKeys() {
        int size = this.keysToEnable.size();
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < size; ++i) {
            SelectionKey selectionKey = this.keysToEnable.poll();
            selectionKey.interestOps(selectionKey.interestOps() | 1);
            selectionKey.attach(currentTime);
            this.keepAlivePipeline.trap(selectionKey);
        }
    }

    public void registerKey(SelectionKey key) {
        if (key == null) {
            return;
        }
        if (this.keepAlivePipeline.dropConnection()) {
            this.cancelKey(key);
            return;
        }
        this.keysToEnable.add(key);
        this.selector.wakeup();
    }

    public void initEndpoint() throws IOException, InstantiationException {
        SelectorThreadConfig.configure(this);
        this.initFileCacheFactory();
        this.initPipeline();
        this.initAlgorithm();
        this.initMonitoringLevel();
        this.setName("SelectorThread-" + this.port);
        try {
            if (this.secure) {
                this.useNioNonBlocking = false;
            }
            if (this.useNioNonBlocking) {
                this.serverSocketChannel = ServerSocketChannel.open();
                this.selector = Selector.open();
                this.serverSocket = this.serverSocketChannel.socket();
                this.serverSocket.setReuseAddress(true);
                if (this.inet == null) {
                    this.serverSocket.bind(new InetSocketAddress(this.port), this.ssBackLog);
                } else {
                    this.serverSocket.bind(new InetSocketAddress(this.inet, this.port), this.ssBackLog);
                }
                this.serverSocketChannel.configureBlocking(false);
                this.serverSocketChannel.register(this.selector, 16);
            } else {
                this.serverSocket = this.inet == null ? this.factory.createSocket(this.port, this.ssBackLog) : this.factory.createSocket(this.port, this.ssBackLog, this.inet);
                this.serverSocket.setReuseAddress(true);
            }
        }
        catch (SocketException ex) {
            throw new BindException(ex.getMessage() + ": " + this.port);
        }
        this.serverSocket.setSoTimeout(this.serverTimeout);
        if (this.useNioNonBlocking) {
            if (this.selectorReadThreadsCount > 1) {
                this.readThreads = new SelectorReadThread[this.selectorReadThreadsCount];
                this.initSelectorReadThread();
            } else {
                this.initProcessorTask(this.maxProcessorWorkerThreads);
                this.initReadTask(this.minReadQueueLength);
            }
            SelectorFactory.maxSelectors = this.maxProcessorWorkerThreads;
        } else {
            this.initReadBlockingTask(this.maxProcessorWorkerThreads);
        }
        this.initialized = true;
        if (this.useNioNonBlocking) {
            logger.log(Level.FINE, "Initializing Grizzly Non-Blocking Mode");
        } else if (!this.useNioNonBlocking) {
            logger.log(Level.FINE, "Initializing Grizzly Blocking Mode");
        }
    }

    protected Pipeline newPipeline(int maxThreads, int minThreads, String name, int port, int priority) {
        Class<?> className = null;
        Pipeline pipeline = null;
        try {
            className = Class.forName(this.pipelineClassName);
            pipeline = (Pipeline)className.newInstance();
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.WARNING, "Unable to load Pipeline: " + this.pipelineClassName);
            pipeline = new LinkedListPipeline();
        }
        catch (InstantiationException ex) {
            logger.log(Level.WARNING, "Unable to instantiate Pipeline: " + this.pipelineClassName);
            pipeline = new LinkedListPipeline();
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.WARNING, "Unable to instantiate Pipeline: " + this.pipelineClassName);
            pipeline = new LinkedListPipeline();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "http-listener " + port + " uses pipeline: " + pipeline.getClass().getName());
        }
        pipeline.setMaxThreads(maxThreads);
        pipeline.setMinThreads(minThreads);
        pipeline.setName(name);
        pipeline.setPort(port);
        pipeline.setPriority(priority);
        pipeline.setQueueSizeInBytes(this.maxQueueSizeInBytes);
        pipeline.setThreadsIncrement(this.threadsIncrement);
        pipeline.setThreadsTimeout(this.threadsTimeout);
        return pipeline;
    }

    private void initFileCacheFactory() {
        this.fileCacheFactory = FileCacheFactory.getFactory(this.port);
        FileCacheFactory.setIsEnabled(this.isFileCacheEnabled);
        this.fileCacheFactory.setLargeFileCacheEnabled(this.isLargeFileCacheEnabled);
        this.fileCacheFactory.setSecondsMaxAge(this.secondsMaxAge);
        this.fileCacheFactory.setMaxCacheEntries(this.maxCacheEntries);
        this.fileCacheFactory.setMinEntrySize(this.minEntrySize);
        this.fileCacheFactory.setMaxEntrySize(this.maxEntrySize);
        this.fileCacheFactory.setMaxLargeCacheSize(this.maxLargeFileCacheSize);
        this.fileCacheFactory.setMaxSmallCacheSize(this.maxSmallFileCacheSize);
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
    }

    private void enablePipelineStats() {
        this.pipelineStat.start();
        this.processorPipeline.setPipelineStatistic(this.pipelineStat);
        this.pipelineStat.setProcessorPipeline(this.processorPipeline);
        if (this.keepAlivePipeline != null) {
            this.keepAlivePipeline.setKeepAliveStats(this.keepAliveStats);
        }
    }

    private void disablePipelineStats() {
        this.pipelineStat.stop();
        this.processorPipeline.setPipelineStatistic(null);
        this.pipelineStat.setProcessorPipeline(null);
        if (this.keepAlivePipeline != null) {
            this.keepAlivePipeline.setKeepAliveStats(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAlgorithm() {
        try {
            this.algorithmClass = Class.forName(this.algorithmClassName);
            logger.log(Level.FINE, "Using Algorithm: " + this.algorithmClassName);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.FINE, "Unable to load Algorithm: " + this.algorithmClassName);
        }
        finally {
            if (this.algorithmClass == null) {
                this.algorithmClass = NoParsingAlgorithm.class;
            }
        }
    }

    protected void initKeepAlivePipeline() {
        this.keepAlivePipeline = new KeepAlivePipeline();
        this.keepAlivePipeline.setMaxKeepAliveRequests(this.maxKeepAliveRequests);
        this.keepAlivePipeline.setKeepAliveTimeoutInSeconds(this.keepAliveTimeoutInSeconds);
        this.keepAlivePipeline.setPort(this.port);
        this.keepAlivePipeline.setThreadsTimeout(this.threadsTimeout);
        this.keepAliveStats.setMaxConnections(this.maxKeepAliveRequests);
        this.keepAliveStats.setSecondsTimeouts(this.keepAliveTimeoutInSeconds);
    }

    protected void initPipeline() {
        this.initKeepAlivePipeline();
        this.processorPipeline = this.newPipeline(this.maxProcessorWorkerThreads, this.minWorkerThreads, "http", this.port, 10);
        this.processorPipeline.initPipeline();
        if (this.secure && this.maxReadWorkerThreads == 0) {
            this.maxReadWorkerThreads = -1;
            logger.log(Level.WARNING, "http-listener " + this.port + " is security-enabled and needs at least 2 threads");
        }
        if (this.maxReadWorkerThreads > 0) {
            this.readPipeline = this.newPipeline(this.maxReadWorkerThreads, this.minWorkerThreads, "read", this.port, 5);
            this.readPipeline.initPipeline();
        } else {
            this.readPipeline = this.maxReadWorkerThreads == 0 ? null : this.processorPipeline;
        }
    }

    protected void initReadTask(int size) {
        for (int i = 0; i < size; ++i) {
            ReadTask task = this.newReadTask();
            this.readTasks.offer(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadTask newReadTask() {
        StreamAlgorithm streamAlgorithm = null;
        try {
            streamAlgorithm = (StreamAlgorithm)this.algorithmClass.newInstance();
        }
        catch (InstantiationException ex) {
            logger.log(Level.WARNING, "Unable to instantiate Algorithm: " + this.algorithmClassName);
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.WARNING, "Unable to instantiate Algorithm: " + this.algorithmClassName);
        }
        finally {
            if (streamAlgorithm == null) {
                streamAlgorithm = new NoParsingAlgorithm();
            }
        }
        streamAlgorithm.setPort(this.port);
        ReadTask task = this.maxReadWorkerThreads <= 0 ? new ReadTask(streamAlgorithm, this.useDirectByteBuffer, this.useByteBufferView) : new AsyncReadTask(streamAlgorithm, this.useDirectByteBuffer, this.useByteBufferView);
        task.setPipeline(this.readPipeline);
        task.setSelectorThread(this);
        task.setRecycle(this.recycleTasks);
        return task;
    }

    private void initReadBlockingTask(int size) {
        for (int i = 0; i < size; ++i) {
            this.readTasks.offer(this.newReadBlockingTask(false));
        }
    }

    private ReadBlockingTask newReadBlockingTask(boolean initialize) {
        ReadBlockingTask task = new ReadBlockingTask();
        task.setSelectorThread(this);
        if (this.maxReadWorkerThreads > 0) {
            task.setPipeline(this.readPipeline);
        }
        task.setRecycle(this.recycleTasks);
        task.attachProcessor(this.newProcessorTask(false, initialize));
        task.setPipelineStatistic(this.pipelineStat);
        return task;
    }

    private void initSelectorReadThread() throws IOException, InstantiationException {
        for (int i = 0; i < this.readThreads.length; ++i) {
            this.readThreads[i] = new SelectorReadThread();
            this.readThreads[i].countName = i;
            this.readThreads[i].setMaxThreads(this.maxProcessorWorkerThreads);
            this.readThreads[i].setBufferSize(this.requestBufferSize);
            this.readThreads[i].setMaxKeepAliveRequests(this.maxKeepAliveRequests);
            this.readThreads[i].setKeepAliveTimeoutInSeconds(this.keepAliveTimeoutInSeconds);
            this.readThreads[i].maxQueueSizeInBytes = this.maxQueueSizeInBytes;
            this.readThreads[i].fileCacheFactory = this.fileCacheFactory;
            this.readThreads[i].maxReadWorkerThreads = this.maxReadWorkerThreads;
            this.readThreads[i].defaultResponseType = this.defaultResponseType;
            this.readThreads[i].forcedResponseType = this.forcedResponseType;
            this.readThreads[i].minReadQueueLength = this.minReadQueueLength;
            this.readThreads[i].maxHttpHeaderSize = this.maxHttpHeaderSize;
            if (this.asyncExecution) {
                this.readThreads[i].asyncExecution = this.asyncExecution;
                this.readThreads[i].asyncHandler = this.asyncHandler;
            }
            this.readThreads[i].threadsIncrement = this.threadsIncrement;
            this.readThreads[i].setPort(this.port);
            this.readThreads[i].setAdapter(this.adapter);
            this.readThreads[i].initEndpoint();
            this.readThreads[i].start();
        }
        this.curReadThread = 0;
    }

    private synchronized SelectorReadThread getSelectorReadThread() {
        if (this.curReadThread == this.readThreads.length) {
            this.curReadThread = 0;
        }
        return this.readThreads[this.curReadThread++];
    }

    protected void initProcessorTask(int size) {
        for (int i = 0; i < size; ++i) {
            this.processorTasks.offer(this.newProcessorTask(this.useNioNonBlocking, false));
        }
    }

    protected void rampUpProcessorTask() {
        Iterator<ProcessorTask> iterator = this.processorTasks.iterator();
        while (iterator.hasNext()) {
            iterator.next().initialize();
        }
    }

    protected ProcessorTask newProcessorTask(boolean useNioNonBlocking, boolean initialize) {
        ProcessorTask task = new ProcessorTask(useNioNonBlocking, initialize);
        task.setAdapter(this.adapter);
        task.setMaxHttpHeaderSize(this.maxHttpHeaderSize);
        task.setBufferSize(this.requestBufferSize);
        task.setSelectorThread(this);
        task.setRecycle(this.recycleTasks);
        task.setDefaultResponseType(this.defaultResponseType);
        task.setForcedResponseType(this.forcedResponseType);
        if (this.asyncExecution) {
            task.setEnableAsyncExecution(this.asyncExecution);
            task.setAsyncHandler(this.asyncHandler);
        }
        if (!useNioNonBlocking) {
            task.setMaxKeepAliveRequests(this.maxKeepAliveRequests);
        }
        if (this.secure) {
            task.setSSLImplementation(this.sslImplementation);
        }
        if (this.keepAlivePipeline.dropConnection()) {
            task.setDropConnection(true);
        }
        task.setPipeline(this.processorPipeline);
        return task;
    }

    protected ProcessorTask getProcessorTask() {
        ProcessorTask processorTask = null;
        if (this.recycleTasks) {
            processorTask = this.processorTasks.poll();
        }
        if (processorTask == null) {
            processorTask = this.newProcessorTask(true, false);
        }
        if (this.isMonitoringEnabled()) {
            this.activeProcessorTasks.offer(processorTask);
        }
        return processorTask;
    }

    protected ReadTask getReadTask(SelectionKey key) throws IOException {
        ReadTask task = null;
        if (this.recycleTasks) {
            task = this.readTasks.poll();
        }
        if (task == null) {
            task = this.newReadTask();
        }
        task.setSelectionKey(key);
        return task;
    }

    protected ReadBlockingTask getReadBlockingTask(Socket socket) {
        ReadTask task = null;
        if (this.recycleTasks) {
            task = (ReadBlockingTask)this.readTasks.poll();
        }
        if (task == null) {
            task = this.newReadBlockingTask(false);
        }
        ProcessorTask processorTask = task.getProcessorTask();
        processorTask.setSocket(socket);
        return task;
    }

    public void run() {
        try {
            this.startEndpoint();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "selectorThread.errorOnRequest", ex);
        }
    }

    public void startEndpoint() throws IOException, InstantiationException {
        this.running = true;
        this.kaTimeout = this.keepAliveTimeoutInSeconds * 1000;
        this.rampUpProcessorTask();
        this.registerComponents();
        this.displayConfiguration();
        this.startPipelines();
        if (this.secure || !this.useNioNonBlocking) {
            this.startBlockingMode();
        } else if (this.useNioNonBlocking) {
            this.startNonBlockingMode();
        }
    }

    protected void startPipelines() {
        if (this.readPipeline != null) {
            this.readPipeline.startPipeline();
        }
        this.processorPipeline.startPipeline();
    }

    protected void stopPipelines() {
        if (this.keepAlivePipeline != null) {
            this.keepAlivePipeline.stopPipeline();
        }
        if (this.readPipeline != null) {
            this.readPipeline.stopPipeline();
        }
        this.processorPipeline.stopPipeline();
    }

    protected void startBlockingMode() {
        Socket socket = null;
        while (this.running) {
            socket = this.acceptSocket();
            if (socket == null) continue;
            try {
                this.handleConnection(socket);
            }
            catch (Throwable ex) {
                logger.log(Level.FINE, "selectorThread.handleConnectionException", ex);
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void startNonBlockingMode() {
        while (this.running) {
            this.doSelect();
        }
    }

    protected void doSelect() {
        SelectionKey key = null;
        try {
            int selectorState = 0;
            this.enableSelectionKeys();
            try {
                selectorState = this.selector.select(selectorTimeout);
            }
            catch (CancelledKeyException ex) {
                // empty catch block
            }
            Set<SelectionKey> readyKeys = this.selector.selectedKeys();
            Iterator<SelectionKey> iterator = readyKeys.iterator();
            while (iterator.hasNext()) {
                key = iterator.next();
                iterator.remove();
                key.attach(null);
                if (key.isValid()) {
                    this.handleConnection(key);
                    continue;
                }
                this.cancelKey(key);
            }
            this.expireIdleKeys();
            if (selectorState <= 0) {
                this.selector.selectedKeys().clear();
                return;
            }
        }
        catch (Throwable t) {
            if (key != null) {
                key.attach(null);
                key.cancel();
            }
            logger.log(Level.FINE, "selectorThread.errorOnRequest", t);
        }
    }

    private void expireIdleKeys() {
        if (this.keepAliveTimeoutInSeconds <= 0 || !this.selector.isOpen()) {
            return;
        }
        long current = System.currentTimeMillis();
        if (current < this.nextKeysExpiration) {
            return;
        }
        this.nextKeysExpiration = current + (long)this.kaTimeout;
        Set<SelectionKey> readyKeys = this.selector.keys();
        if (readyKeys.isEmpty()) {
            return;
        }
        for (SelectionKey key : readyKeys) {
            if (!key.isValid()) {
                this.keepAlivePipeline.untrap(key);
                continue;
            }
            if (key.attachment() == null) continue;
            long expire = (Long)key.attachment();
            if (current - expire >= (long)this.kaTimeout) {
                this.cancelKey(key);
                continue;
            }
            if (expire + (long)this.kaTimeout >= this.nextKeysExpiration) continue;
            this.nextKeysExpiration = expire + (long)this.kaTimeout;
        }
    }

    private void handleConnection(Socket socket) throws IOException {
        if (this.isMonitoringEnabled()) {
            this.globalRequestProcessor.increaseCountOpenConnections();
            this.pipelineStat.incrementTotalAcceptCount();
        }
        this.setSocketOptions(socket);
        this.getReadBlockingTask(socket).execute();
    }

    protected void handleConnection(SelectionKey key) throws IOException, InterruptedException {
        Task task = null;
        if ((key.readyOps() & 0x10) == 16) {
            this.handleAccept(key);
            return;
        }
        if ((key.readyOps() & 1) == 1) {
            task = this.handleRead(key);
        }
        task.execute();
    }

    private void handleAccept(SelectionKey key) throws IOException {
        ServerSocketChannel server = (ServerSocketChannel)key.channel();
        SocketChannel channel = server.accept();
        if (channel != null) {
            if (this.selectorReadThreadsCount > 1) {
                SelectorReadThread srt = this.getSelectorReadThread();
                srt.addChannel(channel);
            } else {
                channel.configureBlocking(false);
                SelectionKey readKey = channel.register(this.selector, 1);
                this.setSocketOptions(((SocketChannel)readKey.channel()).socket());
            }
            if (this.isMonitoringEnabled()) {
                this.getRequestGroupInfo().increaseCountOpenConnections();
                this.pipelineStat.incrementTotalAcceptCount();
            }
        }
    }

    private ReadTask handleRead(SelectionKey key) throws IOException {
        key.interestOps(key.interestOps() & 0xFFFFFFFE);
        ReadTask task = this.getReadTask(key);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelKey(SelectionKey key) {
        if (key == null || !key.isValid()) {
            return;
        }
        this.keepAlivePipeline.untrap(key);
        try {
            ((SocketChannel)key.channel()).socket().shutdownInput();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            ((SocketChannel)key.channel()).socket().shutdownOutput();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            ((SocketChannel)key.channel()).socket().close();
        }
        catch (IOException ex) {
        }
        finally {
            try {
                key.channel().close();
            }
            catch (IOException ex) {
                logger.log(Level.FINEST, "selectorThread.unableToCloseKey", key);
            }
            if (this.isMonitoringEnabled()) {
                this.getRequestGroupInfo().decreaseCountOpenConnections();
            }
        }
        key.attach(null);
        key.cancel();
        key = null;
    }

    public void returnTask(Task task) {
        if (task != null) {
            if (task.getType() == 2) {
                if (this.isMonitoringEnabled()) {
                    this.activeProcessorTasks.remove((ProcessorTask)task);
                }
                this.processorTasks.offer((ProcessorTask)task);
            } else if (task.getType() == 1) {
                this.readTasks.offer((ReadTask)task);
            }
        }
    }

    public void wakeup() {
        this.selector.wakeup();
    }

    protected void clearTasks() {
        this.processorTasks.clear();
        this.readTasks.clear();
    }

    public boolean cancelThreadExecution(long cancelThreadID) {
        if (this.selectorReadThreadsCount > 1) {
            boolean cancelled = false;
            for (SelectorReadThread readSelector : this.readThreads) {
                cancelled = readSelector.cancelThreadExecution(cancelThreadID);
                if (!cancelled) continue;
                return true;
            }
            return false;
        }
        if (this.activeProcessorTasks.size() == 0) {
            return false;
        }
        for (ProcessorTask processorTask : this.activeProcessorTasks) {
            long threadID = processorTask.getRequest().getRequestProcessor().getWorkerThreadID();
            if (threadID != cancelThreadID) continue;
            processorTask.cancelTask("Request cancelled.", "500");
            logger.log(Level.WARNING, "Thread Request Cancelled: " + threadID);
            return processorTask.getPipeline().interruptThread(threadID);
        }
        return false;
    }

    public void pauseEndpoint() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
        }
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void resumeEndpoint() {
        if (this.running) {
            this.paused = false;
        }
    }

    public void stopEndpoint() {
        try {
            if (this.running) {
                this.running = false;
            }
            this.stopPipelines();
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "selectorThread.closeSocketException", ex);
            }
            try {
                if (this.serverSocketChannel != null) {
                    this.serverSocketChannel.close();
                }
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "selectorThread.closeSocketException", ex);
            }
            try {
                if (this.selector != null) {
                    this.selector.close();
                }
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "selectorThread.closeSocketException", ex);
            }
            this.clearTasks();
            this.unregisterComponents();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "selectorThread.stopException", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAccept() {
        if (this.secure) {
            Socket s = null;
            try {
                if (this.inet == null) {
                    s = new Socket("127.0.0.1", this.port);
                } else {
                    s = new Socket(this.inet, this.port);
                    s.setSoLinger(true, 0);
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "selectorThread.unlockAcceptException" + this.port + " " + e.toString());
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public boolean getUseNioNonBlocking() {
        return this.useNioNonBlocking;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxProcessorWorkerThreads = maxThreads == 1 ? 5 : maxThreads;
    }

    public int getMaxThreads() {
        return this.maxProcessorWorkerThreads;
    }

    public void setMaxSpareThreads(int maxThreads) {
    }

    public int getMaxSpareThreads() {
        return this.maxProcessorWorkerThreads;
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.inet;
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    ServerSocketFactory getServerSocketFactory() {
        return this.factory;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public int getCurrentBusyProcessorThreads() {
        int busy = 0;
        if (this.selectorReadThreadsCount > 1) {
            for (SelectorReadThread readSelector : this.readThreads) {
                busy += readSelector.getCurrentBusyProcessorThreads();
            }
        } else {
            busy = this.processorPipeline.getCurrentThreadsBusy();
        }
        return busy;
    }

    public void setServerTimeout(int timeout) {
        this.serverTimeout = timeout;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean b) {
        this.tcpNoDelay = b;
    }

    public int getSoLinger() {
        return this.linger;
    }

    public void setSoLinger(int i) {
        this.linger = i;
    }

    public int getSoTimeout() {
        return this.socketTimeout;
    }

    public void setSoTimeout(int i) {
        this.socketTimeout = i;
    }

    public int getServerSoTimeout() {
        return this.serverTimeout;
    }

    public void setServerSoTimeout(int i) {
        this.serverTimeout = i;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public int getQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        this.keepAliveTimeoutInSeconds = timeout;
        this.keepAliveStats.setSecondsTimeouts(timeout);
    }

    public int getKeepAliveTimeoutInSeconds() {
        return this.keepAliveTimeoutInSeconds;
    }

    public void setKeepAliveThreadCount(int threadCount) {
        this.keepAlivePipeline.setMaxThreads(threadCount);
    }

    public SSLImplementation getSSLImplementation() {
        return this.sslImplementation;
    }

    public void setSSLImplementation(SSLImplementation sslImplementation) {
        this.sslImplementation = sslImplementation;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected Socket acceptSocket() {
        if (!this.running || this.serverSocket == null) {
            return null;
        }
        Socket socket = null;
        try {
            socket = this.factory == null ? this.serverSocketChannel.accept().socket() : this.factory.acceptSocket(this.serverSocket);
            if (null == socket) {
                logger.log(Level.WARNING, "selectorThread.acceptSocket");
            } else if (!this.running) {
                socket.close();
                socket = null;
            } else if (this.factory != null) {
                this.factory.initSocket(socket);
            }
        }
        catch (InterruptedIOException iioe) {
        }
        catch (AccessControlException ace) {
            logger.log(Level.WARNING, "selectorThread.wrongPermission", new Object[]{this.serverSocket, ace});
        }
        catch (IOException e) {
            Object msg = null;
            if (this.running) {
                logger.log(Level.SEVERE, "selectorThread.shutdownException", new Object[]{this.serverSocket, e});
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable ex) {
                    logger.log(Level.SEVERE, "selectorThread.shutdownException", new Object[]{this.serverSocket, ex});
                }
                socket = null;
            }
            if (!this.running) {
                return null;
            }
        }
        catch (Throwable t) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.log(Level.FINE, "selectorThread.errorOnRequest", t);
        }
        return socket;
    }

    protected void setSocketOptions(Socket socket) throws SocketException {
        try {
            if (this.linger >= 0) {
                socket.setSoLinger(true, this.linger);
            }
        }
        catch (SocketException ex) {
            logger.log(Level.WARNING, "setSoLinger exception ", ex);
        }
        try {
            if (this.tcpNoDelay) {
                socket.setTcpNoDelay(this.tcpNoDelay);
            }
        }
        catch (SocketException ex) {
            logger.log(Level.WARNING, "setTcpNoDelay exception ", ex);
        }
        try {
            if (this.keepAliveTimeoutInSeconds > 0 && !this.useNioNonBlocking) {
                socket.setSoTimeout(this.keepAliveTimeoutInSeconds * 1000);
            }
        }
        catch (SocketException ex) {
            logger.log(Level.WARNING, "setSoTimeout exception ", ex);
        }
        try {
            if (this.maxReadWorkerThreads != 0) {
                socket.setReuseAddress(true);
            }
        }
        catch (SocketException ex) {
            logger.log(Level.WARNING, "setReuseAddress exception ", ex);
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    private void registerComponents() {
        if (this.domain != null) {
            Registry reg = Registry.getRegistry();
            try {
                this.globalRequestProcessorName = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=http" + this.port);
                reg.registerComponent((Object)this.globalRequestProcessor, this.globalRequestProcessorName, null);
                this.keepAliveMbeanName = new ObjectName(this.domain + ":type=PWCKeepAlive,name=http" + this.port);
                reg.registerComponent((Object)this.keepAliveStats, this.keepAliveMbeanName, null);
                this.pwcConnectionQueueMbeanName = new ObjectName(this.domain + ":type=PWCConnectionQueue,name=http" + this.port);
                reg.registerComponent((Object)this.pipelineStat, this.pwcConnectionQueueMbeanName, null);
                this.pwcFileCacheMbeanName = new ObjectName(this.domain + ":type=PWCFileCache,name=http" + this.port);
                reg.registerComponent((Object)this.fileCacheFactory, this.pwcFileCacheMbeanName, null);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "selectorThread.mbeanRegistrationException", new Object[]{new Integer(this.port), ex});
            }
        }
    }

    private void unregisterComponents() {
        if (this.domain != null) {
            Registry reg = Registry.getRegistry();
            try {
                if (this.globalRequestProcessorName != null) {
                    reg.unregisterComponent(this.globalRequestProcessorName);
                }
                if (this.keepAliveMbeanName != null) {
                    reg.unregisterComponent(this.keepAliveMbeanName);
                }
                if (this.pwcConnectionQueueMbeanName != null) {
                    reg.unregisterComponent(this.pwcConnectionQueueMbeanName);
                }
                if (this.pwcFileCacheMbeanName != null) {
                    reg.unregisterComponent(this.pwcFileCacheMbeanName);
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "mbeanDeregistrationException", new Object[]{new Integer(this.port), ex});
            }
        }
    }

    public void enableMonitoring() {
        this.isMonitoringEnabled = true;
        this.enablePipelineStats();
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
    }

    public void disableMonitoring() {
        this.disablePipelineStats();
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
    }

    public boolean isMonitoringEnabled() {
        return this.isMonitoringEnabled;
    }

    public RequestGroupInfo getRequestGroupInfo() {
        return this.globalRequestProcessor;
    }

    public KeepAliveStats getKeepAliveStats() {
        return this.keepAliveStats;
    }

    private void initMonitoringLevel() {
        this.pipelineStat = new PipelineStatistic(this.port);
        this.pipelineStat.setQueueSizeInBytes(this.maxQueueSizeInBytes);
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public void setMinThreads(int minWorkerThreads) {
        this.minWorkerThreads = minWorkerThreads;
    }

    public void setBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getBufferSize() {
        return this.requestBufferSize;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public int getCountThreadsStats() {
        int ret = this.processorPipeline.getCurrentThreadCount();
        if (this.readPipeline != null && this.readPipeline != this.processorPipeline) {
            ret += this.readPipeline.getCurrentThreadCount();
        }
        return ret;
    }

    public int getCountThreadsIdleStats() {
        int ret = this.processorPipeline.getWaitingThread();
        if (this.readPipeline != null && this.readPipeline != this.processorPipeline) {
            ret += this.readPipeline.getWaitingThread();
        }
        return ret;
    }

    public int getCurrentThreadCountStats() {
        int ret = this.processorPipeline.getCurrentThreadCount();
        if (this.readPipeline != null && this.readPipeline != this.processorPipeline) {
            ret += this.readPipeline.getCurrentThreadCount();
        }
        return ret;
    }

    public int getCurrentThreadsBusyStats() {
        int ret = this.processorPipeline.getCurrentThreadsBusy();
        if (this.readPipeline != null && this.readPipeline != this.processorPipeline) {
            ret += this.readPipeline.getCurrentThreadsBusy();
        }
        return ret;
    }

    public int getMaxSpareThreadsStats() {
        int ret = this.processorPipeline.getMaxSpareThreads();
        if (this.readPipeline != null && this.readPipeline != this.processorPipeline) {
            ret += this.readPipeline.getMaxSpareThreads();
        }
        return ret;
    }

    public int getMinSpareThreadsStats() {
        int ret = this.processorPipeline.getMinSpareThreads();
        if (this.readPipeline != null && this.readPipeline != this.processorPipeline) {
            ret += this.readPipeline.getMinSpareThreads();
        }
        return ret;
    }

    public int getMaxThreadsStats() {
        int ret = this.processorPipeline.getMaxThreads();
        if (this.readPipeline != null && this.readPipeline != this.processorPipeline) {
            ret += this.readPipeline.getMaxThreads();
        }
        return ret;
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.secondsMaxAge = sMaxAges;
    }

    public void setMaxCacheEntries(int mEntries) {
        this.maxCacheEntries = mEntries;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMinEntrySize(long mSize) {
        this.minEntrySize = mSize;
    }

    public long getMinEntrySize() {
        return this.minEntrySize;
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.maxEntrySize = mEntrySize;
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.maxLargeFileCacheSize = mCacheSize;
    }

    public long getMaxLargeCacheSize() {
        return this.maxLargeFileCacheSize;
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.maxSmallFileCacheSize = mCacheSize;
    }

    public long getMaxSmallCacheSize() {
        return this.maxSmallFileCacheSize;
    }

    public boolean isFileCacheEnabled() {
        return this.isFileCacheEnabled;
    }

    public void setFileCacheIsEnabled(boolean isFileCacheEnabled) {
        this.isFileCacheEnabled = isFileCacheEnabled;
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.isLargeFileCacheEnabled = isLargeEnabled;
    }

    public boolean getLargeFileCacheEnabled() {
        return this.isLargeFileCacheEnabled;
    }

    public void setEnableAsyncExecution(boolean asyncExecution) {
        this.asyncExecution = asyncExecution;
    }

    public boolean getEnableAsyncExecution() {
        return this.asyncExecution;
    }

    public void setAsyncHandler(AsyncHandler asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    public AsyncHandler getAsyncHandler() {
        return this.asyncHandler;
    }

    public static void setLogger(Logger l) {
        if (l != null) {
            logger = l;
        }
    }

    public static Logger logger() {
        return logger;
    }

    public static void setWebAppRootPath(String rf) {
        rootFolder = rf;
    }

    public static String getWebAppRootPath() {
        return rootFolder;
    }

    private void displayConfiguration() {
        if (this.displayConfiguration) {
            logger.log(Level.INFO, "\n Grizzly configuration for http-listener " + this.port + "\n\t useNioNonBlocking:" + this.useNioNonBlocking + "\n\t minReadQueueLength:" + this.minReadQueueLength + "\n\t minProcessorQueueLength:" + this.maxReadWorkerThreads + "\n\t maxProcessorWorkerThreads: " + this.maxProcessorWorkerThreads + "\n\t minWorkerThreads:" + this.minWorkerThreads + "\n\t selectorTimeout:" + selectorTimeout + "\n\t ByteBuffer size: " + Constants.CHANNEL_BYTE_SIZE + "\n\t maxHttpHeaderSize:" + this.maxHttpHeaderSize + "\n\t maxKeepAliveRequests: " + this.maxKeepAliveRequests + "\n\t keepAliveTimeoutInSeconds: " + this.keepAliveTimeoutInSeconds + "\n\t useDirectByteBuffer: " + this.useDirectByteBuffer + "\n\t socketSoTimeout: " + Constants.DEFAULT_CONNECTION_TIMEOUT + "\n\t useByteBufferView: " + this.useByteBufferView + "\n\t selectorReadThreadsCount: " + this.selectorReadThreadsCount + "\n\t recycleTasks: " + this.recycleTasks);
        }
    }
}

