/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.util;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class SecurityUtils {
    private static StringManager sm = StringManager.getManager(DataSourceObjectBuilder.class);

    public static PasswordCredential getPasswordCredential(final ManagedConnectionFactory mcf, final Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (info == null) {
            if (subject == null) {
                return null;
            }
            PasswordCredential pc = (PasswordCredential)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Set<PasswordCredential> passwdCredentialSet = subject.getPrivateCredentials(PasswordCredential.class);
                    for (PasswordCredential temp : passwdCredentialSet) {
                        if (!temp.getManagedConnectionFactory().equals(mcf)) continue;
                        return temp;
                    }
                    return null;
                }
            });
            if (pc == null) {
                String msg = sm.getString("su.no_passwd_cred");
                throw new SecurityException(msg);
            }
            return pc;
        }
        com.sun.gjc.spi.ConnectionRequestInfo cxReqInfo = (com.sun.gjc.spi.ConnectionRequestInfo)info;
        PasswordCredential pc = new PasswordCredential(cxReqInfo.getUser(), cxReqInfo.getPassword().toCharArray());
        pc.setManagedConnectionFactory(mcf);
        return pc;
    }

    private static boolean isEqual(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean isPasswordCredentialEqual(PasswordCredential pC1, PasswordCredential pC2) {
        if (pC1 == pC2) {
            return true;
        }
        if (pC1 == null || pC2 == null) {
            return pC1 == pC2;
        }
        if (!SecurityUtils.isEqual(pC1.getUserName(), pC2.getUserName())) {
            return false;
        }
        String p1 = null;
        String p2 = null;
        if (pC1.getPassword() != null) {
            p1 = new String(pC1.getPassword());
        }
        if (pC2.getPassword() != null) {
            p2 = new String(pC2.getPassword());
        }
        return SecurityUtils.isEqual(p1, p2);
    }
}

