/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.keyinfo;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.keyinfo.DirectReferenceStrategy;
import com.sun.xml.wss.impl.keyinfo.KeyIdentifierStrategy;
import com.sun.xml.wss.impl.keyinfo.KeyNameStrategy;
import com.sun.xml.wss.impl.keyinfo.X509IssuerSerialStrategy;
import java.security.cert.X509Certificate;

public abstract class KeyInfoStrategy {
    public static KeyInfoStrategy getInstance(String strategy) {
        if ("Identifier" == strategy || "Identifier".equals(strategy)) {
            return new KeyIdentifierStrategy();
        }
        if ("KeyName" == strategy || "KeyName".equals(strategy)) {
            return new KeyNameStrategy();
        }
        if ("Direct" == strategy || "Direct".equals(strategy)) {
            return new DirectReferenceStrategy();
        }
        if ("IssuerSerialNumber" == strategy || "IssuerSerialNumber".equals(strategy)) {
            return new X509IssuerSerialStrategy();
        }
        return null;
    }

    public abstract void insertKey(KeyInfoHeaderBlock var1, SecurableSoapMessage var2, String var3) throws XWSSecurityException;

    public abstract void insertKey(SecurityTokenReference var1, SecurableSoapMessage var2) throws XWSSecurityException;

    public abstract void setCertificate(X509Certificate var1);

    public abstract String getAlias();
}

