/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.MessageGroup;
import com.sun.web.ui.renderer.AbstractRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.FacesMessageUtils;
import com.sun.web.ui.util.MessageUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.beans.Beans;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class MessageGroupRenderer
extends AbstractRenderer {
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        MessageGroup msgGrp = (MessageGroup)component;
        Iterator<FacesMessage> msgIt = null;
        String forComponentId = null;
        if (Beans.isDesignTime() && (msgGrp.isShowDetail() || msgGrp.isShowSummary())) {
            StringBuffer resourceNameBuffer = new StringBuffer();
            resourceNameBuffer.append("MessageGroup.");
            if (msgGrp.isShowGlobalOnly()) {
                resourceNameBuffer.append("global.");
            } else {
                resourceNameBuffer.append("default.");
            }
            if (msgGrp.isShowDetail() && msgGrp.isShowSummary()) {
                resourceNameBuffer.append("both");
            } else if (msgGrp.isShowDetail()) {
                resourceNameBuffer.append("detail");
            } else if (msgGrp.isShowSummary()) {
                resourceNameBuffer.append("summary");
            }
            String summary = MessageUtil.getMessage(context, "com.sun.web.ui.renderer.Bundle", resourceNameBuffer.toString());
            FacesMessage defaultMessage = new FacesMessage();
            defaultMessage.setSummary(summary);
            msgIt = Collections.singletonList(defaultMessage).iterator();
        } else {
            if (msgGrp.isShowGlobalOnly()) {
                forComponentId = "";
            }
            msgIt = FacesMessageUtils.getMessageIterator(context, forComponentId, (UIComponent)msgGrp);
        }
        if (msgIt.hasNext()) {
            this.renderMessageGroup(context, (UIComponent)msgGrp, writer, msgIt);
        }
    }

    public void renderMessageGroup(FacesContext context, UIComponent component, ResponseWriter writer, Iterator msgIt) throws IOException {
        MessageGroup msgGrp = (MessageGroup)component;
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderUserStyles(context, msgGrp, writer);
        this.renderOpeningTable(msgGrp, writer, theme);
        FacesMessage fMsg = null;
        boolean showSummary = msgGrp.isShowSummary();
        boolean showDetail = msgGrp.isShowDetail();
        String summaryStyle = theme.getStyleClass("MESSAGE_GROUP_SUMMARY_TEXT");
        String detailStyle = theme.getStyleClass("MESSAGE_GROUP_TEXT");
        String summary = null;
        String detail = null;
        while (msgIt.hasNext()) {
            fMsg = (FacesMessage)msgIt.next();
            if (showSummary && (summary = fMsg.getSummary()) != null && summary.length() <= 0) {
                summary = null;
            }
            if (showDetail && (detail = fMsg.getDetail()) != null && detail.length() <= 0) {
                detail = null;
            }
            if (summary == null && detail == null) continue;
            writer.startElement("div", (UIComponent)msgGrp);
            writer.writeAttribute("class", (Object)theme.getStyleClass("MESSAGE_GROUP_DIV"), null);
            writer.startElement("ul", (UIComponent)msgGrp);
            writer.startElement("li", (UIComponent)msgGrp);
            if (summary != null) {
                this.renderMessageText(msgGrp, writer, summary, summaryStyle);
            }
            if (detail != null) {
                this.renderMessageText(msgGrp, writer, detail, detailStyle);
            }
            writer.endElement("li");
            writer.endElement("ul");
            writer.endElement("div");
        }
        this.renderClosingTable(writer);
        writer.endElement("div");
    }

    public void renderOpeningTable(MessageGroup msgGrp, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("table", (UIComponent)msgGrp);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MESSAGE_GROUP_TABLE"), null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("title", (Object)"", null);
        writer.writeText((Object)"\n", null);
        writer.startElement("th", (UIComponent)msgGrp);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MESSAGE_GROUP_TABLE_TITLE"), null);
        writer.writeText((Object)theme.getMessage("messageGroup.heading"), null);
        writer.endElement("th");
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)msgGrp);
        writer.startElement("td", (UIComponent)msgGrp);
    }

    public void renderClosingTable(ResponseWriter writer) throws IOException {
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
    }

    public void renderMessageText(MessageGroup msgGrp, ResponseWriter writer, String msgText, String textStyle) throws IOException {
        writer.startElement("span", (UIComponent)msgGrp);
        writer.writeAttribute("class", (Object)textStyle, "class");
        writer.writeText((Object)msgText, null);
        writer.endElement("span");
    }

    private void renderUserStyles(FacesContext context, MessageGroup msgGrp, ResponseWriter writer) throws IOException {
        String userStyle = msgGrp.getStyle();
        String userStyleClass = msgGrp.getStyleClass();
        String id = msgGrp.getClientId(context);
        writer.startElement("div", (UIComponent)msgGrp);
        writer.writeAttribute("id", (Object)id, "id");
        if (userStyle != null && userStyle.length() > 0) {
            writer.writeAttribute("style", (Object)userStyle, "style");
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)msgGrp, null);
    }
}

