/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.util;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.PrintStream;
import java.util.Locale;

public class Globals {
    private static final Object lock = Globals.class;
    private static Version version = null;
    private static Globals globals = null;
    private static AdminResources ar = null;
    private static AdminConsoleResources acr = null;
    private static Logger logger = null;
    private static boolean silentMode = false;
    public static final String JMQ_HOME_PROPERTY = "imq.home";
    public static final String JMQ_VAR_HOME_PROPERTY = "imq.varhome";
    public static final String JMQ_LIB_HOME_PROPERTY = "imq.libhome";
    public static final String JMQ_HOME_default = ".";
    public static final String JMQ_VAR_HOME_default = "var";
    public static final String JMQ_HOME = System.getProperty("imq.home", ".");
    public static final String JMQ_VAR_HOME = System.getProperty("imq.varhome", JMQ_HOME + File.separator + "var");
    public static final String JMQ_LIB_HOME = System.getProperty("imq.libhome", JMQ_HOME + File.separator + "lib");
    public static final String JMQ_ADMIN_PROP_LOC = "props" + File.separator + "admin" + File.separator;

    private Globals() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Globals getGlobals() {
        if (globals == null) {
            Object object = lock;
            synchronized (object) {
                if (globals == null) {
                    globals = new Globals();
                }
            }
        }
        return globals;
    }

    public static Version getVersion() {
        if (version == null) {
            version = new Version();
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdminResources getAdminResources() {
        if (ar == null) {
            Object object = lock;
            synchronized (object) {
                if (ar == null) {
                    ar = AdminResources.getResources(Locale.getDefault());
                }
            }
        }
        return ar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdminConsoleResources getAdminConsoleResources() {
        if (acr == null) {
            Object object = lock;
            synchronized (object) {
                if (acr == null) {
                    acr = AdminConsoleResources.getResources(Locale.getDefault());
                }
            }
        }
        return acr;
    }

    public static void setSilentMode(boolean bl) {
        silentMode = bl;
    }

    public static void stdErrPrintln(String string) {
        Globals.doPrintln(System.err, string, false);
    }

    public static void stdErrPrintln(String string, boolean bl) {
        Globals.doPrintln(System.err, string, bl);
    }

    public static void stdErrPrintln(String string, String string2) {
        Globals.doPrintln(System.err, string + " " + string2, false);
    }

    public static void stdErrPrintln(String string, String string2, boolean bl) {
        Globals.doPrintln(System.err, string + " " + string2, bl);
    }

    public static void stdOutPrintln(String string) {
        Globals.doPrintln(System.out, string, false);
    }

    public static void stdOutPrintln(String string, boolean bl) {
        Globals.doPrintln(System.out, string, bl);
    }

    public static void stdOutPrintln(String string, String string2) {
        Globals.doPrintln(System.out, string + " " + string2, false);
    }

    public static void stdOutPrintln(String string, String string2, boolean bl) {
        Globals.doPrintln(System.out, string + " " + string2, bl);
    }

    public static void stdErrPrint(String string) {
        Globals.doPrint(System.err, string, false);
    }

    public static void stdErrPrint(String string, boolean bl) {
        Globals.doPrint(System.err, string, bl);
    }

    public static void stdErrPrint(String string, String string2) {
        Globals.doPrint(System.err, string + " " + string2, false);
    }

    public static void stdErrPrint(String string, String string2, boolean bl) {
        Globals.doPrint(System.err, string + " " + string2, bl);
    }

    public static void stdOutPrint(String string) {
        Globals.doPrint(System.out, string, false);
    }

    public static void stdOutPrint(String string, boolean bl) {
        Globals.doPrint(System.out, string, bl);
    }

    public static void stdOutPrint(String string, String string2) {
        Globals.doPrint(System.out, string + " " + string2, false);
    }

    public static void stdOutPrint(String string, String string2, boolean bl) {
        Globals.doPrint(System.out, string + " " + string2, bl);
    }

    private static void doPrintln(PrintStream printStream, String string, boolean bl) {
        if (silentMode) {
            return;
        }
        printStream.println(string);
        if (bl) {
            System.exit(1);
        }
    }

    private static void doPrint(PrintStream printStream, String string, boolean bl) {
        if (silentMode) {
            return;
        }
        printStream.print(string);
        if (bl) {
            System.exit(1);
        }
    }
}

