/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.ProfileClient;
import com.sun.jmx.remote.generic.ProfileClientProvider;
import com.sun.jmx.remote.generic.ProfileProviderException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ProfileClientFactory {
    public static final String PROFILE_PROVIDER_PACKAGES = "jmx.remote.profile.provider.pkgs";
    public static final String PROFILE_PROVIDER_CLASS_LOADER = "jmx.remote.profile.provider.class.loader";
    private static final String PROFILE_PROVIDER_DEFAULT_PACKAGE = "com.sun.jmx.remote.profile";
    static /* synthetic */ Class class$com$sun$jmx$remote$generic$ProfileClientProvider;
    static /* synthetic */ Class class$com$sun$jmx$remote$generic$ProfileClientFactory;

    private ProfileClientFactory() {
    }

    public static ProfileClient createProfile(String string, Map map) throws ProfileProviderException {
        String string2 = ProfileClientFactory.resolvePkgs(map);
        ClassLoader classLoader = ProfileClientFactory.resolveClassLoader(map);
        map = map == null ? new HashMap<String, ClassLoader>() : new HashMap(map);
        map.put(PROFILE_PROVIDER_CLASS_LOADER, classLoader);
        map = Collections.unmodifiableMap(map);
        ProfileClientProvider profileClientProvider = ProfileClientFactory.getProvider(string, string2, classLoader);
        if (profileClientProvider == null) {
            throw new IllegalArgumentException("Unsupported profile: " + string);
        }
        return profileClientProvider.createProfile(string, map);
    }

    private static final String resolvePkgs(Map map) {
        String string = null;
        if (map != null) {
            string = (String)map.get(PROFILE_PROVIDER_PACKAGES);
        }
        if (string == null) {
            string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(ProfileClientFactory.PROFILE_PROVIDER_PACKAGES);
                }
            });
        }
        string = string == null || string.trim().equals("") ? PROFILE_PROVIDER_DEFAULT_PACKAGE : string + "|com.sun.jmx.remote.profile";
        return string;
    }

    private static final ProfileClientProvider getProvider(String string, String string2, ClassLoader classLoader) throws ProfileProviderException {
        Class<?> clazz = null;
        Object var4_4 = null;
        Object object = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        String string3 = string.toLowerCase();
        if (string3.indexOf("/") != -1) {
            string3 = string3.substring(0, string3.indexOf("/"));
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            String string5 = string4 + "." + string3 + ".ClientProvider";
            try {
                clazz = classLoader.loadClass(string5);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            try {
                object = clazz.newInstance();
            }
            catch (Exception exception) {
                String string6 = "Exception when instantiating provider [" + string5 + "]";
                throw new ProfileProviderException(string6, exception);
            }
            if (!(object instanceof ProfileClientProvider)) {
                String string7 = "Provider not an instance of " + (class$com$sun$jmx$remote$generic$ProfileClientProvider == null ? (class$com$sun$jmx$remote$generic$ProfileClientProvider = ProfileClientFactory.class$("com.sun.jmx.remote.generic.ProfileClientProvider")) : class$com$sun$jmx$remote$generic$ProfileClientProvider).getName() + ": " + object.getClass().getName();
                throw new IllegalArgumentException(string7);
            }
            return (ProfileClientProvider)object;
        }
        return null;
    }

    private static final ClassLoader resolveClassLoader(Map map) {
        ClassLoader classLoader = null;
        if (map != null) {
            try {
                classLoader = (ClassLoader)map.get(PROFILE_PROVIDER_CLASS_LOADER);
            }
            catch (ClassCastException classCastException) {
                String string = "ClassLoader not an instance of java.lang.ClassLoader : " + classLoader.getClass().getName();
                throw new IllegalArgumentException(string);
            }
        }
        if (classLoader == null) {
            classLoader = (class$com$sun$jmx$remote$generic$ProfileClientFactory == null ? (class$com$sun$jmx$remote$generic$ProfileClientFactory = ProfileClientFactory.class$("com.sun.jmx.remote.generic.ProfileClientFactory")) : class$com$sun$jmx$remote$generic$ProfileClientFactory).getClassLoader();
        }
        return classLoader;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

