/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.mapping.ejb;

import com.sun.jdo.api.persistence.mapping.ejb.ConversionException;
import com.sun.jdo.api.persistence.mapping.ejb.ConversionHelper;
import com.sun.jdo.api.persistence.mapping.ejb.HasFetchedWith;
import com.sun.jdo.api.persistence.mapping.ejb.LogHelperMappingConversion;
import com.sun.jdo.api.persistence.mapping.ejb.beans.CheckVersionOfAccessedInstances;
import com.sun.jdo.api.persistence.mapping.ejb.beans.CmpFieldMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.CmrFieldMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.ColumnPair;
import com.sun.jdo.api.persistence.mapping.ejb.beans.Consistency;
import com.sun.jdo.api.persistence.mapping.ejb.beans.EntityMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.FetchedWith;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SecondaryTable;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMappings;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceClassElementImpl;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceFieldElementImpl;
import com.sun.jdo.api.persistence.model.jdo.impl.RelationshipElementImpl;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingRelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingClassElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingFieldElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingRelationshipElementImpl;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.KeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.schema2beans.Schema2BeansException;

public class MappingFile {
    private static final String JAVA_TYPE_SET = "java.util.Set";
    private static final String JAVA_TYPE_COLLECTION = "java.util.Collection";
    private static final List types = new ArrayList();
    public static String DEFAULT_LOCATION_IN_EJB_JAR = null;
    private static final Logger logger = LogHelperMappingConversion.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle(MappingFile.class);
    private Map inverseRelationships = null;
    private Map namedGroups = null;
    private int groupCount = -1;
    private ClassLoader classLoader = null;
    private static int MINIMUM_PRECISION;
    private ConversionHelper helper = null;
    private HashMap loadedSchema = new HashMap();

    public MappingFile() {
    }

    public MappingFile(ClassLoader cl) {
        this();
        this.classLoader = cl;
    }

    public Map intoMappingClasses(SunCmpMappings content, ConversionHelper helper) throws DBException, ModelException, ConversionException {
        HashMap<String, MappingClassElement> mces = new HashMap<String, MappingClassElement>();
        this.helper = helper;
        boolean ensureValidation = helper.ensureValidation();
        for (int i = 0; i < content.sizeSunCmpMapping(); ++i) {
            SunCmpMapping beanSet = content.getSunCmpMapping(i);
            this.inverseRelationships = new HashMap();
            this.namedGroups = new HashMap();
            String schema = beanSet.getSchema();
            if (helper.generateFields()) {
                this.completeCmrMappings(beanSet);
            }
            for (int k = 0; k < beanSet.sizeEntityMapping(); ++k) {
                MappingClassElement aTpMapping;
                EntityMapping beanMapping;
                block7: {
                    beanMapping = beanSet.getEntityMapping(k);
                    aTpMapping = null;
                    if (ensureValidation) {
                        aTpMapping = this.mapFieldsOfBean(beanMapping, schema);
                    } else {
                        try {
                            aTpMapping = this.mapFieldsOfBean(beanMapping, schema);
                        }
                        catch (ConversionException t) {
                            if (!logger.isLoggable(500)) break block7;
                            logger.fine(I18NHelper.getMessage(messages, "MESSAGE_CONV_EXC", t.toString()));
                        }
                    }
                }
                mces.put(beanMapping.getEjbName(), aTpMapping);
            }
        }
        return mces;
    }

    public Map intoMappingClasses(InputStream content, ConversionHelper helper) throws DBException, ModelException, ConversionException {
        SunCmpMappings foo = null;
        try {
            foo = SunCmpMappings.createGraph(content);
        }
        catch (Schema2BeansException t) {
            if (helper.ensureValidation()) {
                throw new ConversionException(I18NHelper.getMessage(messages, "XML_ERROR_IN_MAPPING_FILE", DEFAULT_LOCATION_IN_EJB_JAR));
            }
            foo = SunCmpMappings.createGraph();
        }
        return this.intoMappingClasses(foo, helper);
    }

    public void fromMappingClasses(OutputStream dest, Map mappingClasses, ConversionHelper helper) throws IOException, Schema2BeansException {
        SunCmpMappings tmp = this.fromMappingClasses(mappingClasses, helper);
        tmp.write(dest);
    }

    public SunCmpMappings fromMappingClasses(Map mappingClasses, ConversionHelper helper) throws Schema2BeansException {
        Iterator keyIter = mappingClasses.keySet().iterator();
        HashMap<String, SunCmpMapping> mapOfMapping = new HashMap<String, SunCmpMapping>();
        while (keyIter.hasNext()) {
            String ejbName = (String)keyIter.next();
            MappingClassElement mce = (MappingClassElement)mappingClasses.get(ejbName);
            EntityMapping beanMapping = new EntityMapping();
            if (null == mce) continue;
            this.setConsistency(mce, beanMapping);
            String schemaName = mce.getDatabaseRoot();
            SunCmpMapping aMapping = (SunCmpMapping)((Object)mapOfMapping.get(schemaName));
            if (null == aMapping) {
                aMapping = new SunCmpMapping();
                aMapping.setSchema(schemaName);
                mapOfMapping.put(schemaName, aMapping);
            }
            ArrayList tables = mce.getTables();
            MappingTableElement primary = null;
            if (tables.size() > 0) {
                primary = (MappingTableElement)tables.get(0);
                beanMapping.setTableName(primary.getName());
            }
            beanMapping.setEjbName(ejbName);
            if (null != primary) {
                ArrayList refKeys = primary.getReferencingKeys();
                for (int i = 0; refKeys != null && i < refKeys.size(); ++i) {
                    SecondaryTable sT = new SecondaryTable();
                    MappingReferenceKeyElement mrke = (MappingReferenceKeyElement)refKeys.get(i);
                    MappingTableElement mte = mrke.getTable();
                    if (null != mte) {
                        sT.setTableName(mte.getName());
                        ArrayList cpnames = mrke.getColumnPairNames();
                        boolean hasPairs = false;
                        for (int j = 0; cpnames != null && j < cpnames.size(); ++j) {
                            List token = StringHelper.separatedListToArray((String)cpnames.get(j), ";");
                            ColumnPair cp = new ColumnPair();
                            for (String columnName : token) {
                                cp.addColumnName(columnName);
                            }
                            sT.addColumnPair(cp);
                            hasPairs = true;
                        }
                        if (hasPairs) {
                            beanMapping.addSecondaryTable(sT);
                            continue;
                        }
                        if (!logger.isLoggable(500)) continue;
                        logger.fine(I18NHelper.getMessage(messages, "WARN_ILLEGAL_PAIR", new Object[]{ejbName, mte.getName(), cpnames}));
                        continue;
                    }
                    if (!logger.isLoggable(500)) continue;
                    logger.fine(I18NHelper.getMessage(messages, "WARN_MISSING_TABLE", new Object[]{ejbName, primary.getName()}));
                }
            } else if (logger.isLoggable(500)) {
                logger.fine(I18NHelper.getMessage(messages, "WARN_NO_PRIMARY", ejbName));
            }
            PersistenceClassElement pce = null;
            PersistenceFieldElement[] pfields = null;
            if (mce instanceof MappingClassElementImpl) {
                MappingClassElementImpl mcei = (MappingClassElementImpl)mce;
                pce = mcei.getPersistenceElement();
                pfields = pce.getFields();
            }
            int len = 0;
            if (null != pfields) {
                len = pfields.length;
            }
            for (int i = 0; i < len; ++i) {
                PersistenceFieldElement pfield = pfields[i];
                String fieldName = pfield.getName();
                if (helper.isGeneratedField(ejbName, fieldName)) continue;
                if (pfield instanceof RelationshipElement) {
                    ColumnPair cp;
                    int slen;
                    String cpstring;
                    int j;
                    MappingRelationshipElement mre;
                    MappingRelationshipElement mfe = mre = (MappingRelationshipElement)mce.getField(fieldName);
                    CmrFieldMapping cfm = new CmrFieldMapping();
                    cfm.setCmrFieldName(fieldName);
                    ArrayList cols = null;
                    if (null != mfe) {
                        cols = mfe.getColumns();
                        int fgVal = mfe.getFetchGroup();
                        this.setFetchedWith(cfm, fgVal);
                    }
                    for (j = 0; null != cols && j < cols.size(); ++j) {
                        cpstring = (String)cols.get(j);
                        slen = cpstring.indexOf(59);
                        cp = new ColumnPair();
                        cp.addColumnName(cpstring.substring(0, slen));
                        cp.addColumnName(cpstring.substring(slen + 1));
                        cfm.addColumnPair(cp);
                    }
                    if (null != mre) {
                        cols = mre.getAssociatedColumns();
                    }
                    for (j = 0; null != cols && j < cols.size(); ++j) {
                        cpstring = (String)cols.get(j);
                        slen = cpstring.indexOf(59);
                        cp = new ColumnPair();
                        cp.addColumnName(cpstring.substring(0, slen));
                        cp.addColumnName(cpstring.substring(slen + 1));
                        cfm.addColumnPair(cp);
                    }
                    beanMapping.addCmrFieldMapping(cfm);
                    continue;
                }
                MappingFieldElement mfe = mce.getField(fieldName);
                CmpFieldMapping cfm = new CmpFieldMapping();
                cfm.setFieldName(fieldName);
                ArrayList cols = null;
                if (null != mfe) {
                    cols = mfe.getColumns();
                    for (int j = 0; null != cols && j < cols.size(); ++j) {
                        cfm.addColumnName((String)cols.get(j));
                    }
                    int fgVal = mfe.getFetchGroup();
                    this.setFetchedWith(cfm, fgVal);
                }
                beanMapping.addCmpFieldMapping(cfm);
            }
            aMapping.addEntityMapping(beanMapping);
        }
        SunCmpMappings retVal = null;
        retVal = new SunCmpMappings();
        for (SunCmpMapping aVal : mapOfMapping.values()) {
            retVal.addSunCmpMapping(aVal);
        }
        return retVal;
    }

    private void setFetchedWith(HasFetchedWith cfm, int fgVal) {
        FetchedWith fw = new FetchedWith();
        if (fgVal <= -1) {
            String key = "IndependentFetchGroup" + fgVal;
            fw.setNamedGroup(key);
        } else if (fgVal == 1) {
            fw.setDefault(true);
        } else if (fgVal > 1) {
            fw.setLevel(fgVal - 1);
        } else if (fgVal == 0) {
            fw.setNone(true);
        }
        cfm.setFetchedWith(fw);
    }

    private MappingClassElement mapFieldsOfBean(EntityMapping mapping, String schemaArg) throws DBException, ModelException, ConversionException {
        String beanName = mapping.getEjbName();
        MappingClassElementImpl mce = null;
        ArrayList tablesOfBean = new ArrayList();
        HashMap knownTables = new HashMap();
        if (logger.isLoggable(500)) {
            logger.fine(I18NHelper.getMessage(messages, "MESSAGE_START_BEAN", beanName));
        }
        String jdoClassName = this.helper.getMappedClassName(beanName);
        if (logger.isLoggable(500)) {
            logger.fine(I18NHelper.getMessage(messages, "MESSAGE_JDOCLASS_NAME", beanName, jdoClassName));
        }
        if (null == jdoClassName) {
            throw new ConversionException(I18NHelper.getMessage(messages, "ERR_INVALID_CLASS", beanName));
        }
        PersistenceClassElementImpl persistElImpl = new PersistenceClassElementImpl(jdoClassName);
        persistElImpl.setKeyClass(jdoClassName + ".Oid");
        mce = new MappingClassElementImpl(new PersistenceClassElement(persistElImpl));
        SchemaElement schema = null;
        if (!StringHelper.isEmpty(schemaArg)) {
            schema = this.setDatabaseRoot(mce, schemaArg, this.helper.ensureValidation());
        }
        if (!StringHelper.isEmpty(mapping.getTableName())) {
            this.mapPrimaryTable(mapping, mce, schema, knownTables, tablesOfBean);
            this.mapSecondaryTables(mapping, mce, schema, knownTables, tablesOfBean);
        }
        ColumnElement candidatePK = null;
        candidatePK = this.mapNonRelationshipFields(mapping, mce, beanName, schema, knownTables);
        this.createMappingForUnknownPKClass(mapping, mce, beanName, candidatePK);
        this.createMappingForConsistency(mapping, mce, beanName, knownTables);
        this.mapRelationshipFields(mapping, mce, beanName, schema, knownTables, tablesOfBean);
        this.mapUnmappedFields(mce, beanName);
        return mce;
    }

    private void createMappingForUnknownPKClass(EntityMapping mapping, MappingClassElement mce, String beanName, ColumnElement candidatePK) throws ModelException, ConversionException {
        String primaryTableName = mapping.getTableName();
        if (this.helper.generateFields() && this.helper.applyDefaultUnknownPKClassStrategy(beanName)) {
            if (null != candidatePK) {
                String fieldName = this.helper.getGeneratedPKFieldName();
                PersistenceFieldElement pfe = this.createPersistenceField(mce, fieldName);
                pfe.setKey(true);
                MappingFieldElement mfe = this.createMappingField(mce, fieldName, candidatePK);
            } else {
                throw new ConversionException(I18NHelper.getMessage(messages, "WARN_NO_PKCOLUMN", primaryTableName));
            }
        }
    }

    private void createMappingForConsistency(EntityMapping mapping, MappingClassElement mce, String beanName, Map knownTables) throws ModelException, DBException, ConversionException {
        List versionColumns = this.loadConsistency(mapping, mce);
        if (versionColumns != null) {
            String versionColumnName;
            String primaryTableName = mapping.getTableName();
            if (versionColumns.size() > 1) {
                throw new ConversionException(I18NHelper.getMessage(messages, "ERR_INVALID_VERSION_COLUMNS"));
            }
            String versionColumn = (String)versionColumns.get(0);
            String sourceTableName = this.getTableName(versionColumn, primaryTableName);
            if (!sourceTableName.equals(primaryTableName)) {
                throw new ConversionException(I18NHelper.getMessage(messages, "WARN_VERSION_COLUMN_INVALID_TABLE", primaryTableName, beanName, versionColumn));
            }
            TableElement sourceTableEl = (TableElement)knownTables.get(sourceTableName);
            ColumnElement versionCol = this.getColumnElement(sourceTableEl, DBIdentifier.create((String)(versionColumnName = this.getColumnName(versionColumn))), this.helper);
            if (null != versionCol) {
                String fieldName = this.helper.getGeneratedVersionFieldNamePrefix();
                PersistenceFieldElement pfe = this.createPersistenceField(mce, fieldName);
                MappingFieldElement mfe = this.createMappingField(mce, fieldName, versionCol);
                mfe.setVersion(true);
            } else {
                throw new ConversionException(I18NHelper.getMessage(messages, "WARN_VERSION_COLUMN_MISSING", primaryTableName, beanName));
            }
        }
    }

    private ColumnElement mapNonRelationshipFields(EntityMapping mapping, MappingClassElement mce, String beanName, SchemaElement schema, Map knownTables) throws DBException, ModelException, ConversionException {
        CmpFieldMapping[] mapOfFields = mapping.getCmpFieldMapping();
        String primaryTableName = mapping.getTableName();
        ColumnElement candidatePK = null;
        if (this.helper.generateFields() && this.helper.applyDefaultUnknownPKClassStrategy(beanName)) {
            candidatePK = this.getCandidatePK(schema, primaryTableName);
        }
        for (int i = 0; i < mapOfFields.length; ++i) {
            CmpFieldMapping mapForOneField = mapOfFields[i];
            String fieldName = mapForOneField.getFieldName();
            if (!this.validateField(mce, beanName, fieldName, this.helper.ensureValidation())) {
                if (!logger.isLoggable(500)) continue;
                logger.fine(I18NHelper.getMessage(messages, "WARN_INVALID_FIELD", beanName, fieldName));
                continue;
            }
            String[] columnNames = mapForOneField.getColumnName();
            MappingFieldElement mfe = this.createUnmappedField(mce, beanName, fieldName);
            boolean fieldMappedToABlob = false;
            for (int j = 0; j < columnNames.length; ++j) {
                String sourceTableName = this.getTableName(columnNames[j], primaryTableName);
                if (null == sourceTableName) {
                    throw new ConversionException(I18NHelper.getMessage(messages, "ERR_UNDEFINED_TABLE"));
                }
                String sourceColumnName = this.getColumnName(columnNames[j]);
                TableElement sourceTableEl = this.getTableElement(sourceTableName, knownTables, schema);
                ColumnElement aCol = this.getColumnElement(sourceTableEl, DBIdentifier.create((String)sourceColumnName), this.helper);
                if (logger.isLoggable(500)) {
                    logger.fine(I18NHelper.getMessage(messages, "MESSAGE_ADD_COLUMN", new Object[]{aCol, fieldName}));
                }
                if (this.helper.generateFields() && this.helper.applyDefaultUnknownPKClassStrategy(beanName) && candidatePK != null && candidatePK.equals((Object)aCol)) {
                    candidatePK = null;
                }
                fieldMappedToABlob |= aCol.isBlobType();
                mfe.addColumn((DBMemberElement)aCol);
            }
            FetchedWith fw = mapForOneField.getFetchedWith();
            this.setFetchGroup(fw, mfe, beanName, fieldMappedToABlob);
            mce.addField(mfe);
        }
        return candidatePK;
    }

    private void mapRelationshipFields(EntityMapping mapping, MappingClassElement mce, String beanName, SchemaElement schema, Map knownTables, List tablesOfBean) throws ModelException, DBException, ConversionException {
        String primaryTableName = mapping.getTableName();
        CmrFieldMapping[] mapOfRelations = mapping.getCmrFieldMapping();
        PersistenceClassElement pce = ((MappingClassElementImpl)mce).getPersistenceElement();
        for (int i = 0; mapOfRelations != null && i < mapOfRelations.length; ++i) {
            CmrFieldMapping aRelation = mapOfRelations[i];
            String fieldName = aRelation.getCmrFieldName();
            if (!this.validateField(mce, beanName, fieldName, this.helper.ensureValidation())) {
                if (!logger.isLoggable(500)) continue;
                logger.fine(I18NHelper.getMessage(messages, "WARN_INVALID_CMRFIELD", beanName, fieldName));
                continue;
            }
            RelationshipElement rel = new RelationshipElement(new RelationshipElementImpl(fieldName), pce);
            MappingRelationshipElementImpl mre = new MappingRelationshipElementImpl(fieldName, mce);
            this.registerInverseRelationshipElement(rel, beanName, fieldName);
            ColumnPair[] pairs = aRelation.getColumnPair();
            String relationId = mapping.getEjbName() + "_Relationship_" + i;
            Collection primaryTableColumns = this.convertToColumnPairElements(pairs, primaryTableName, schema, knownTables, tablesOfBean, relationId, mre);
            this.setUpperBound(rel, beanName, fieldName);
            this.setCascadeDeleteAction(rel, beanName, fieldName);
            this.setLowerBound(rel, primaryTableColumns, primaryTableName, schema, knownTables, beanName, fieldName);
            this.setFetchGroup(aRelation.getFetchedWith(), mre, beanName, false);
            pce.addField(rel);
            mce.addField(mre);
        }
    }

    private void mapUnmappedFields(MappingClassElement mce, String beanName) throws ModelException {
        Object[] fields = this.helper.getFields(beanName);
        if (!this.helper.ensureValidation()) {
            for (int i = 0; i < fields.length; ++i) {
                String fieldName = (String)fields[i];
                MappingFieldElement mfe = mce.getField(fieldName);
                if (null != mfe) continue;
                mfe = this.createUnmappedField(mce, beanName, fieldName);
                mce.addField(mfe);
            }
        }
    }

    private void setConsistency(MappingClassElement mce, EntityMapping beanMapping) {
        int consistency = mce.getConsistencyLevel();
        if (0 != consistency) {
            Consistency c = new Consistency();
            if (6 == consistency) {
                c.setLockWhenModified(true);
                c.setCheckAllAtCommit(true);
            }
            if (4 == consistency) {
                c.setLockWhenModified(true);
            }
            if (2 == consistency) {
                c.setCheckAllAtCommit(true);
            }
            if (8 == consistency) {
                c.setLockWhenLoaded(true);
            }
            if (1 == consistency) {
                c.setCheckModifiedAtCommit(true);
            }
            if (16 == consistency) {
                CheckVersionOfAccessedInstances versionIns = new CheckVersionOfAccessedInstances();
                Iterator iter = mce.getVersionFields().iterator();
                while (iter.hasNext()) {
                    ArrayList columnNames = ((MappingFieldElement)iter.next()).getColumns();
                    if (columnNames == null || columnNames.size() <= 0) continue;
                    versionIns.addColumnName((String)columnNames.get(0));
                }
                c.setCheckVersionOfAccessedInstances(versionIns);
            }
            beanMapping.setConsistency(c);
        }
    }

    private List loadConsistency(EntityMapping mapping, MappingClassElement mce) throws ModelException, ConversionException {
        Consistency c = mapping.getConsistency();
        if (null == c) {
            mce.setConsistencyLevel(0);
        } else {
            CheckVersionOfAccessedInstances versionIns = c.getCheckVersionOfAccessedInstances();
            if (c.isCheckModifiedAtCommit()) {
                mce.setConsistencyLevel(1);
            } else if (c.isLockWhenLoaded()) {
                mce.setConsistencyLevel(8);
            } else if (c.isCheckAllAtCommit()) {
                mce.setConsistencyLevel(2);
            } else if (c.isLockWhenModified()) {
                mce.setConsistencyLevel(4);
            } else if (c.isLockWhenModified() && c.isCheckAllAtCommit()) {
                mce.setConsistencyLevel(6);
            } else if (c.isNone()) {
                mce.setConsistencyLevel(0);
            } else {
                if (versionIns != null) {
                    mce.setConsistencyLevel(16);
                    ArrayList<String> versionColumns = new ArrayList<String>();
                    for (int i = 0; i < versionIns.sizeColumnName(); ++i) {
                        versionColumns.add(versionIns.getColumnName(i));
                    }
                    return versionColumns;
                }
                throw new ConversionException(I18NHelper.getMessage(messages, "ERR_INVALID_CONSISTENCY_VALUE", mce));
            }
        }
        return null;
    }

    private void mapPrimaryTable(EntityMapping mapping, MappingClassElement mce, SchemaElement schema, Map knownTables, List tablesOfBean) throws DBException, ModelException, ConversionException {
        String primaryTableName = mapping.getTableName();
        TableElement primTabEl = this.getTableElement(primaryTableName, knownTables, schema);
        mce.addTable(primTabEl);
        tablesOfBean.add(primaryTableName);
    }

    private ColumnElement getCandidatePK(SchemaElement schema, String primaryTableName) throws DBException, ConversionException {
        ColumnElement[] cols;
        ColumnElement candidatePK = null;
        TableElement primTabEl = this.getTableElement(schema, DBIdentifier.create((String)primaryTableName), this.helper);
        UniqueKeyElement uke = primTabEl.getPrimaryKey();
        if (null != uke && null != (cols = uke.getColumns()) && 1 == cols.length) {
            candidatePK = cols[0];
            if (logger.isLoggable(500)) {
                logger.fine(I18NHelper.getMessage(messages, "MESSAGE_CANDIDATE_PK", candidatePK.getName()));
            }
            Integer pre = candidatePK.getPrecision();
            if (null != candidatePK && !candidatePK.isNumericType()) {
                candidatePK = null;
            }
            if (null != candidatePK && null != pre && pre < MINIMUM_PRECISION) {
                candidatePK = null;
            }
        }
        return candidatePK;
    }

    private Collection convertToColumnPairElements(ColumnPair[] pairs, String primaryTableName, SchemaElement schema, Map knownTables, List tablesOfBean, String relationId, MappingRelationshipElement mre) throws DBException, ModelException, ConversionException {
        ArrayList<ColumnElement> primaryTableColumns = new ArrayList<ColumnElement>();
        boolean isJoin = false;
        for (int i = 0; null != pairs && i < pairs.length; ++i) {
            ColumnPair pair = pairs[i];
            ColumnPairElement cpe = new ColumnPairElement();
            boolean localSet = false;
            cpe.setName(DBIdentifier.create((String)(relationId + "_ColumnPair_" + i)));
            for (int j = 0; j < 2; ++j) {
                String columnName = pair.getColumnName(j);
                String sourceTableName = this.getTableName(columnName, primaryTableName);
                String sourceColumnName = this.getColumnName(columnName);
                TableElement sourceTableEl = this.getTableElement(sourceTableName, knownTables, schema);
                ColumnElement ce = this.getColumnElement(sourceTableEl, DBIdentifier.create((String)sourceColumnName), this.helper);
                ce.toString();
                if (j == 0) {
                    if (tablesOfBean.contains(sourceTableName)) {
                        localSet = true;
                        primaryTableColumns.add(ce);
                    } else {
                        isJoin = true;
                        localSet = false;
                    }
                }
                if (cpe.getLocalColumn() == null) {
                    cpe.setLocalColumn(ce);
                    continue;
                }
                cpe.setReferencedColumn(ce);
            }
            if (localSet) {
                if (!isJoin) {
                    mre.addColumn((DBMemberElement)cpe);
                    continue;
                }
                mre.addLocalColumn(cpe);
                continue;
            }
            if (!isJoin) continue;
            mre.addAssociatedColumn(cpe);
        }
        return primaryTableColumns;
    }

    private void setLowerBound(RelationshipElement rel, Collection primaryTableColumns, String primaryTableName, SchemaElement schema, Map knownTables, String beanName, String fieldName) throws ModelException, DBException, ConversionException {
        rel.setLowerBound(0);
        if (logger.isLoggable(500)) {
            logger.fine(I18NHelper.getMessage(messages, "MESSAGE_LWB_NULL", beanName, fieldName));
        }
        if (1 == rel.getUpperBound() && null != primaryTableName) {
            boolean isPartOfPrimaryKey = false;
            TableElement primaryTable = this.getTableElement(primaryTableName, knownTables, schema);
            UniqueKeyElement pk = primaryTable.getPrimaryKey();
            ForeignKeyElement[] fks = primaryTable.getForeignKeys();
            Iterator iter = primaryTableColumns.iterator();
            while (iter.hasNext() && 0 == rel.getLowerBound()) {
                ColumnElement ce = (ColumnElement)iter.next();
                if (ce.isNullable()) continue;
                if (!(isPartOfPrimaryKey |= this.isPartOfPrimaryKey(ce, pk))) {
                    rel.setLowerBound(1);
                    if (!logger.isLoggable(500)) continue;
                    logger.fine(I18NHelper.getMessage(messages, "MESSAGE_LWB_NOPK", beanName, fieldName));
                    continue;
                }
                if (!this.isPartOfForeignKey(ce, fks)) continue;
                rel.setLowerBound(1);
                if (!logger.isLoggable(500)) continue;
                logger.fine(I18NHelper.getMessage(messages, "MESSAGE_LWB_FK", beanName, fieldName));
            }
            if (0 == rel.getLowerBound() && isPartOfPrimaryKey) {
                if (primaryTableColumns.size() < pk.getColumns().length) {
                    rel.setLowerBound(1);
                    if (logger.isLoggable(500)) {
                        logger.fine(I18NHelper.getMessage(messages, "MESSAGE_LWB_PKSUBSET", beanName, fieldName));
                    }
                } else if (this.isCascadeDelete(beanName, fieldName)) {
                    rel.setLowerBound(1);
                    if (logger.isLoggable(500)) {
                        logger.fine(I18NHelper.getMessage(messages, "MESSAGE_LWB_CASCADE", beanName, fieldName));
                    }
                } else if (logger.isLoggable(500)) {
                    logger.fine(I18NHelper.getMessage(messages, "MESSAGE_LWB_NODEPENDENT", beanName, fieldName));
                }
            }
        }
    }

    private TableElement getTableElement(String tableName, Map knownTables, SchemaElement schema) throws DBException, ConversionException {
        TableElement te = (TableElement)knownTables.get(tableName);
        if (null == te) {
            te = this.getTableElement(schema, DBIdentifier.create((String)tableName), this.helper);
            knownTables.put(tableName, te);
        }
        return te;
    }

    private boolean isPartOfPrimaryKey(ColumnElement ce, UniqueKeyElement pk) {
        return null != pk && ce.equals((Object)pk.getColumn(ce.getName()));
    }

    private boolean isPartOfForeignKey(ColumnElement ce, ForeignKeyElement[] fks) {
        if (fks != null) {
            for (int index = 0; index < fks.length; ++index) {
                if (!ce.equals((Object)fks[index].getColumn(ce.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCascadeDelete(String beanName, String fieldName) {
        String beanInField = this.helper.getRelationshipFieldContent(beanName, fieldName);
        String inverseField = this.helper.getInverseFieldName(beanName, fieldName);
        return null != beanInField && null != inverseField ? this.helper.relatedObjectsAreDeleted(beanInField, inverseField) : false;
    }

    private RelationshipElement registerInverseRelationshipElement(RelationshipElement rel, String beanName, String fieldName) throws ModelException {
        String key = beanName + "." + fieldName;
        RelationshipElement inverse = (RelationshipElement)this.inverseRelationships.get(key);
        if (null == inverse) {
            String beanInField = this.helper.getRelationshipFieldContent(beanName, fieldName);
            String inverseField = this.helper.getInverseFieldName(beanName, fieldName);
            if (null != beanInField && null != inverseField) {
                key = beanInField + "." + inverseField;
                this.inverseRelationships.put(key, rel);
            }
        } else {
            rel.changeInverseRelationship(inverse);
            inverse.changeInverseRelationship(rel);
        }
        return inverse;
    }

    private void setUpperBound(RelationshipElement rel, String beanName, String fieldName) throws ModelException, ConversionException {
        String beanInField = this.helper.getRelationshipFieldContent(beanName, fieldName);
        String classInJdoField = this.helper.getMappedClassName(beanInField);
        String multiplicity = this.helper.getMultiplicity(beanName, fieldName);
        if (multiplicity.equals("Many")) {
            rel.setUpperBound(Integer.MAX_VALUE);
            rel.setElementClass(classInJdoField);
            String collectionClass = this.helper.getRelationshipFieldType(beanName, fieldName);
            if (types.contains(collectionClass)) {
                rel.setCollectionClass(collectionClass);
            } else {
                rel.setCollectionClass(null);
                if (logger.isLoggable(900)) {
                    logger.warning(I18NHelper.getMessage(messages, "WARN_INVALID_RELATIONSHIP_FIELDTYPE", beanName, fieldName, collectionClass));
                }
            }
        } else if (multiplicity.equals("One")) {
            rel.setUpperBound(1);
            rel.setElementClass(classInJdoField);
        } else {
            throw new ConversionException(I18NHelper.getMessage(messages, "ERR_BAD_MULTIPLICTY", multiplicity, rel.getName()));
        }
    }

    private void setCascadeDeleteAction(RelationshipElement rel, String beanName, String fieldName) throws ModelException {
        if (this.helper.relatedObjectsAreDeleted(beanName, fieldName)) {
            if (logger.isLoggable(500)) {
                logger.fine(I18NHelper.getMessage(messages, "MESSAGE_REL_OBJ_DEL", beanName, fieldName));
            }
            rel.setDeleteAction(3);
        }
    }

    private SchemaElement setDatabaseRoot(MappingClassElement foo, String schemaElementValue, boolean strict) throws ModelException, DBException, ConversionException {
        SchemaElement bar = null;
        if (null != this.classLoader) {
            if (this.loadedSchema.get(schemaElementValue) == null) {
                SchemaElement.removeFromCache((String)schemaElementValue);
                this.loadedSchema.put(schemaElementValue, schemaElementValue);
            }
            bar = SchemaElement.forName((String)schemaElementValue, (Object)this.classLoader);
        } else {
            bar = SchemaElement.forName((String)schemaElementValue);
        }
        if (strict) {
            if (bar == null) {
                throw new ConversionException(I18NHelper.getMessage(messages, "ERR_CANNOT_FIND_SCHEMA", new Object[]{schemaElementValue, this.classLoader}));
            }
        } else if (null == bar) {
            bar = new SchemaElement();
            DBIdentifier n = DBIdentifier.create((String)schemaElementValue);
            n.setFullName(schemaElementValue);
            bar.setName(n);
        }
        foo.setDatabaseRoot(bar);
        return bar;
    }

    private String getTableName(String columnName, String defaultName) {
        String retVal = defaultName;
        int len = columnName.lastIndexOf(46);
        if (len > 0) {
            retVal = columnName.substring(0, len);
        }
        return retVal;
    }

    private String getColumnName(String columnName) {
        String retVal = columnName;
        int len = columnName.lastIndexOf(46);
        if (len > 0) {
            retVal = columnName.substring(len + 1);
        }
        return retVal;
    }

    private void mapSecondaryTables(EntityMapping mapping, MappingClassElement mce, SchemaElement schema, Map knownTables, List tablesOfBean) throws ModelException, DBException, ConversionException {
        SecondaryTable[] tableList = mapping.getSecondaryTable();
        ArrayList tl = mce.getTables();
        if (null != tl && tl.size() > 0 && null != tl.get(0)) {
            MappingTableElement primary = (MappingTableElement)tl.get(0);
            for (int i = 0; null != tableList && i < tableList.length; ++i) {
                String tn = tableList[i].getTableName();
                if (StringHelper.isEmpty(tn)) continue;
                TableElement te = this.getTableElement(schema, DBIdentifier.create((String)tn.trim()), this.helper);
                ColumnPair[] pairs = tableList[i].getColumnPair();
                int len = 0;
                if (null != pairs) {
                    len = pairs.length;
                }
                if (0 == len) {
                    if (!logger.isLoggable(900)) continue;
                    logger.warning(I18NHelper.getMessage(messages, "WARN_NO_PAIRS", new Object[]{mce, tn}));
                    continue;
                }
                MappingReferenceKeyElement mrke = mce.addSecondaryTable(primary, te);
                for (int j = 0; null != pairs && j < pairs.length; ++j) {
                    ColumnPairElement cpe = new ColumnPairElement();
                    DBIdentifier dbId = DBIdentifier.create((String)("SecondaryTable" + j));
                    cpe.setName(dbId);
                    ColumnPair pair = pairs[j];
                    for (int k = 0; k < 2; ++k) {
                        String nameOne = pair.getColumnName(k);
                        String sourceTableName = this.getTableName(nameOne.trim(), primary.getName().toString());
                        String sourceColumnName = this.getColumnName(nameOne);
                        dbId = DBIdentifier.create((String)sourceTableName);
                        TableElement sourceTableEl = this.getTableElement(schema, dbId, this.helper);
                        dbId = DBIdentifier.create((String)sourceColumnName);
                        ColumnElement ce = this.getColumnElement(sourceTableEl, dbId, this.helper);
                        if (k == 0) {
                            cpe.setLocalColumn(ce);
                            continue;
                        }
                        cpe.setReferencedColumn(ce);
                    }
                    mrke.addColumnPair(cpe);
                }
                knownTables.put(tn, te);
                tablesOfBean.add(tn);
            }
        } else {
            throw new ConversionException(I18NHelper.getMessage(messages, "WARN_NOT_MAPPED_TO_PRIMARY", mce.getName()));
        }
    }

    private boolean validateField(MappingClassElement mce, String beanName, String fieldName, boolean throwEx) throws ConversionException {
        MappingFieldElement mfe = mce.getField(fieldName);
        if (null != mfe) {
            if (throwEx) {
                throw new ConversionException(I18NHelper.getMessage(messages, "ERR_FIELD_MAPPED_TWICE", beanName, fieldName));
            }
            return false;
        }
        if (!this.helper.hasField(beanName, fieldName)) {
            if (throwEx) {
                throw new ConversionException(I18NHelper.getMessage(messages, "ERR_INVALID_FIELD", beanName, fieldName));
            }
            return false;
        }
        return true;
    }

    private Map getBean2EntityMappingMap(SunCmpMapping beanSet) {
        HashMap<String, EntityMapping> retVal = new HashMap<String, EntityMapping>();
        EntityMapping[] entityMappingsInSet = beanSet.getEntityMapping();
        int len = 0;
        if (null != entityMappingsInSet) {
            len = entityMappingsInSet.length;
        }
        for (int k = 0; k < len; ++k) {
            EntityMapping anEntityMapping = entityMappingsInSet[k];
            String beanName = anEntityMapping.getEjbName();
            beanName.trim().charAt(0);
            retVal.put(beanName, anEntityMapping);
        }
        return retVal;
    }

    private boolean completeCmrMappings(SunCmpMapping beanSet) throws ConversionException {
        Map beanName2EntityMapping = this.getBean2EntityMappingMap(beanSet);
        Iterator emIter = beanName2EntityMapping.values().iterator();
        boolean retVal = false;
        String errorMsg = I18NHelper.getMessage(messages, "ERR_BAD_CONVERSION_HELPER");
        while (emIter.hasNext()) {
            EntityMapping anEM = (EntityMapping)((Object)emIter.next());
            String beanName = anEM.getEjbName();
            String pt = anEM.getTableName();
            CmrFieldMapping[] cmrsInEM = anEM.getCmrFieldMapping();
            int len = 0;
            if (null != cmrsInEM && !StringHelper.isEmpty(beanName)) {
                len = cmrsInEM.length;
            }
            for (int i = 0; i < len; ++i) {
                String fieldName = cmrsInEM[i].getCmrFieldName();
                if (!this.helper.hasField(beanName, fieldName)) {
                    throw new ConversionException(I18NHelper.getMessage(messages, "WARN_INVALID_CMRFIELD", beanName, fieldName));
                }
                fieldName.trim().charAt(0);
                String otherField = this.helper.getInverseFieldName(beanName, fieldName);
                if (otherField == null) {
                    throw new ConversionException(errorMsg);
                }
                String otherBean = this.helper.getRelationshipFieldContent(beanName, fieldName);
                if (otherBean == null) {
                    throw new ConversionException(errorMsg);
                }
                if (!this.helper.isGeneratedRelationship(otherBean, otherField)) continue;
                retVal = true;
                String otherBeanName = this.helper.getRelationshipFieldContent(beanName, fieldName);
                otherBeanName.trim().charAt(0);
                EntityMapping otherEM = (EntityMapping)((Object)beanName2EntityMapping.get(otherBeanName));
                CmrFieldMapping inverseMapping = new CmrFieldMapping();
                inverseMapping.setCmrFieldName(otherField);
                inverseMapping.setColumnPair(this.reverseCPArray(cmrsInEM[i].getColumnPair(), pt, beanName, fieldName));
                otherEM.addCmrFieldMapping(inverseMapping);
            }
        }
        return retVal;
    }

    private ColumnPair[] reverseCPArray(ColumnPair[] cpa, String primeTable, String beanName, String fieldName) throws ConversionException {
        int len;
        int n = len = cpa == null ? 0 : cpa.length;
        if (len == 0) {
            throw new ConversionException(I18NHelper.getMessage(messages, "ERR_COLUMN_PAIR_MISSING", beanName, fieldName));
        }
        ColumnPair[] retVal = new ColumnPair[len];
        for (int index = 0; index < len; ++index) {
            retVal[index] = new ColumnPair();
            retVal[index].addColumnName(this.qualify(primeTable, cpa[index].getColumnName(1)));
            retVal[index].addColumnName(this.qualify(primeTable, cpa[index].getColumnName(0)));
        }
        return retVal;
    }

    private String qualify(String tn, String cn) {
        int tmp = cn.indexOf(46);
        String retVal = cn;
        if (-1 == tmp) {
            retVal = tn + "." + cn;
        }
        return retVal;
    }

    private TableElement getTableElement(SchemaElement schema, DBIdentifier dbId, ConversionHelper helper) throws DBException, ConversionException {
        TableElement retVal;
        TableElement tableElement = retVal = schema != null ? schema.getTable(dbId) : null;
        if (null == retVal && !helper.ensureValidation()) {
            retVal = new TableElement();
            retVal.setName(dbId);
            retVal.setDeclaringSchema(schema);
            UniqueKeyElement tkey = new UniqueKeyElement();
            ColumnElement fakeKeyCol = new ColumnElement();
            fakeKeyCol.setName(DBIdentifier.create((String)(retVal.getName().getName() + "." + "fookeyng")));
            fakeKeyCol.setType(2);
            fakeKeyCol.setPrecision(new Integer(MINIMUM_PRECISION));
            tkey.setPrimaryKey(true);
            tkey.addColumn(fakeKeyCol);
            retVal.addColumn(fakeKeyCol);
            retVal.addKey((KeyElement)tkey);
        }
        if (retVal == null) {
            throw new ConversionException(I18NHelper.getMessage(messages, "ERR_INVALID_TABLE", new Object[]{dbId.getName(), schema}));
        }
        return retVal;
    }

    private ColumnElement getColumnElement(TableElement sourceTableEl, DBIdentifier sourceColumnName, ConversionHelper helper) throws DBException, ConversionException {
        ColumnElement aCol = sourceTableEl.getColumn(sourceColumnName);
        if (null == aCol && !helper.ensureValidation()) {
            aCol = new ColumnElement();
            aCol.setName(DBIdentifier.create((String)(sourceTableEl.getName().toString() + "." + sourceColumnName.toString())));
            aCol.setDeclaringTable(sourceTableEl);
            aCol.setNullable(true);
        }
        if (aCol == null) {
            throw new ConversionException(I18NHelper.getMessage(messages, "ERR_INVALID_COLUMN", new Object[]{sourceColumnName, sourceTableEl}));
        }
        return aCol;
    }

    private MappingFieldElement createUnmappedField(MappingClassElement mce, String beanName, String fieldName) throws ModelException {
        PersistenceClassElement pce = ((MappingClassElementImpl)mce).getPersistenceElement();
        PersistenceFieldElementImpl pfei = new PersistenceFieldElementImpl(fieldName);
        PersistenceFieldElement pfe = new PersistenceFieldElement(pfei, pce);
        pfe.setKey(this.helper.isKey(beanName, fieldName, false));
        pce.addField(pfe);
        MappingFieldElementImpl mfe = new MappingFieldElementImpl(fieldName, mce);
        return mfe;
    }

    private void setFetchGroup(FetchedWith fw, MappingFieldElement mfe, String beanName, boolean fieldMappedToABlob) throws ModelException, ConversionException {
        if (null != fw) {
            String ig;
            boolean tryLevel = false;
            int level = 0;
            try {
                level = fw.getLevel();
                tryLevel = true;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (tryLevel) {
                if (level < 1) {
                    throw new ConversionException(I18NHelper.getMessage(messages, "ERR_INVALID_FG_LEVEL", beanName, mfe.getName(), "" + level));
                }
                mfe.setFetchGroup(level + 1);
            }
            if (null != (ig = fw.getNamedGroup())) {
                Integer fgval = (Integer)this.namedGroups.get(ig);
                if (null == fgval) {
                    fgval = new Integer(this.groupCount--);
                    this.namedGroups.put(ig, fgval);
                }
                mfe.setFetchGroup(fgval);
            }
            if (fw.isNone()) {
                mfe.setFetchGroup(0);
            }
            if (fw.isDefault()) {
                mfe.setFetchGroup(1);
            }
        } else if (mfe instanceof MappingRelationshipElement) {
            mfe.setFetchGroup(0);
        } else if (fieldMappedToABlob) {
            mfe.setFetchGroup(0);
        } else {
            mfe.setFetchGroup(1);
        }
    }

    private PersistenceFieldElement createPersistenceField(MappingClassElement mce, String fieldName) throws ModelException {
        PersistenceClassElement pce = ((MappingClassElementImpl)mce).getPersistenceElement();
        PersistenceFieldElementImpl pfei = new PersistenceFieldElementImpl(fieldName);
        PersistenceFieldElement pfe = new PersistenceFieldElement(pfei, pce);
        pce.addField(pfe);
        return pfe;
    }

    private MappingFieldElement createMappingField(MappingClassElement mce, String fieldName, ColumnElement col) throws ModelException {
        MappingFieldElementImpl mfe = new MappingFieldElementImpl(fieldName, mce);
        mce.addField(mfe);
        if (col != null) {
            mfe.addColumn((DBMemberElement)col);
        }
        return mfe;
    }

    static {
        types.add(JAVA_TYPE_SET);
        types.add(JAVA_TYPE_COLLECTION);
        DEFAULT_LOCATION_IN_EJB_JAR = new StringBuffer(I18NHelper.getMessage(messages, "CONST_IAS_MAPPING_FILE_LOC")).append(File.separator).append(I18NHelper.getMessage(messages, "CONST_IAS_MAPPING_FILE")).toString();
        MINIMUM_PRECISION = 19;
    }
}

