/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.cmp;

import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOHelper;
import com.sun.jdo.api.persistence.support.PersistenceCapable;
import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.spi.persistence.support.ejb.cmp.LogHelperEntityFinder;
import com.sun.jdo.spi.persistence.support.ejb.cmp.LogHelperEntityInternal;
import com.sun.jdo.spi.persistence.support.ejb.cmp.LogHelperEntityLifecycle;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.Arrays;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.ObjectNotFoundException;

public class CMPBeanHelper {
    private static final ResourceBundle cmpMessages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.ejb.ejbc.Bundle", CMPBeanHelper.class.getClassLoader());
    private static Logger cmpLifecycleLogger = LogHelperEntityLifecycle.getLogger();
    private static Logger cmpFinderLogger = LogHelperEntityFinder.getLogger();
    private static Logger cmpInternalLogger = LogHelperEntityInternal.getLogger();

    public static void logJDOExceptionWithLifecycleLogger(String key, String beanName, JDOException ex) {
        cmpLifecycleLogger.log(900, I18NHelper.getMessage(cmpMessages, key, beanName, CMPBeanHelper.findCallingMethodName()), ex);
    }

    public static void logJDOExceptionWithLifecycleLogger(String key, String beanName, String paramList, JDOException ex) {
        cmpLifecycleLogger.log(900, I18NHelper.getMessage(cmpMessages, key, beanName, CMPBeanHelper.findCallingMethodName(), paramList), ex);
    }

    public static void logJDOExceptionWithInternalLogger(String beanName, JDOException ex) {
        cmpInternalLogger.log(900, I18NHelper.getMessage(cmpMessages, "GEN.generic_method_exception", beanName, CMPBeanHelper.findCallingMethodName()), ex);
    }

    public static void logJDOExceptionWithFinderLogger(String beanName, Object[] params, JDOException ex) {
        String msg = null;
        msg = params != null ? I18NHelper.getMessage(cmpMessages, "GEN.ejbSSReturnBody_exception", beanName, CMPBeanHelper.findCallingMethodName(), Arrays.asList(params).toString()) : I18NHelper.getMessage(cmpMessages, "GEN.ejbSSReturnBody_exception_woparams", beanName, CMPBeanHelper.findCallingMethodName());
        cmpFinderLogger.log(900, msg, ex);
    }

    public static void logFinderException(int level, String beanName, Exception ex) {
        if (cmpFinderLogger.isLoggable(level)) {
            cmpFinderLogger.log(level, I18NHelper.getMessage(cmpMessages, "GEN.generic_method_exception", beanName, CMPBeanHelper.findCallingMethodName()), ex);
        }
    }

    public static String logJDOExceptionFromPKSetter(String beanName, JDOException ex) {
        String msg = I18NHelper.getMessage(cmpMessages, "EXC_PKUpdate", beanName, CMPBeanHelper.findCallingMethodName());
        if (cmpInternalLogger.isLoggable(500)) {
            cmpInternalLogger.log(500, msg, ex);
        }
        return msg;
    }

    public static void assertPersistent(PersistenceCapable pc, String beanName) {
        if (!JDOHelper.isPersistent(pc)) {
            String msg = I18NHelper.getMessage(cmpMessages, "GEN.cmrgettersetter_exception", beanName, CMPBeanHelper.findCallingMethodName());
            cmpInternalLogger.log(1000, msg);
            throw new IllegalStateException(msg);
        }
    }

    public static void assertCollectionNotNull(Collection c, String beanName) {
        if (c == null) {
            String msg = I18NHelper.getMessage(cmpMessages, "GEN.cmrsettercol_nullexception", beanName, CMPBeanHelper.findCallingMethodName());
            cmpInternalLogger.log(1000, msg);
            throw new IllegalArgumentException(msg);
        }
    }

    public static void assertPersistenceManagerNotNull(PersistenceManager pm, Object bean) {
        if (pm == null) {
            String msg = I18NHelper.getMessage(cmpMessages, "JDO.beannotloaded_exception", bean);
            cmpInternalLogger.log(1000, msg);
            throw new IllegalStateException(msg);
        }
    }

    public static void assertPersistenceManagerIsNull(PersistenceManager pm, Object bean) {
        if (pm != null) {
            String msg = I18NHelper.getMessage(cmpMessages, "JDO.beaninuse_exception", bean);
            cmpInternalLogger.log(1000, msg);
            throw new IllegalStateException(msg);
        }
    }

    public static void assertNotContainerTransaction(Object bean) {
        if (EJBHelper.getTransaction() != null) {
            String msg = I18NHelper.getMessage(cmpMessages, "JDO.containertransaction_exception", bean);
            cmpInternalLogger.log(1000, msg);
            throw new IllegalStateException(msg);
        }
    }

    public static void handleJDODuplicateObjectIdAsDuplicateKeyException(String beanName, String paramList, JDOException ex) throws DuplicateKeyException {
        String msg = I18NHelper.getMessage(cmpMessages, "GEN.ejbcreate_exception_dup", beanName, CMPBeanHelper.findCallingMethodName(), paramList);
        cmpLifecycleLogger.log(400, msg, ex);
        throw new DuplicateKeyException(msg);
    }

    public static void handleJDODuplicateObjectIdAsEJBException(String beanName, String paramList, JDOException ex) {
        String msg = I18NHelper.getMessage(cmpMessages, "GEN.ejbcreate_exception_dup", beanName, CMPBeanHelper.findCallingMethodName(), paramList);
        cmpLifecycleLogger.log(400, msg, ex);
        throw new EJBException(msg);
    }

    public static void handleJDOObjectNotFoundException(Object primaryKey, String beanName, JDOException ex) throws ObjectNotFoundException {
        String msg = I18NHelper.getMessage(cmpMessages, "GEN.findbypk_exception_notfound", beanName, primaryKey.toString());
        cmpLifecycleLogger.log(400, msg, ex);
        throw new ObjectNotFoundException(msg);
    }

    public static void handleUpdateNotAllowedException(String beanName) {
        String msg = I18NHelper.getMessage(cmpMessages, "GEN.update_not_allowed", beanName, CMPBeanHelper.findCallingMethodName());
        cmpLifecycleLogger.log(1000, msg);
        throw new EJBException(msg);
    }

    public static void handleCloneException(Object primaryKey, String beanName, Exception ex) {
        String msg = I18NHelper.getMessage(cmpMessages, "GEN.clone_exception", beanName, primaryKey.toString());
        cmpLifecycleLogger.log(1000, msg, ex);
        throw new EJBException(msg);
    }

    private static String findCallingMethodName() {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        return ste[2].getMethodName();
    }
}

