/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.BaseProcessor;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.DeploymentHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Set;

public class CMPProcessor
extends BaseProcessor {
    public CMPProcessor(DeploymentEventInfo info, boolean deploy, boolean redeploy, String cliCreateTables, String cliDropAndCreateTables, String cliDropTables) {
        super(info, deploy, redeploy, cliCreateTables, cliDropAndCreateTables, cliDropTables);
    }

    protected void processApplication() {
        Set bundleCollection = this.application.getEjbBundleDescriptors();
        if (bundleCollection == null) {
            return;
        }
        Iterator bundleItr = bundleCollection.iterator();
        while (bundleItr.hasNext()) {
            this.processAppBundle((EjbBundleDescriptor)bundleItr.next());
        }
    }

    private void processAppBundle(EjbBundleDescriptor bundle) {
        if (!bundle.containsCMPEntity()) {
            return;
        }
        ResourceReferenceDescriptor cmpResource = bundle.getCMPResourceReference();
        if (!DeploymentHelper.isJavaToDatabase(cmpResource.getSchemaGeneratorProperties())) {
            return;
        }
        boolean createTables = this.getCreateTablesValue(cmpResource);
        boolean dropTables = this.getDropTablesValue(cmpResource);
        if (this.debug) {
            logger.fine("ejb.CMPProcessor.createanddroptables", new Object[]{new Boolean(createTables), new Boolean(dropTables)});
        }
        if (!createTables && !dropTables) {
            return;
        }
        this.setApplicationLocation();
        this.setGeneratedLocation();
        this.constructJdbcFileNames(bundle);
        if (this.debug) {
            logger.fine("ejb.CMPProcessor.createanddropfilenames", this.createJdbcFileName, this.dropJdbcFileName);
        }
        this.dropTablesFromDB(dropTables, cmpResource.getJndiName());
        this.createTablesInDB(createTables, cmpResource.getJndiName());
    }

    protected boolean getCreateTablesValue(ResourceReferenceDescriptor cmpResource) {
        boolean createTables = this.deploy && (this.cliCreateTables.equals("true") || cmpResource.isCreateTablesAtDeploy() && this.cliCreateTables.equals("undefined"));
        return createTables;
    }

    protected boolean getDropTablesValue(ResourceReferenceDescriptor cmpResource) {
        boolean dropTables = this.redeploy && (this.cliDropAndCreateTables.equals("true") || cmpResource.isDropTablesAtUndeploy() && this.cliDropAndCreateTables.equals("undefined")) || !this.deploy && (this.cliDropTables.equals("true") || cmpResource.isDropTablesAtUndeploy() && this.cliDropTables.equals("undefined"));
        return dropTables;
    }

    private void constructJdbcFileNames(EjbBundleDescriptor ejbBundle) {
        String filePrefix = EJBHelper.getDDLNamePrefix(ejbBundle);
        this.createJdbcFileName = filePrefix + "_createDDL.jdbc";
        this.dropJdbcFileName = filePrefix + "_dropDDL.jdbc";
    }

    private boolean dropTablesFromDB(boolean dropTables, String resourceName) {
        boolean dropResult = false;
        File dropFile = null;
        if (dropTables) {
            dropFile = this.getDropDDLFile(this.dropJdbcFileName, this.deploy);
            if (dropFile.exists()) {
                dropResult = this.executeDDLStatement(dropFile, resourceName);
            } else if (this.debug) {
                logger.fine("ejb.BaseProcessor.cannotdroptables", dropFile.getName());
            }
        }
        return dropResult;
    }

    private boolean createTablesInDB(boolean createTables, String resourceName) {
        boolean createResult = false;
        File createFile = null;
        if (createTables) {
            createFile = this.getCreateDDLFile(this.appGeneratedLocation + this.createJdbcFileName);
            if (createFile.exists()) {
                createResult = this.executeDDLStatement(createFile, resourceName);
            } else if (this.debug) {
                logger.fine("ejb.BaseProcessor.cannotcreatetables", createFile.getName());
            }
        }
        return createResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeDDLStatement(File fileName, String resourceName) {
        boolean result = false;
        Connection conn = null;
        Statement sql = null;
        try {
            try {
                conn = DeploymentHelper.getConnection(resourceName);
                sql = conn.createStatement();
                result = true;
            }
            catch (SQLException ex) {
                this.cannotConnect(resourceName, ex);
            }
            catch (JDOFatalUserException ex) {
                this.cannotConnect(resourceName, ex);
            }
            if (result) {
                this.executeDDLs(fileName, sql);
            }
        }
        catch (IOException e) {
            this.fileIOError(this.application.getRegistrationName(), e);
        }
        finally {
            CMPProcessor.closeConn(conn);
        }
        return result;
    }
}

