/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.folb;

import com.sun.corba.ee.impl.interceptors.IORInfoImpl;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.folb.CSIv2SSLTaggedComponentHandler;
import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.ClusterInstanceInfoHelper;
import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.corba.ee.spi.folb.GroupInfoServiceObserver;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.corba.ee.spi.oa.rfm.ReferenceFactory;
import com.sun.corba.ee.spi.oa.rfm.ReferenceFactoryManager;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBConfigurator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.LinkedList;
import java.util.List;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ForwardRequestHelper;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class ServerGroupManager
extends LocalObject
implements GroupInfoServiceObserver,
IORInterceptor,
ORBConfigurator,
ORBInitializer,
ServerRequestInterceptor {
    private static final String baseMsg = ServerGroupManager.class.getName();
    private boolean debug = false;
    private ORB orb;
    private GroupInfoService gis;
    private CSIv2SSLTaggedComponentHandler csiv2SSLTaggedComponentHandler;
    private String membershipLabel;
    private MembershipChangeState membershipChangeState = MembershipChangeState.IDLE;
    private ReferenceFactoryManager referenceFactoryManager;
    private Codec codec;
    private boolean initialized = false;
    private static final String ORB_LISTENER = "orb-listener";
    private static final String SSL = "SSL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.initialized) {
            return;
        }
        try {
            if (this.debug) {
                this.dprint(".initialize->:");
            }
            this.initialized = true;
            this.updateMembershipLabel();
            CodecFactory codecFactory = CodecFactoryHelper.narrow((Object)this.orb.resolve_initial_references("CodecFactory"));
            this.codec = codecFactory.create_codec(new Encoding(0, 1, 2));
            this.referenceFactoryManager = (ReferenceFactoryManager)this.orb.resolve_initial_references("ReferenceFactoryManager");
            this.gis = (GroupInfoService)PortableRemoteObject.narrow(this.orb.resolve_initial_references("FolbServerGroupInfoService"), GroupInfoService.class);
            this.gis.addObserver(this);
            try {
                this.csiv2SSLTaggedComponentHandler = (CSIv2SSLTaggedComponentHandler)this.orb.resolve_initial_references("CSIv2SSLTaggedComponentHandler");
            }
            catch (InvalidName e) {
                this.csiv2SSLTaggedComponentHandler = null;
                if (this.debug) {
                    this.dprint(".initialize: not found: CSIv2SSLTaggedComponentHandler");
                }
            }
        }
        catch (InvalidName e) {
            this.dprint(".initialize: " + (java.lang.Object)((java.lang.Object)e));
        }
        catch (UnknownEncoding e) {
            this.dprint(".initialize: " + (java.lang.Object)((java.lang.Object)e));
        }
        finally {
            if (this.debug) {
                this.dprint(".initialize<-:");
            }
        }
    }

    public String name() {
        return baseMsg;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establish_components(IORInfo iorInfo) {
        try {
            TaggedComponent csiv2;
            ReferenceFactory rf;
            if (this.debug) {
                this.dprint(".establish_components->:");
            }
            this.initialize();
            String[] adapterName = ((IORInfoImpl)iorInfo).getObjectAdapter().getAdapterTemplate().adapter_name();
            if (this.debug) {
                this.dprint(".establish_components: adapterName: ", adapterName);
            }
            if ((rf = this.referenceFactoryManager.find(adapterName)) == null) {
                if (this.gis.shouldAddAddressesToNonReferenceFactory(adapterName)) {
                    if (this.debug) {
                        this.dprint(".establish_components: not managed by ReferenceFactory but adding addresses:", adapterName);
                    }
                } else {
                    if (this.debug) {
                        this.dprint(".establish_components: not managed by ReferenceFactory:", adapterName);
                    }
                    return;
                }
            }
            List<ClusterInstanceInfo> info = this.gis.getClusterInstanceInfo(adapterName);
            if (this.csiv2SSLTaggedComponentHandler != null && (csiv2 = this.csiv2SSLTaggedComponentHandler.insert(iorInfo, info)) != null) {
                iorInfo.add_ior_component(csiv2);
            }
            for (ClusterInstanceInfo clusterInstanceInfo : info) {
                if (this.debug) {
                    this.dprint(".establish_components: adding instance info for: " + clusterInstanceInfo.name + "; " + clusterInstanceInfo.weight + "; with addresses:");
                }
                LinkedList<SocketInfo> listOfSocketInfo = new LinkedList<SocketInfo>();
                for (int i = 0; i < clusterInstanceInfo.endpoints.length; ++i) {
                    if (clusterInstanceInfo.endpoints[i].type.startsWith(SSL)) {
                        if (!this.debug) continue;
                        this.dprint(".establish_components: skipping: " + clusterInstanceInfo.endpoints[i].type + "/" + clusterInstanceInfo.endpoints[i].host + "/" + clusterInstanceInfo.endpoints[i].port);
                        continue;
                    }
                    if (this.debug) {
                        this.dprint(".establish_components: " + clusterInstanceInfo.endpoints[i].type + "/" + clusterInstanceInfo.endpoints[i].host + "/" + clusterInstanceInfo.endpoints[i].port);
                    }
                    listOfSocketInfo.add(clusterInstanceInfo.endpoints[i]);
                }
                SocketInfo[] arrayOfSocketInfo = new SocketInfo[listOfSocketInfo.size()];
                int x = 0;
                for (SocketInfo si : listOfSocketInfo) {
                    arrayOfSocketInfo[x++] = si;
                }
                clusterInstanceInfo.endpoints = arrayOfSocketInfo;
                Any any = this.orb.create_any();
                ClusterInstanceInfoHelper.insert(any, clusterInstanceInfo);
                byte[] data = null;
                try {
                    data = this.codec.encode_value(any);
                }
                catch (InvalidTypeForEncoding e) {
                    this.dprint(".establish_components: " + (java.lang.Object)((java.lang.Object)e));
                }
                TaggedComponent tc = new TaggedComponent(1398099459, data);
                iorInfo.add_ior_component(tc);
            }
            if (this.gis.shouldAddMembershipLabel(adapterName)) {
                TaggedComponent tc = new TaggedComponent(1398099460, this.membershipLabel.getBytes());
                if (this.debug) {
                    this.dprint(".establish_components: adding membership label: " + this.membershipLabel);
                }
                iorInfo.add_ior_component(tc);
            } else if (this.debug) {
                this.dprint(".establish_components: NOT adding membership label");
            }
        }
        catch (RuntimeException e) {
            this.dprint(".establish_components: exception: " + e);
        }
        finally {
            if (this.debug) {
                this.dprint(".establish_components<-:");
            }
        }
    }

    public void components_established(IORInfo iorInfo) {
    }

    public void adapter_manager_state_changed(int managerId, short state) {
    }

    public void adapter_state_changed(ObjectReferenceTemplate[] templates, short state) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void membershipChange() {
        try {
            boolean loop;
            if (this.debug) {
                this.dprint(".membershipChange->:");
            }
            ServerGroupManager serverGroupManager = this;
            synchronized (serverGroupManager) {
                if (this.membershipChangeState != MembershipChangeState.IDLE) {
                    this.membershipChangeState = MembershipChangeState.RETRY_REQUIRED;
                    if (!this.debug) return;
                    this.dprint(".membershipChange: already changing");
                    return;
                }
                this.membershipChangeState = MembershipChangeState.DOING_WORK;
            }
            do {
                loop = false;
                this.restartFactories();
                ServerGroupManager serverGroupManager2 = this;
                synchronized (serverGroupManager2) {
                    if (this.membershipChangeState == MembershipChangeState.RETRY_REQUIRED) {
                        this.membershipChangeState = MembershipChangeState.DOING_WORK;
                        loop = true;
                        if (this.debug) {
                            this.dprint(".membershipChange: looping");
                        }
                    } else if (this.membershipChangeState == MembershipChangeState.DOING_WORK) {
                        this.membershipChangeState = MembershipChangeState.IDLE;
                    } else if (this.membershipChangeState == MembershipChangeState.IDLE && this.debug) {
                        this.dprint(".membershipChange: unexpected state: " + (java.lang.Object)((java.lang.Object)this.membershipChangeState));
                    }
                }
            } while (loop);
            return;
        }
        catch (RuntimeException e) {
            this.dprint(".membershipChange: " + e);
            ServerGroupManager serverGroupManager = this;
            synchronized (serverGroupManager) {
                this.membershipChangeState = MembershipChangeState.IDLE;
                return;
            }
        }
        finally {
            if (this.debug) {
                this.dprint(".membershipChange<-:");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartFactories() {
        final java.lang.Object signal = new java.lang.Object();
        final ReferenceFactoryManager rfm = this.referenceFactoryManager;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (ServerGroupManager.this.debug) {
                        ServerGroupManager.this.dprint(".membershipChange: rfm.suspend");
                    }
                    rfm.suspend();
                    if (ServerGroupManager.this.debug) {
                        ServerGroupManager.this.dprint(".membershipChange: updating membership label");
                    }
                    ServerGroupManager.this.updateMembershipLabel();
                    if (ServerGroupManager.this.debug) {
                        ServerGroupManager.this.dprint(".membershipChange: rfm.restartFactories");
                    }
                    rfm.restartFactories();
                }
                finally {
                    if (ServerGroupManager.this.debug) {
                        ServerGroupManager.this.dprint(".membershipChange: rfm.resume");
                    }
                    rfm.resume();
                }
                if (ServerGroupManager.this.debug) {
                    ServerGroupManager.this.dprint(".membershipChange: notifying signal");
                }
                java.lang.Object object = signal;
                synchronized (object) {
                    signal.notifyAll();
                }
                if (ServerGroupManager.this.debug) {
                    ServerGroupManager.this.dprint(".membershipChange: done with rfm");
                }
            }
        }.start();
        if (this.debug) {
            this.dprint(".membershipChange: waiting for signal");
        }
        java.lang.Object object = signal;
        synchronized (object) {
            boolean tryAgain;
            do {
                tryAgain = false;
                try {
                    signal.wait();
                }
                catch (InterruptedException e) {
                    tryAgain = true;
                }
            } while (tryAgain);
        }
        if (this.debug) {
            this.dprint(".membershipChange: done waiting for signal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMembershipLabel() {
        if (this.debug) {
            this.dprint(".updateMembershipLabel->:");
        }
        UID uid = new UID();
        String hostAddress = null;
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
            this.membershipLabel = hostAddress + ":::" + uid;
            if (this.debug) {
                this.dprint(".updateMembershipLabel: " + this.membershipLabel);
            }
        }
        catch (UnknownHostException e) {
            this.dprint(".updateMembershipLabel: " + e);
        }
        finally {
            if (this.debug) {
                this.dprint(".updateMembershipLabel<-:");
            }
        }
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) {
        if (this.debug) {
            this.dprint(".receive_request_service_contexts->: " + ri.operation());
        }
        this.initialize();
        if (this.debug) {
            this.dprint(".receive_request_service_contexts<-: " + ri.operation());
        }
    }

    public void receive_request(ServerRequestInfo ri) {
        if (this.debug) {
            this.dprint(".receive_request->: " + ri.operation());
        }
        this.initialize();
        if (this.debug) {
            this.dprint(".receive_request<-: " + ri.operation());
        }
    }

    public void send_reply(ServerRequestInfo ri) {
        this.send_star(".send_reply", ri);
    }

    public void send_exception(ServerRequestInfo ri) {
        this.send_star(".send_exception", ri);
    }

    public void send_other(ServerRequestInfo ri) {
        this.send_star(".send_other", ri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send_star(String point, ServerRequestInfo ri) {
        String[] adapterName = null;
        try {
            ReferenceFactory referenceFactory;
            block23: {
                block24: {
                    adapterName = ri.adapter_name();
                    if (this.debug) {
                        this.dprint(point + "->:", adapterName);
                    }
                    if (this.referenceFactoryManager.getState().value() == 0) {
                        if (this.debug) {
                            this.dprint(point + ": RFM in HOLDING - therefore no action");
                        }
                        return;
                    }
                    referenceFactory = this.referenceFactoryManager.find(adapterName);
                    if (referenceFactory == null) {
                        if (this.debug) {
                            this.dprint(point + ": not managed by ReferenceFactory", adapterName);
                        }
                        return;
                    }
                    String requestMembershipLabel = null;
                    ServiceContext sc = ri.get_request_service_context(1398099457);
                    if (sc == null) break block23;
                    byte[] data = sc.context_data;
                    requestMembershipLabel = new String(data);
                    if (!this.membershipLabel.equals(requestMembershipLabel)) break block24;
                    if (this.debug) {
                        this.dprint(point + ": membership labels EQUAL", adapterName);
                    }
                    return;
                }
                try {
                    if (this.debug) {
                        this.dprint(point + ": membership labels NOT equal", adapterName);
                    }
                }
                catch (BAD_PARAM e) {
                    if (!this.debug) break block23;
                    this.dprint(point + ": membership label not present", adapterName);
                }
            }
            if (this.debug) {
                this.dprint(point + ": sending updated IOR", adapterName);
            }
            byte[] objectId = ri.object_id();
            Object ref = referenceFactory.createReference(objectId);
            Any any = this.orb.create_any();
            ForwardRequest fr = new ForwardRequest(ref);
            ForwardRequestHelper.insert((Any)any, (ForwardRequest)fr);
            byte[] data = null;
            try {
                data = this.codec.encode_value(any);
            }
            catch (InvalidTypeForEncoding e) {
                this.dprint(point + ": " + (java.lang.Object)((java.lang.Object)e));
            }
            ServiceContext sc = new ServiceContext(1398099458, data);
            ri.add_reply_service_context(sc, false);
        }
        catch (RuntimeException e) {
            if (this.debug) {
                this.dprint(point + ": exception: " + e, adapterName);
            }
        }
        finally {
            if (this.debug) {
                this.dprint(point + "<-:", adapterName);
            }
        }
    }

    public void pre_init(ORBInitInfo info) {
    }

    public void post_init(ORBInitInfo info) {
        if (this.debug) {
            this.dprint(".post_init->:");
        }
        try {
            info.add_ior_interceptor((IORInterceptor)this);
            info.add_server_request_interceptor((ServerRequestInterceptor)this);
        }
        catch (Exception e) {
            this.dprint(".post_init: " + e);
        }
        if (this.debug) {
            this.dprint(".post_init<-:");
        }
    }

    public void configure(DataCollector collector, ORB orb) {
        boolean bl = this.debug = this.debug || orb.transportDebugFlag;
        if (this.debug) {
            this.dprint(".configure->:");
        }
        this.orb = orb;
        orb.getORBData().addORBInitializer(this);
        if (this.debug) {
            this.dprint(".configure<-:");
        }
    }

    private void dprint(String msg) {
        ORBUtility.dprint("ServerGroupManager", msg);
    }

    private void dprint(String msg, String[] x) {
        this.dprint(msg + " " + ORBUtility.formatStringArray(x));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MembershipChangeState {
        IDLE,
        DOING_WORK,
        RETRY_REQUIRED;

    }
}

