/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orb;

import com.sun.corba.ee.impl.orb.ParserAction;
import com.sun.corba.ee.impl.orb.PropertyCallback;
import com.sun.corba.ee.impl.orbutil.GetPropertyAction;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.PropertyParser;
import java.applet.Applet;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class DataCollectorBase
implements DataCollector {
    private PropertyParser parser;
    private Set propertyNames;
    private Set propertyPrefixes;
    private Set URLPropertyNames = new HashSet();
    protected String localHostName;
    protected String configurationHostName;
    private boolean setParserCalled;
    private Properties originalProps;
    private Properties resultProps;

    public DataCollectorBase(Properties props, String localHostName, String configurationHostName) {
        this.URLPropertyNames.add("org.omg.CORBA.ORBInitialServices");
        this.propertyNames = new HashSet();
        this.propertyNames.add("org.omg.CORBA.ORBInitRef");
        this.propertyPrefixes = new HashSet();
        this.originalProps = props;
        this.localHostName = localHostName;
        this.configurationHostName = configurationHostName;
        this.setParserCalled = false;
        this.resultProps = new Properties();
    }

    public boolean initialHostIsLocal() {
        this.checkSetParserCalled();
        return this.localHostName.equals(this.resultProps.getProperty("org.omg.CORBA.ORBInitialHost"));
    }

    public void setParser(PropertyParser parser) {
        Iterator iter = parser.iterator();
        while (iter.hasNext()) {
            ParserAction pa = (ParserAction)iter.next();
            if (pa.isPrefix()) {
                this.propertyPrefixes.add(pa.getPropertyName());
                continue;
            }
            this.propertyNames.add(pa.getPropertyName());
        }
        this.collect();
        this.setParserCalled = true;
    }

    public Properties getProperties() {
        this.checkSetParserCalled();
        return this.resultProps;
    }

    public abstract boolean isApplet();

    protected abstract void collect();

    protected void checkPropertyDefaults() {
        String host = this.resultProps.getProperty("org.omg.CORBA.ORBInitialHost");
        if (host == null || host.equals("")) {
            this.setProperty("org.omg.CORBA.ORBInitialHost", this.configurationHostName);
        }
    }

    protected void findPropertiesFromArgs(String[] params) {
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            String argName;
            String value = null;
            String name = null;
            if (params[i] != null && params[i].startsWith("-ORB") && (name = this.findMatchingPropertyName(this.propertyNames, argName = params[i].substring(1))) != null && i + 1 < params.length && params[i + 1] != null) {
                value = params[++i];
            }
            if (value == null) continue;
            this.setProperty(name, value);
        }
    }

    protected void findPropertiesFromApplet(final Applet app) {
        if (app == null) {
            return;
        }
        PropertyCallback callback = new PropertyCallback(){

            public String get(String name) {
                return app.getParameter(name);
            }
        };
        this.findPropertiesByName(this.propertyNames.iterator(), callback);
        PropertyCallback URLCallback = new PropertyCallback(){

            public String get(String name) {
                String value = DataCollectorBase.this.resultProps.getProperty(name);
                if (value == null) {
                    return null;
                }
                try {
                    URL url = new URL(app.getDocumentBase(), value);
                    return url.toExternalForm();
                }
                catch (MalformedURLException exc) {
                    return value;
                }
            }
        };
        this.findPropertiesByName(this.URLPropertyNames.iterator(), URLCallback);
    }

    private void doProperties(final Properties props) {
        PropertyCallback callback = new PropertyCallback(){

            public String get(String name) {
                return props.getProperty(name);
            }
        };
        this.findPropertiesByName(this.propertyNames.iterator(), callback);
        this.findPropertiesByPrefix(this.propertyPrefixes, DataCollectorBase.makeIterator(props.propertyNames()), callback);
    }

    protected void findPropertiesFromFile() {
        Properties fileProps = this.getFileProperties();
        if (fileProps == null) {
            return;
        }
        this.doProperties(fileProps);
    }

    protected void findPropertiesFromProperties() {
        if (this.originalProps == null) {
            return;
        }
        this.doProperties(this.originalProps);
    }

    protected void findPropertiesFromSystem() {
        Set normalNames = this.getCORBAPrefixes(this.propertyNames);
        Set prefixNames = this.getCORBAPrefixes(this.propertyPrefixes);
        PropertyCallback callback = new PropertyCallback(){

            public String get(String name) {
                return DataCollectorBase.getSystemProperty(name);
            }
        };
        this.findPropertiesByName(normalNames.iterator(), callback);
        this.findPropertiesByPrefix(prefixNames, DataCollectorBase.getSystemPropertyNames(), callback);
    }

    private void setProperty(String name, String value) {
        if (name.equals("org.omg.CORBA.ORBInitRef")) {
            StringTokenizer st = new StringTokenizer(value, "=");
            if (st.countTokens() != 2) {
                throw new IllegalArgumentException();
            }
            String refName = st.nextToken();
            String refValue = st.nextToken();
            this.resultProps.setProperty(name + "." + refName, refValue);
        } else {
            this.resultProps.setProperty(name, value);
        }
    }

    private void checkSetParserCalled() {
        if (!this.setParserCalled) {
            throw new IllegalStateException("setParser not called.");
        }
    }

    private void findPropertiesByPrefix(Set prefixes, Iterator propertyNames, PropertyCallback getProperty) {
        while (propertyNames.hasNext()) {
            String name = (String)propertyNames.next();
            for (String prefix : prefixes) {
                if (!name.startsWith(prefix)) continue;
                String value = getProperty.get(name);
                this.setProperty(name, value);
            }
        }
    }

    private void findPropertiesByName(Iterator names, PropertyCallback getProperty) {
        while (names.hasNext()) {
            String name = (String)names.next();
            String value = getProperty.get(name);
            if (value == null) continue;
            this.setProperty(name, value);
        }
    }

    private static String getSystemProperty(String name) {
        return (String)AccessController.doPrivileged(new GetPropertyAction(name));
    }

    private String findMatchingPropertyName(Set names, String suffix) {
        for (String name : names) {
            if (!name.endsWith(suffix)) continue;
            return name;
        }
        return null;
    }

    private static Iterator makeIterator(final Enumeration enumeration) {
        return new Iterator(){

            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            public Object next() {
                return enumeration.nextElement();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static Iterator getSystemPropertyNames() {
        Enumeration enumeration = (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties().propertyNames();
            }
        });
        return DataCollectorBase.makeIterator(enumeration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPropertiesFromFile(Properties props, String fileName) {
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                return;
            }
            FileInputStream in = new FileInputStream(file);
            try {
                props.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Properties getFileProperties() {
        Properties defaults = new Properties();
        String javaHome = DataCollectorBase.getSystemProperty("java.home");
        String fileName = javaHome + File.separator + "lib" + File.separator + "orb.properties";
        this.getPropertiesFromFile(defaults, fileName);
        Properties results = new Properties(defaults);
        String userHome = DataCollectorBase.getSystemProperty("user.home");
        fileName = userHome + File.separator + "orb.properties";
        this.getPropertiesFromFile(results, fileName);
        return results;
    }

    private boolean hasCORBAPrefix(String prefix) {
        return prefix.startsWith("org.omg.CORBA.") || prefix.startsWith("com.sun.corba.ee.");
    }

    private Set getCORBAPrefixes(Set prefixes) {
        HashSet<String> result = new HashSet<String>();
        for (String element : prefixes) {
            if (!this.hasCORBAPrefix(element)) continue;
            result.add(element);
        }
        return result;
    }
}

