/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.dottedname;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class ResourceStringSource {
    private final String mPackageName;
    private final String mPropertyFile;
    private final ResourceBundle mResourceBundle;
    public static String DEFAULT_STRING_VALUE = "Key not found";

    public ResourceStringSource(String packageName, String propertyFile) {
        this.mPackageName = packageName;
        this.mPropertyFile = propertyFile;
        this.mResourceBundle = ResourceBundle.getBundle(packageName + "." + propertyFile);
    }

    public String getPropertiesFile() {
        return this.mPropertyFile;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getString(String key) {
        return this.getString(key, DEFAULT_STRING_VALUE + " (" + key + ")");
    }

    public String getString(String key, String defaultValue) {
        String value = defaultValue;
        try {
            value = this.mResourceBundle.getString(key);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        return value;
    }

    public String getString(String key, Object[] toInsert) {
        String template;
        String result = template = this.getString(key);
        MessageFormat msgFormat = new MessageFormat(template);
        result = msgFormat.format(toInsert);
        return result;
    }
}

