/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans.jvm;

import com.sun.enterprise.admin.mbeans.jvm.StringBuilderNewLineAppender;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MBeanServerConnection;

class SummaryReporter {
    private final MBeanServerConnection mbsc;
    private final StringManager sm = StringManager.getManager(SummaryReporter.class);
    private static final String secretProperty = "module.core.status";

    public SummaryReporter(MBeanServerConnection mbsc) {
        this.mbsc = mbsc;
    }

    public String getSummaryReport() throws RuntimeException {
        try {
            StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
            OperatingSystemMXBean os = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
            sb.append(this.getOSInfo(os));
            RuntimeMXBean rt = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=Runtime", RuntimeMXBean.class);
            sb.append(this.getVMInfo(rt));
            return sb.toString(secretProperty);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getOSInfo(OperatingSystemMXBean os) {
        StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
        sb.append(this.sm.getString("os.info"));
        sb.append(this.sm.getString("os.name", os.getName()));
        sb.append(this.sm.getString("os.arch", os.getArch(), os.getVersion()));
        sb.append(this.sm.getString("os.nproc", os.getAvailableProcessors()));
        return sb.toString();
    }

    private String getVMInfo(RuntimeMXBean rt) {
        StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
        sb.append(this.sm.getString("rt.info", rt.getName()));
        sb.append(this.sm.getString("rt.bcp", rt.getBootClassPath()));
        sb.append(this.sm.getString("rt.cp", rt.getClassPath()));
        sb.append(this.sm.getString("rt.libpath", rt.getLibraryPath()));
        sb.append(this.sm.getString("rt.nvv", rt.getVmName(), rt.getVmVendor(), rt.getVmVersion()));
        sb.append(this.getProperties(rt));
        return sb.toString();
    }

    private String getProperties(RuntimeMXBean rt) {
        StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
        Map<String, String> unsorted = rt.getSystemProperties();
        TreeMap<String, String> props = new TreeMap<String, String>(unsorted);
        sb.append(this.sm.getString("rt.sysprops"));
        for (String n : props.keySet()) {
            sb.append(n + " = " + props.get(n));
        }
        return sb.toString();
    }
}

