/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.admin.selfmanagement.event.Event;
import com.sun.enterprise.admin.selfmanagement.event.TimerEventFactory;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.ObjectName;

public class TimerEvent
implements Event {
    private static StringManager sm = StringManager.getManager(TimerEvent.class);
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");
    private static ObjectName objName = null;
    private NotificationFilter filter = null;
    private String description = null;
    private static String defaultDescription = sm.getString("selfmgmt_event.timer_event_description");
    private int id;

    TimerEvent(Integer id, NotificationFilter filter, String description) {
        this.id = id;
        this.filter = filter;
        this.description = description != null ? description : defaultDescription;
    }

    public ObjectName getObjectName() {
        return TimerEvent.getTimerObjectName();
    }

    public String getType() {
        return "timer";
    }

    public NotificationFilter getNotificationFilter() {
        return this.filter;
    }

    public String getDescription() {
        return this.description;
    }

    public void destroy() {
        TimerEventFactory.getInstance().removeEvent(this.id);
    }

    static ObjectName getTimerObjectName() {
        if (objName != null) {
            return objName;
        }
        try {
            objName = new ObjectName("com.sun.appserver.selfmanagement", "eventname", "timer");
            return objName;
        }
        catch (MalformedObjectNameException ex) {
            _logger.log(Level.WARNING, "smgt.internal_error", ex);
            return null;
        }
    }
}

