/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws;

import com.sun.enterprise.appclient.jws.AppclientJWSSupportInfo;
import com.sun.enterprise.appclient.jws.NamingConventions;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.server.event.ApplicationClientEvent;
import com.sun.enterprise.server.event.ApplicationClientLoaderEventListener;
import com.sun.enterprise.server.event.ApplicationEvent;
import com.sun.enterprise.server.event.ApplicationLoaderEventListener;
import com.sun.enterprise.server.event.ApplicationLoaderEventNotifier;
import com.sun.enterprise.server.event.EjbContainerEvent;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppclientJWSSupportManager
implements ApplicationLoaderEventListener,
ApplicationClientLoaderEventListener {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system");
    private static AppclientJWSSupportManager instance;
    private AppclientJWSSupportInfo jwsInfo;
    private static final String JWS_FEATURE_ON_PROPERTY_NAME = "com.sun.aas.jws.featureon";
    private final boolean isJWSFeatureOn = Boolean.valueOf(System.getProperty("com.sun.aas.jws.featureon", "true"));

    public static AppclientJWSSupportManager getInstance() {
        if (instance == null) {
            instance = new AppclientJWSSupportManager();
            if (AppclientJWSSupportManager.instance.isJWSFeatureOn) {
                try {
                    AppclientJWSSupportManager.instance.jwsInfo = AppclientJWSSupportInfo.getInstance();
                }
                catch (IOException ioe) {
                    _logger.log(Level.SEVERE, "Error initializing Java Web Start support information", ioe);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return instance;
    }

    public void startJWSServicesForDeployedAppclients() {
        this.jwsInfo.startJWSServicesForDeployedAppclients();
    }

    private AppclientJWSSupportManager() {
        if (this.isJWSFeatureOn) {
            ApplicationLoaderEventNotifier.getInstance().addListener(this);
            ApplicationLoaderEventNotifier.getInstance().addListener(this);
        } else {
            _logger.info("Java Web Start support turned off by com.sun.aas.jws.featureon");
        }
    }

    public void handleApplicationEvent(ApplicationEvent event) {
        int eventType;
        block11: {
            block10: {
                eventType = event.getEventType();
                if (eventType == 0) break block10;
                if (eventType != 3) break block11;
            }
            return;
        }
        Application app = event.getApplication();
        ModuleDescriptor[] mds = NamingConventions.getEligibleAppclientModuleDescriptors(app);
        if (mds.length > 0) {
            try {
                if (eventType == 1) {
                    this.jwsInfo.startJWSServicesForApplication(app, mds);
                } else if (eventType == 2) {
                    this.jwsInfo.endJWSServicesForApplication(app, mds);
                }
            }
            catch (Throwable thr) {
                _logger.log(Level.SEVERE, "Error updating Java Web Start information for application " + app.getRegistrationName(), thr);
            }
        }
    }

    public void handleEjbContainerEvent(EjbContainerEvent ejbContainerEvent) {
    }

    public void handleApplicationClientEvent(ApplicationClientEvent event) {
        int eventType;
        block13: {
            block12: {
                eventType = event.getEventType();
                if (eventType == 0) break block12;
                if (eventType != 3) break block13;
            }
            return;
        }
        Application app = event.getApplication();
        ModuleDescriptor[] mds = NamingConventions.getEligibleAppclientModuleDescriptors(app);
        if (mds.length > 1) {
            _logger.warning("During app client loading, expected exactly one app client module in the wrapping application but found more; using the first one and ignoring the others");
        } else if (mds.length == 0) {
            _logger.warning("During app client loading, expected exactly one app client module in the wrapping application but found none; ignoring this app client and continuing");
            return;
        }
        try {
            if (eventType == 1) {
                this.jwsInfo.startJWSServicesForAppclient(app, mds[0]);
            } else if (eventType == 2) {
                this.jwsInfo.endJWSServicesForAppclient(app, mds[0]);
            }
        }
        catch (Throwable thr) {
            _logger.log(Level.SEVERE, "Error updating Java Web Start information for app client " + app.getRegistrationName(), thr);
        }
    }
}

