/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.util.i18n.StringManager;

public abstract class ReferenceHelperBase {
    protected static final StringManager _strMgr = StringManager.getManager(ReferenceHelperBase.class);

    protected abstract Server[] getReferencingServers(ConfigContext var1, String var2) throws ConfigException;

    protected abstract Cluster[] getReferencingClusters(ConfigContext var1, String var2) throws ConfigException;

    public boolean isReferenced(ConfigContext configContext, String name) throws ConfigException {
        Server[] servers = this.getReferencingServers(configContext, name);
        if (servers.length > 0) {
            return true;
        }
        Cluster[] clusters = this.getReferencingClusters(configContext, name);
        return clusters.length > 0;
    }

    public boolean isReferencedByServerOnly(ConfigContext configContext, String name, String serverName) throws ConfigException {
        Cluster[] clusters;
        Server[] servers = this.getReferencingServers(configContext, name);
        return servers.length == 1 && servers[0].getName().equals(serverName) && (clusters = this.getReferencingClusters(configContext, name)).length == 0;
    }

    public boolean isReferencedByClusterOnly(ConfigContext configContext, String name, String clusterName) throws ConfigException {
        Cluster[] clusters = this.getReferencingClusters(configContext, name);
        if (clusters.length == 1 && clusters[0].getName().equals(clusterName)) {
            Server[] servers = this.getReferencingServers(configContext, name);
            if (servers.length == 0) {
                return true;
            }
            Server[] clusterServers = ServerHelper.getServersInCluster(configContext, clusterName);
            if (clusterServers.length == servers.length) {
                boolean found = false;
                for (int i = 0; i < clusterServers.length; ++i) {
                    found = false;
                    for (int j = 0; j < servers.length; ++j) {
                        if (!clusterServers[i].getName().equals(servers[j].getName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                if (found) {
                    return true;
                }
            }
        }
        return false;
    }

    public String getReferenceesAsString(ConfigContext configContext, String name) throws ConfigException {
        Server[] servers = this.getReferencingServers(configContext, name);
        Cluster[] clusters = this.getReferencingClusters(configContext, name);
        String serverList = ServerHelper.getServersAsString(servers);
        String clusterList = ClusterHelper.getClustersAsString(clusters);
        if (serverList.length() > 0) {
            if (clusterList.length() > 0) {
                return serverList + "," + clusterList;
            }
            return serverList;
        }
        return clusterList;
    }
}

