/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;

public class ClientJarMakerRegistry {
    private static ClientJarMakerRegistry theRegistry;
    Map registeredThreads = new Hashtable();

    protected ClientJarMakerRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientJarMakerRegistry getInstance() {
        if (theRegistry != null) return theRegistry;
        Class<ClientJarMakerRegistry> clazz = ClientJarMakerRegistry.class;
        synchronized (ClientJarMakerRegistry.class) {
            if (theRegistry != null) return theRegistry;
            theRegistry = new ClientJarMakerRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return theRegistry;
        }
    }

    public void register(String moduleID, Thread clientJarMaker) {
        this.registeredThreads.put(moduleID, clientJarMaker);
    }

    public boolean isRegistered(String moduleID) {
        return this.registeredThreads.containsKey(moduleID);
    }

    public void unregister(String moduleID) {
        this.registeredThreads.remove(moduleID);
    }

    public void waitForCompletion(String moduleID) {
        Thread maker = (Thread)this.registeredThreads.get(moduleID);
        if (maker == null) {
            return;
        }
        try {
            maker.join();
        }
        catch (InterruptedException e) {
            StringManager localStrings = StringManager.getManager(ClientJarMakerRegistry.class);
            DeploymentLogger.get().log(Level.SEVERE, localStrings.getString("enterprise.deployment.error_creating_client_jar", e.getLocalizedMessage()), e);
        }
    }
}

