/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.runtime;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.runtime.BeanCacheDescriptor;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import com.sun.enterprise.deployment.runtime.CheckpointAtEndOfMethodDescriptor;
import com.sun.enterprise.deployment.runtime.FlushAtEndOfMethodDescriptor;
import com.sun.enterprise.deployment.runtime.MdbConnectionFactoryDescriptor;
import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class IASEjbExtraDescriptors
extends RuntimeDescriptor {
    public static final String AVAILABILITY_ENABLED = "AvailabilityEnabled";
    private boolean isReadOnlyBean = false;
    private int refreshPeriodInSeconds = -1;
    private int jmsMaxMessagesLoad = 1;
    private MdbConnectionFactoryDescriptor mdbConnectionFactory;
    private String commitOption = null;
    private BeanPoolDescriptor beanPool;
    private BeanCacheDescriptor beanCache;
    private FlushAtEndOfMethodDescriptor flushMethodDescriptor = null;
    private CheckpointAtEndOfMethodDescriptor checkpointMethodDescriptor = null;
    private String checkpointedMethods = null;
    private Boolean passByReference = null;
    private EjbDescriptor ejbDescriptor = null;
    private int cmtTimeoutInSeconds = 0;
    private String useThreadPoolId;
    private static final String METHODS_DELIM = ";";
    private static final String PARAMS_DELIM = ",";
    private static final String LEFT_PAREN = "(";
    private static final String RIGHT_PAREN = ")";
    private static final String PARAM_DELIM = " ";

    public BeanCacheDescriptor getBeanCache() {
        return this.beanCache;
    }

    public void setBeanCache(BeanCacheDescriptor beanCache) {
        this.beanCache = beanCache;
    }

    public BeanPoolDescriptor getBeanPool() {
        return this.beanPool;
    }

    public void setBeanPool(BeanPoolDescriptor beanPool) {
        this.beanPool = beanPool;
    }

    public FlushAtEndOfMethodDescriptor getFlushAtEndOfMethodDescriptor() {
        return this.flushMethodDescriptor;
    }

    public void setFlushAtEndOfMethodDescriptor(FlushAtEndOfMethodDescriptor flushMethodDescriptor) {
        this.flushMethodDescriptor = flushMethodDescriptor;
    }

    public CheckpointAtEndOfMethodDescriptor getCheckpointAtEndOfMethodDescriptor() {
        return this.checkpointMethodDescriptor;
    }

    public void setCheckpointAtEndOfMethodDescriptor(CheckpointAtEndOfMethodDescriptor checkpointMethodDescriptor) {
        this.checkpointMethodDescriptor = checkpointMethodDescriptor;
    }

    public String getCheckpointedMethods() {
        return this.checkpointedMethods;
    }

    public void setCheckpointedMethods(String checkpointedMethods) {
        this.checkpointedMethods = checkpointedMethods;
    }

    public String getCommitOption() {
        return this.commitOption;
    }

    public void setCommitOption(String commitOption) {
        this.commitOption = commitOption;
    }

    public int getCmtTimeoutInSeconds() {
        return this.cmtTimeoutInSeconds;
    }

    public void setCmtTimeoutInSeconds(int val) {
        this.cmtTimeoutInSeconds = val;
    }

    public String getUseThreadPoolId() {
        return this.useThreadPoolId;
    }

    public void setUseThreadPoolId(String val) {
        this.useThreadPoolId = val;
    }

    public boolean isIsReadOnlyBean() {
        return this.isReadOnlyBean;
    }

    public void setIsReadOnlyBean(boolean isReadOnlyBean) {
        this.isReadOnlyBean = isReadOnlyBean;
    }

    public int getJmsMaxMessagesLoad() {
        return this.jmsMaxMessagesLoad;
    }

    public void setJmsMaxMessagesLoad(int jmsMaxMessagesLoad) {
        this.jmsMaxMessagesLoad = jmsMaxMessagesLoad;
    }

    public MdbConnectionFactoryDescriptor getMdbConnectionFactory() {
        return this.mdbConnectionFactory;
    }

    public void setMdbConnectionFactory(MdbConnectionFactoryDescriptor mdbConnectionFactory) {
        this.mdbConnectionFactory = mdbConnectionFactory;
    }

    public int getRefreshPeriodInSeconds() {
        return this.refreshPeriodInSeconds;
    }

    public void setRefreshPeriodInSeconds(int refreshPeriodInSeconds) {
        this.refreshPeriodInSeconds = refreshPeriodInSeconds;
    }

    public boolean getPassByReference() {
        boolean passByReference = false;
        if (this.isPassByReferenceDefined()) {
            passByReference = this.passByReference;
        } else {
            Application application;
            this.ejbDescriptor = this.getEjbDescriptor();
            if (this.ejbDescriptor != null && (application = this.ejbDescriptor.getApplication()) != null && application.isPassByReferenceDefined()) {
                passByReference = application.getPassByReference();
            }
        }
        return passByReference;
    }

    public void setPassByReference(boolean passByReference) {
        this.passByReference = passByReference;
    }

    public void setPassByReference(Boolean passByReference) {
        this.passByReference = passByReference;
    }

    public boolean isPassByReferenceDefined() {
        boolean passByReferenceDefined = false;
        if (this.passByReference != null) {
            passByReferenceDefined = true;
        }
        return passByReferenceDefined;
    }

    public EjbDescriptor getEjbDescriptor() {
        return this.ejbDescriptor;
    }

    public void setEjbDescriptor(EjbDescriptor ejbDescriptor) {
        this.ejbDescriptor = ejbDescriptor;
    }

    public boolean isFlushEnabledFor(MethodDescriptor methodDesc) {
        if (this.flushMethodDescriptor != null) {
            return this.flushMethodDescriptor.isFlushEnabledFor(methodDesc);
        }
        return false;
    }

    public void parseCheckpointedMethods(EjbDescriptor ejbDesc) {
        if (this.checkpointedMethods == null || this.checkpointedMethods.trim().length() == 0) {
            return;
        }
        if (this.checkpointMethodDescriptor == null) {
            this.checkpointMethodDescriptor = new CheckpointAtEndOfMethodDescriptor();
            this.setCheckpointAtEndOfMethodDescriptor(this.checkpointMethodDescriptor);
            this.checkpointMethodDescriptor.setEjbDescriptor(ejbDesc);
        }
        StringTokenizer methodsTokenizer = new StringTokenizer(this.checkpointedMethods, METHODS_DELIM);
        while (methodsTokenizer.hasMoreTokens()) {
            MethodDescriptor methodDescriptor;
            String method = methodsTokenizer.nextToken().trim();
            if (method.length() == 0 || (methodDescriptor = this.parseCheckpointedMethod(method)) == null) continue;
            this.checkpointMethodDescriptor.getMethodDescriptors().add(methodDescriptor);
        }
    }

    private MethodDescriptor parseCheckpointedMethod(String method) {
        ArrayList<String> paramTypeList = new ArrayList<String>();
        try {
            if (method.indexOf(LEFT_PAREN) != -1 && method.indexOf(RIGHT_PAREN) != -1) {
                int pos = method.indexOf(LEFT_PAREN);
                int pos2 = method.indexOf(RIGHT_PAREN);
                String methodName = method.substring(0, pos).trim();
                if (pos < pos2 - 1) {
                    String methodParams = method.substring(pos + 1, pos2).trim();
                    StringTokenizer paramsTokenizer = new StringTokenizer(methodParams, PARAMS_DELIM);
                    block2: while (paramsTokenizer.hasMoreTokens()) {
                        String param = paramsTokenizer.nextToken().trim();
                        if (param.length() == 0) continue;
                        StringTokenizer paramTokenizer = new StringTokenizer(param, PARAM_DELIM);
                        while (paramTokenizer.hasMoreTokens()) {
                            String paramType = paramTokenizer.nextToken().trim();
                            if (paramType.length() == 0) continue;
                            paramTypeList.add(paramType);
                            continue block2;
                        }
                    }
                }
                if (paramTypeList.size() > 0) {
                    String[] paramTypeArray = paramTypeList.toArray(new String[paramTypeList.size()]);
                    return new MethodDescriptor(methodName, null, paramTypeArray, null);
                }
                return new MethodDescriptor(methodName, null, null, null);
            }
            DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment_badformat_checkpointedmethods", new Object[]{method});
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment_badformat_checkpointedmethods", new Object[]{method});
            return null;
        }
    }
}

