/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.Defaults;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.FileData;
import com.sun.enterprise.diagnostics.collect.WritableDataImpl;
import com.sun.enterprise.diagnostics.util.FileUtils;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomerInputCollector
implements Collector {
    String customerInputFile;
    String customerInput;
    String intermediateReportLocation;
    boolean local;
    protected static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public CustomerInputCollector(String customerInputFile, String customerInput, String intermediateReportLocation, boolean local) {
        this.intermediateReportLocation = intermediateReportLocation;
        this.customerInput = customerInput;
        this.customerInputFile = customerInputFile;
        this.local = local;
    }

    public Data capture() throws DiagnosticException {
        if (this.customerInputFile != null) {
            return this.copyCustomerInputFile(this.customerInputFile);
        }
        if (this.customerInput != null && this.customerInput.trim().length() > 0) {
            WritableDataImpl customerInfo = new WritableDataImpl("customer info");
            customerInfo.addValue(this.customerInput);
            return customerInfo;
        }
        return null;
    }

    private Data copyCustomerInputFile(String inputFile) {
        if (inputFile != null) {
            try {
                String destFile = this.intermediateReportLocation + Defaults.CUSTOMER_INPUT;
                FileUtils.copyFile(inputFile, destFile);
                return new FileData(destFile, "customer info");
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "diagnostic-service.copy_failed", new Object[]{inputFile, ioe.getMessage()});
            }
        }
        return null;
    }
}

