/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.monitoring.MonitoredObject;
import com.sun.corba.ee.spi.monitoring.MonitoringFactories;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.OrbConnectionManagerStats;
import com.sun.enterprise.admin.monitor.stats.ThreadPoolStats;
import com.sun.enterprise.iiop.OrbConnectionManagerStatsImpl;
import com.sun.enterprise.iiop.ThreadPoolStatsImpl;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;

public class ORBMonitoring {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private ORB orb;
    private MonitoringRegistry registry;

    public ORBMonitoring(ORB orb) {
        this.orb = orb;
        this.registry = ApplicationServer.getServerContext().getMonitoringRegistry();
        this.registerOrbStatistics();
    }

    public void registerOrbStatistics() {
        this.registerThreadPoolStats();
        this.registerORBConnectionStats();
    }

    private void registerThreadPoolStats() {
        Iterator threadPoolsIterator;
        MonitoredObject threadPoolRoot = MonitoringFactories.getMonitoringManagerFactory().createMonitoringManager("orb", null).getRootMonitoredObject();
        try {
            MonitoredObject rootThreadPoolNode = threadPoolRoot.getChild("threadpool");
            threadPoolsIterator = rootThreadPoolNode.getChildren().iterator();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Unexpected exception caught when accessing ThreadPool Stats:", ex);
            return;
        }
        while (threadPoolsIterator.hasNext()) {
            MonitoredObject threadPool = (MonitoredObject)threadPoolsIterator.next();
            try {
                ThreadPoolStatsImpl threadPoolStats = new ThreadPoolStatsImpl(threadPool);
                this.registry.registerThreadPoolStats((ThreadPoolStats)threadPoolStats, threadPoolRoot.getName() + "." + "threadpool" + "." + threadPool.getName(), null);
            }
            catch (MonitoringRegistrationException mex) {
                _logger.log(Level.WARNING, "Unable to register ThreadPoolStats due to following exception ", mex);
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "Unexpected exception caught when registring ThreadPoolStats", ex);
            }
        }
    }

    private void registerORBConnectionStats() {
        try {
            OrbConnectionManagerStatsImpl connectionManagerStats;
            com.sun.corba.ee.spi.orb.ORB internalORB = (com.sun.corba.ee.spi.orb.ORB)((Object)this.orb);
            MonitoredObject orbRoot = internalORB.getMonitoringManager().getRootMonitoredObject();
            MonitoredObject rootConnectionNode = orbRoot.getChild("Connections");
            MonitoredObject rootOutboundConnections = rootConnectionNode.getChild("Outbound");
            MonitoredObject rootInboundConnections = rootConnectionNode.getChild("Inbound");
            if (rootOutboundConnections != null) {
                for (MonitoredObject outboundConnection : rootOutboundConnections.getChildren()) {
                    try {
                        connectionManagerStats = new OrbConnectionManagerStatsImpl(outboundConnection);
                        this.registry.registerOrbConnectionManagerStats((OrbConnectionManagerStats)connectionManagerStats, orbRoot.getName() + "." + "Connections" + "." + "Outbound" + "." + outboundConnection.getName(), null);
                    }
                    catch (MonitoringRegistrationException mex) {
                        _logger.log(Level.WARNING, "Unable to register Outbound ORB Connections - ", mex);
                    }
                    catch (Exception ex) {
                        _logger.log(Level.WARNING, "Unexpected exception caught when registering Outbound ORB Connections", ex);
                    }
                }
            }
            if (rootInboundConnections != null) {
                for (MonitoredObject inboundConnection : rootInboundConnections.getChildren()) {
                    try {
                        connectionManagerStats = new OrbConnectionManagerStatsImpl(inboundConnection);
                        this.registry.registerOrbConnectionManagerStats((OrbConnectionManagerStats)connectionManagerStats, orbRoot.getName() + "." + "Connections" + "." + "Inbound" + "." + inboundConnection.getName(), null);
                    }
                    catch (MonitoringRegistrationException mex) {
                        _logger.log(Level.WARNING, "Unable to register Inbound ORB Connections - ", mex);
                    }
                    catch (Exception ex) {
                        _logger.log(Level.WARNING, "Unexpected exception caught when registering Inbound ORB Connections", ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Unexpected exception caught when accessing ORB Connection Stats:", ex);
            return;
        }
    }
}

