/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jms;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.connectors.ConnectorConstants;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.instance.ServerManager;
import com.sun.enterprise.jms.IASJmsUtil;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSSecurityException;

public class JmsProviderLifecycle
extends ServerLifecycleImpl {
    private ConfigContext ctx = null;
    private static JmsService jmsService_ = null;
    private JmsHost jmsHost_ = null;
    private static JMSAdmin jmsAdmin_ = null;
    private boolean onShutdown = false;
    private static boolean startedByMe_ = false;
    private boolean autoShutdown_ = true;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jms");
    private static boolean debug = true;
    private static final int NOTCHECKED = 1;
    private static final int SUCCESSFUL = 2;
    private static final int FAILED = 3;
    private static final int REMOTESTARTUP = 4;
    private static int startupStatus = 1;
    private static String instanceName = null;
    private static String iMQBin = null;
    private static String exception = null;
    private static String url = null;
    private static final String AS_INTEGRATION_VIA_MQ_SPI = "com.sun.enterprise.jms.ASMQSPIIntegration";
    private static boolean useMQRAForBrokerLifecycle = true;

    public void onInitialization(ServerContext sc) throws ServerLifecycleException {
        block20: {
            if (!JmsProviderLifecycle.shouldUseMQRAForLifecycleControl()) {
                if (jmsService_ != null) {
                    return;
                }
                try {
                    boolean running;
                    String mqInstanceDir;
                    File instanceDir;
                    jmsAdmin_ = null;
                    this.ctx = sc.getConfigContext();
                    JavaConfig jc = ServerBeansFactory.getJavaConfigBean(this.ctx);
                    String java_home = jc.getJavaHome();
                    jmsService_ = ServerBeansFactory.getJmsServiceBean(this.ctx);
                    String defaultJmsHost = jmsService_.getDefaultJmsHost();
                    this.jmsHost_ = defaultJmsHost == null || defaultJmsHost.equals("") ? ServerBeansFactory.getJmsHostBean(this.ctx) : jmsService_.getJmsHostByName(defaultJmsHost);
                    String type = jmsService_.getType();
                    if (!type.equals("LOCAL")) {
                        startupStatus = 4;
                        _logger.log(Level.INFO, "jms.broker_notlocal", type);
                        return;
                    }
                    if (this.jmsHost_ == null || !this.jmsHost_.isEnabled()) break block20;
                    String portStr = this.jmsHost_.getPort();
                    String username = this.jmsHost_.getAdminUserName();
                    String password = this.jmsHost_.getAdminPassword();
                    Vector<String> v = new Vector<String>();
                    if (java_home != null) {
                        v.add("-javahome");
                        v.add(java_home);
                    }
                    if (!(instanceDir = new File(mqInstanceDir = sc.getInstanceEnvironment().getInstancesRoot() + File.separator + "imq")).exists() || !instanceDir.isDirectory()) {
                        instanceDir.mkdirs();
                    }
                    v.add("-varhome");
                    v.add(mqInstanceDir);
                    String tmpstr = jmsService_.getStartArgs();
                    if (tmpstr != null) {
                        StringTokenizer st = new StringTokenizer(tmpstr, " ");
                        while (st.hasMoreTokens()) {
                            String t = st.nextToken();
                            v.add(t);
                        }
                    }
                    String[] startArgs = v.toArray(new String[0]);
                    ElementProperty[] jmsProperties = jmsService_.getElementProperty();
                    if (jmsProperties != null) {
                        for (int ii = 0; ii < jmsProperties.length; ++ii) {
                            ElementProperty p = jmsProperties[ii];
                            String name = p.getName();
                            if (!name.equals("auto-shutdown")) continue;
                            this.autoShutdown_ = Boolean.valueOf(p.getValue());
                        }
                    }
                    if ((iMQBin = System.getProperty("com.sun.aas.imqBin")) == null) {
                        String IMQ_INSTALL_SUBDIR = File.separator + ".." + File.separator + ".." + File.separator + "imq" + File.separator + "bin";
                        iMQBin = sc.getInstallRoot() + IMQ_INSTALL_SUBDIR;
                    }
                    String asInstance = sc.getInstanceName();
                    String domainName = ServerManager.instance().getDomainName();
                    instanceName = IASJmsUtil.getBrokerInstanceName(domainName, asInstance, jmsService_);
                    String localhost = "127.0.0.1";
                    url = localhost + (portStr == null ? "" : ":" + portStr);
                    jmsAdmin_ = username == null ? IASJmsUtil.getJMSAdminFactory().getJMSAdmin(url) : IASJmsUtil.getJMSAdminFactory().getJMSAdmin(url, username, password);
                    try {
                        jmsAdmin_.pingProvider();
                        running = true;
                    }
                    catch (Exception e) {
                        running = false;
                    }
                    if (running) {
                        _logger.fine("Broker is already running. Trying to attach.");
                        String s = null;
                        try {
                            s = this.attachToJmsProvider();
                        }
                        catch (Exception e) {
                            _logger.log(Level.INFO, "jms.broker_attach_failed");
                            _logger.log(Level.INFO, "jms.broker_log_location", instanceName);
                            throw new ServerLifecycleException(e.getMessage(), e);
                        }
                        if (s.equals(instanceName)) {
                            startedByMe_ = true;
                            _logger.log(Level.INFO, "jms.broker_found", instanceName);
                            break block20;
                        }
                        startedByMe_ = false;
                        Object[] params = new Object[]{s, portStr};
                        _logger.log(Level.SEVERE, "jms.broker_already_up", params);
                        throw new ServerLifecycleException("JmsProviderLifecycle error.");
                    }
                    _logger.fine("Starting JMS broker : imq-home=" + iMQBin + ", stargArgs=" + tmpstr + ", instanceName=" + instanceName);
                    try {
                        jmsAdmin_.startProvider(iMQBin, startArgs, instanceName);
                    }
                    catch (Exception e) {
                        _logger.log(Level.INFO, "jms.broker_exec_failed");
                        _logger.log(Level.INFO, "jms.broker_log_location", instanceName);
                        throw new ServerLifecycleException(e.getMessage(), e);
                    }
                }
                catch (Exception e) {
                    jmsService_ = null;
                    _logger.log(Level.SEVERE, "jms.broker_startup_failed");
                    throw new ServerLifecycleException(e.getMessage(), e);
                }
            }
        }
    }

    private String attachToJmsProvider() throws Exception {
        jmsAdmin_.connectToProvider();
        String name = jmsAdmin_.getProviderInstanceName();
        jmsAdmin_.disconnectFromProvider();
        return name;
    }

    private static void waitForJmsProvider(long initTimeout) throws Exception {
        boolean ready = false;
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                jmsAdmin_.pingProvider();
                ready = true;
            }
            catch (Exception e) {
                if (System.currentTimeMillis() - startTime >= initTimeout) break;
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e2) {}
                continue;
            }
            break;
        }
        if (!ready) {
            jmsAdmin_.pingProvider();
        }
    }

    public static JMSAdmin getJMSAdmin() {
        return jmsAdmin_;
    }

    public boolean isNOJMS() {
        return false;
    }

    public void onStartup(ServerContext sc) throws ServerLifecycleException {
        try {
            String module = ConnectorConstants.DEFAULT_JMS_ADAPTER;
            String loc = Switch.getSwitch().getResourceInstaller().getSystemModuleLocation(module);
            ConnectorRuntime.getRuntime().createActiveResourceAdapter(loc, module, false);
        }
        catch (ConnectorRuntimeException e) {
            e.printStackTrace();
            _logger.log(Level.INFO, "Failed to start JMS RA");
            throw new ServerLifecycleException("Failed to start JMS RA", e);
        }
    }

    public static void checkProviderStartup() throws ServerLifecycleException {
        if (JmsProviderLifecycle.shouldUseMQRAForLifecycleControl()) {
            return;
        }
        switch (startupStatus) {
            case 1: {
                break;
            }
            case 2: {
                return;
            }
            case 3: {
                throw new ServerLifecycleException("MQ startup failed :" + exception);
            }
            case 4: {
                return;
            }
        }
        String iMQInstance = System.getProperty("com.sun.aas.installRoot") + File.separator + "imq" + File.separator + "var" + File.separator + "instances";
        String initTimeoutStr = null;
        long initTimeout = 30000L;
        initTimeoutStr = jmsService_.getInitTimeoutInSeconds();
        if (initTimeoutStr != null) {
            initTimeout = Integer.parseInt(initTimeoutStr) * 1000;
        }
        Throwable excp = null;
        try {
            JmsProviderLifecycle.waitForJmsProvider(initTimeout);
            startupStatus = 2;
        }
        catch (JMSSecurityException e) {
            excp = e;
            startedByMe_ = true;
            try {
                jmsAdmin_ = IASJmsUtil.getJMSAdminFactory().getJMSAdmin(url, "admin", "admin");
            }
            catch (Exception ex) {}
        }
        catch (Exception e1) {
            excp = e1;
        }
        if (excp != null) {
            startupStatus = 3;
            _logger.log(Level.INFO, "jms.broker_ping_failed", Long.toString(initTimeout));
            _logger.log(Level.INFO, "jms.broker_instance_dir", iMQInstance);
            _logger.log(Level.INFO, "jms.broker_log_location", instanceName);
            exception = excp.getMessage();
            throw new ServerLifecycleException(excp.getMessage(), excp);
        }
        startedByMe_ = true;
        Object[] params = new Object[]{instanceName, iMQBin};
        _logger.log(Level.INFO, "jms.broker_started", params);
    }

    public void onShutdown() throws ServerLifecycleException {
        JmsProviderLifecycle.checkProviderStartup();
        this.onShutdown = true;
    }

    public void onTermination() throws ServerLifecycleException {
        this.onShutdown = true;
        if (!JmsProviderLifecycle.shouldUseMQRAForLifecycleControl()) {
            try {
                if (startupStatus == 4 || !this.autoShutdown_ || jmsService_ == null || !jmsService_.isEnabled()) {
                    return;
                }
                if (jmsAdmin_ == null || !startedByMe_) {
                    return;
                }
                _logger.log(Level.INFO, "jms.broker_shutting_down");
                jmsAdmin_.connectToProvider();
            }
            catch (Exception e) {
                throw new ServerLifecycleException(e.getMessage(), e);
            }
            try {
                jmsAdmin_.shutdownProvider();
                _logger.log(Level.INFO, "jms.broker_shutdown_complete");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean shouldUseMQRAForLifecycleControl() {
        return useMQRAForBrokerLifecycle;
    }

    static {
        try {
            String s = System.getProperty(AS_INTEGRATION_VIA_MQ_SPI);
            if (s != null) {
                useMQRAForBrokerLifecycle = new Boolean(s) == false;
            }
            String status = useMQRAForBrokerLifecycle ? "Using MQ RA for Broker lifecycle control" : "Using MQ SPI for Broker Lifecycle control";
            _logger.log(Level.INFO, status);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Exception while reading com.sun.enterprise.jms.ASMQSPIIntegrationproperty" + ex.getMessage());
            _logger.log(Level.INFO, "Using MQ RA for Broker Lifecycle control");
            _logger.log(Level.FINE, ex.getMessage());
        }
    }
}

