/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.model;

import com.sun.enterprise.management.agent.MEJBUtility;
import com.sun.enterprise.management.util.J2EEModuleUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.j2ee.Management;
import javax.management.j2ee.ManagementHome;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public abstract class J2EEManagedObjectMdl {
    private String name;
    private boolean stateManageable;
    private boolean statisticsProvider;
    private boolean eventProvider;
    private String serverName;

    J2EEManagedObjectMdl(String name, boolean state, boolean statistics, boolean events) {
        this.name = name;
        this.stateManageable = state;
        this.statisticsProvider = statistics;
        this.eventProvider = events;
    }

    J2EEManagedObjectMdl(String name, String serverName, boolean state, boolean statistics, boolean events) {
        this.name = name;
        this.stateManageable = state;
        this.statisticsProvider = statistics;
        this.eventProvider = events;
        this.serverName = serverName;
    }

    MBeanServer getMBeanServer() {
        ArrayList servers = (ArrayList)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MBeanServerFactory.findMBeanServer(null);
            }
        });
        if (servers.isEmpty()) {
            return (MBeanServer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return MBeanServerFactory.createMBeanServer();
                }
            });
        }
        return (MBeanServer)servers.get(0);
    }

    MEJBUtility getMEJBUtility() {
        return MEJBUtility.getMEJBUtility();
    }

    Management getMEJB() {
        Management mejb = null;
        try {
            InitialContext ic = new InitialContext();
            String ejbName = System.getProperty("mejb.name", "ejb/mgmt/MEJB");
            Object objref = ic.lookup(ejbName);
            ManagementHome home = (ManagementHome)PortableRemoteObject.narrow(objref, ManagementHome.class);
            mejb = home.create();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mejb;
    }

    public Set findNames(String keys) {
        return J2EEModuleUtil.findNames(keys);
    }

    public abstract String getj2eeType();

    public abstract String getobjectName();

    public boolean isstateManageable() {
        return this.stateManageable;
    }

    public boolean isstatisticsProvider() {
        return this.statisticsProvider;
    }

    public boolean iseventProvider() {
        return this.eventProvider;
    }

    public String getJ2EEServer() {
        if (this.serverName != null) {
            return this.serverName;
        }
        return "server1";
    }

    public String getname() {
        return this.name;
    }
}

