/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.Switch;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.resource.MonitorableResourcePool;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.transaction.Transaction;

public abstract class AbstractResourcePool
implements MonitorableResourcePool {
    protected static StringManager localStrings = StringManager.getManager(AbstractResourcePool.class);
    protected ArrayList resources;
    protected ArrayList free;
    protected long idletime;
    protected String name;
    protected ResourceSpec resourceSpec;
    protected ResourceAllocator allocator;
    protected int maxPoolSize;
    protected int steadyPoolSize;
    protected int resizeQuantity;
    protected int maxWaitTime;
    protected boolean failAllConnections = false;
    protected boolean matchConnections = false;
    protected boolean poolInitialized = false;
    protected Timer timer;
    protected TimerTask resizerTask;
    protected boolean monitoringEnabled;
    protected PoolCounters poolCounters = null;
    protected boolean validation = false;
    protected LinkedList waitQueue = new LinkedList();
    protected boolean lazyConnectionAssoc_;
    protected boolean lazyConnectionEnlist_;
    protected boolean associateWithThread_;
    protected boolean connectionLeakTracing_;
    private boolean selfManaged_;
    private boolean validateAtmostEveryIdleSecs = false;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    private boolean inTx() {
        ComponentInvocation inv = Switch.getSwitch().getInvocationManager().getCurrentInvocation();
        if (inv == null) {
            throw new InvocationException();
        }
        Transaction tran = inv.getTransaction();
        return tran != null;
    }

    public AbstractResourcePool(String poolName) throws PoolingException {
        this.name = poolName;
        this.setPoolConfiguration();
        this.monitoringEnabled = false;
        this.resources = new ArrayList(this.maxPoolSize);
        this.free = new ArrayList(this.maxPoolSize);
    }

    private void setPoolConfiguration() throws PoolingException {
        ConnectorConnectionPool poolResource;
        Context ic = Switch.getSwitch().getNamingManager().getInitialContext();
        try {
            String jndiNameOfPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(this.name);
            poolResource = (ConnectorConnectionPool)ic.lookup(jndiNameOfPool);
        }
        catch (NamingException ex) {
            throw new PoolingException(ex);
        }
        this.idletime = Integer.parseInt(poolResource.getIdleTimeoutInSeconds()) * 1000;
        this.maxPoolSize = Integer.parseInt(poolResource.getMaxPoolSize());
        this.steadyPoolSize = Integer.parseInt(poolResource.getSteadyPoolSize());
        if (this.maxPoolSize < this.steadyPoolSize) {
            this.maxPoolSize = this.steadyPoolSize;
        }
        this.resizeQuantity = Integer.parseInt(poolResource.getPoolResizeQuantity());
        this.maxWaitTime = Integer.parseInt(poolResource.getMaxWaitTimeInMillis());
        if (this.maxWaitTime < 0) {
            this.maxWaitTime = 0;
        }
        this.failAllConnections = poolResource.isFailAllConnections();
        this.matchConnections = poolResource.matchConnections();
        this.validation = poolResource.isIsConnectionValidationRequired();
        this.lazyConnectionAssoc_ = poolResource.isLazyConnectionAssoc();
        this.lazyConnectionEnlist_ = poolResource.isLazyConnectionEnlist();
        this.associateWithThread_ = poolResource.isAssociateWithThread();
        this.connectionLeakTracing_ = poolResource.isConnectionLeakTracing();
        this.validateAtmostEveryIdleSecs = poolResource.isValidateAtmostEveryIdleSecs();
    }

    protected synchronized void initPool(ResourceSpec resourceSpec, ResourceAllocator allocator) throws PoolingException {
        if (this.poolInitialized) {
            return;
        }
        this.resourceSpec = resourceSpec;
        this.allocator = allocator;
        this.createResources(this.steadyPoolSize);
        if (this.idletime > 0L) {
            this.scheduleResizerTask();
        }
        this.poolInitialized = true;
    }

    private void scheduleResizerTask() {
        if (this.resizerTask != null) {
            this.resizerTask.cancel();
            this.resizerTask = null;
        }
        this.resizerTask = new Resizer();
        if (this.timer == null) {
            this.timer = Switch.getSwitch().getTimer();
        }
        this.timer.scheduleAtFixedRate(this.resizerTask, this.idletime, this.idletime);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("schduled resizer task");
        }
    }

    public synchronized void addResource(ResourceSpec spec, ResourceHandle h) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resource added: " + spec + "," + h);
        }
        ResourceState state = new ResourceState();
        this.resources.add(h);
        h.setResourceState(state);
        state.setEnlisted(false);
        state.setBusy(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHandle getResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle result = null;
        long startTime = 0L;
        long elapsedWaitTime = 0L;
        long remainingWaitTime = 0L;
        Object waitMonitor = new Object();
        if (this.maxWaitTime > 0) {
            startTime = System.currentTimeMillis();
        }
        while (true) {
            if ((result = this.internalGetResource(spec, alloc, tran)) != null) {
                if (!this.monitoringEnabled) break;
                this.poolCounters.incrementNumConnAcquired();
                elapsedWaitTime = System.currentTimeMillis() - startTime;
                this.poolCounters.setWaitTime(elapsedWaitTime);
                break;
            }
            if (this.maxWaitTime > 0) {
                elapsedWaitTime = System.currentTimeMillis() - startTime;
                if (elapsedWaitTime < (long)this.maxWaitTime) {
                    remainingWaitTime = (long)this.maxWaitTime - elapsedWaitTime;
                } else {
                    if (this.monitoringEnabled) {
                        this.poolCounters.incrementNumConnTimedOut();
                    }
                    String msg = localStrings.getString("poolmgr.no.available.resource", "No available resource. Wait-time expired.");
                    throw new PoolingException(msg);
                }
            }
            Object object = waitMonitor;
            synchronized (object) {
                LinkedList linkedList = this.waitQueue;
                synchronized (linkedList) {
                    this.waitQueue.addLast(waitMonitor);
                }
                try {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Resource Pool: getting on wait queue");
                    }
                    waitMonitor.wait(remainingWaitTime);
                }
                catch (InterruptedException ex) {
                    break;
                }
                linkedList = this.waitQueue;
                synchronized (linkedList) {
                    this.waitQueue.remove(waitMonitor);
                }
            }
        }
        alloc.fillInResourceObjects(result);
        return result;
    }

    protected abstract ResourceHandle prefetch(ResourceSpec var1, ResourceAllocator var2, Transaction var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResourceHandle internalGetResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle result;
        block13: {
            if (!this.poolInitialized) {
                this.initPool(spec, alloc);
            }
            result = null;
            result = this.prefetch(spec, alloc, tran);
            if (result != null) {
                return result;
            }
            try {
                J2EETransaction j2eetran;
                Set set;
                if (tran == null || !alloc.shareableWithinComponent() || (set = (j2eetran = (J2EETransaction)tran).getResources(this.name)) == null) break block13;
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    ResourceHandle h = (ResourceHandle)iter.next();
                    if (h.hasConnectionErrorOccurred()) {
                        iter.remove();
                        continue;
                    }
                    ResourceState state = h.getResourceState();
                    if (!h.getResourceAllocator().shareableWithinComponent() || !state.isFree() && !spec.isXA()) continue;
                    if (this.matchConnections) {
                        if (!alloc.matchConnection(h)) {
                            if (!this.monitoringEnabled) continue;
                            this.poolCounters.incrementNumConnNotSuccessfullyMatched();
                            continue;
                        }
                        if (h.hasConnectionErrorOccurred()) {
                            if (this.failAllConnections) {
                                result = null;
                                break;
                            } else {
                                iter.remove();
                                continue;
                            }
                        }
                        if (this.monitoringEnabled) {
                            this.poolCounters.incrementNumConnSuccessfullyMatched();
                        }
                    }
                    state.setBusy(true);
                    result = h;
                    break;
                }
            }
            catch (ClassCastException e) {
                _logger.log(Level.FINE, "Pool: getResource : transaction is not J2EETransaction but a " + tran.getClass().getName(), e);
            }
        }
        if (result == null && (result = this.getUnenlistedResource(spec, alloc, tran)) != null && this.monitoringEnabled) {
            this.poolCounters.incrementNumConnUsed();
        }
        return result;
    }

    protected synchronized ResourceHandle getUnenlistedResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle result = null;
        Iterator iter = this.free.iterator();
        while (iter.hasNext()) {
            boolean matched = false;
            ResourceHandle h = (ResourceHandle)iter.next();
            if (h.hasConnectionErrorOccurred()) {
                iter.remove();
                continue;
            }
            if (h.isAssociated()) continue;
            boolean connectionValid = true;
            long timeSinceValidation = System.currentTimeMillis() - h.getLastValidated();
            if (this.validation || this.validateAtmostEveryIdleSecs && timeSinceValidation > this.idletime) {
                if (!alloc.isConnectionValid(h)) {
                    connectionValid = false;
                } else {
                    h.setLastValidated(System.currentTimeMillis());
                }
            }
            if (connectionValid) {
                if (this.matchConnections) {
                    matched = alloc.matchConnection(h);
                    if (this.monitoringEnabled) {
                        if (matched) {
                            this.poolCounters.incrementNumConnSuccessfullyMatched();
                        } else {
                            this.poolCounters.incrementNumConnNotSuccessfullyMatched();
                        }
                    }
                } else {
                    matched = true;
                }
            }
            if (h.hasConnectionErrorOccurred() || !connectionValid) {
                if (this.failAllConnections) {
                    result = this.createSingleResourceAndAdjustPool(alloc, spec);
                    break;
                }
                iter.remove();
                continue;
            }
            if (!matched) continue;
            result = h;
            break;
        }
        if (result != null) {
            ResourceState state = result.getResourceState();
            state.setBusy(true);
            this.free.remove(result);
        } else if (this.resources.size() < this.steadyPoolSize) {
            this.createResources(this.steadyPoolSize - this.resources.size());
            if (this.free.size() != 0) {
                result = (ResourceHandle)this.free.remove(0);
                ResourceState state = result.getResourceState();
                state.setBusy(true);
            }
        } else if (this.resources.size() < this.maxPoolSize) {
            result = alloc.createResource();
            this.addResource(spec, result);
            if (this.monitoringEnabled) {
                this.poolCounters.incrementNumConnCreated();
            }
        }
        return result;
    }

    protected ResourceHandle createSingleResourceAndAdjustPool(ResourceAllocator alloc, ResourceSpec spec) throws PoolingException {
        if (this.free.size() != 0) {
            ResourceHandle rHandle = (ResourceHandle)this.free.get(0);
            this.resources.remove(rHandle);
            this.free.remove(rHandle);
        }
        ResourceHandle result = alloc.createResource();
        this.addResource(spec, result);
        alloc.fillInResourceObjects(result);
        if (this.monitoringEnabled) {
            this.poolCounters.incrementNumConnCreated();
        }
        return result;
    }

    private synchronized void createResources(int size) throws PoolingException {
        for (int i = 0; i < size; ++i) {
            this.createResourceAndAddToPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyResource(ResourceHandle resourceHandle) {
        try {
            resourceHandle.getResourceAllocator().destroyResource(resourceHandle);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "poolmgr.destroy_resource_failed");
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "poolmgr.destroy_resource_failed", ex);
            }
        }
        finally {
            if (this.monitoringEnabled) {
                this.poolCounters.incrementNumConnDestroyed();
                if (resourceHandle.getResourceState().isBusy()) {
                    this.poolCounters.decrementNumConnUsed(true);
                } else {
                    this.poolCounters.decrementNumConnFree();
                }
            }
        }
    }

    public void resourceClosed(ResourceHandle h) throws IllegalStateException {
        ResourceState state;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resourceClosed: " + h);
        }
        if ((state = this.getResourceState(h)) == null || !state.isBusy()) {
            throw new IllegalStateException("state is null : " + (state == null) + " ::: state.isBusy() : " + state.isBusy());
        }
        state.setBusy(false);
        state.touchTimestamp();
        if (state.isUnenlisted()) {
            this.freeUnenlistedResource(h);
            if (this.monitoringEnabled) {
                this.poolCounters.decrementNumConnUsed(false);
            }
        }
        if (this.monitoringEnabled) {
            this.poolCounters.incrementNumConnReleased();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resourceFreed: " + h);
        }
    }

    protected synchronized void freeUnenlistedResource(ResourceHandle h) {
        this.free.add(h);
        this.notifyWaitingThreads();
    }

    public synchronized void resourceErrorOccurred(ResourceHandle h) throws IllegalStateException {
        ResourceState state;
        this.logFine("Pool: resourceErrorOccurred: " + h);
        if (this.failAllConnections) {
            this.doFailAllConnectionsProcessing();
            return;
        }
        if (this.monitoringEnabled) {
            this.poolCounters.incrementNumConnFailedValidation(1);
        }
        if ((state = this.getResourceState(h)) == null) {
            throw new IllegalStateException();
        }
        this.resources.remove(h);
        this.destroyResource(h);
    }

    private void doFailAllConnectionsProcessing() {
        this.logFine(" @@@@ doFailAllConnectionsProcessing entered");
        this.cancelResizerTask();
        if (this.monitoringEnabled) {
            this.poolCounters.incrementNumConnFailedValidation(this.resources.size());
        }
        this.emptyPool();
        try {
            this.createResources(this.steadyPoolSize);
        }
        catch (PoolingException pe) {
            this.logFine("in doFailAllConnectionsProcessing couldn't create steady resources");
        }
        this.scheduleResizerTask();
        this.logFine(" @@@@ doFailAllConnectionsProcessing done - created new resources");
    }

    public void resourceEnlisted(Transaction tran, ResourceHandle resource) throws IllegalStateException {
        try {
            J2EETransaction j2eetran = (J2EETransaction)tran;
            HashSet<ResourceHandle> set = j2eetran.getResources(this.name);
            if (set == null) {
                set = new HashSet<ResourceHandle>();
                j2eetran.setResources(set, this.name);
            }
            set.add(resource);
        }
        catch (ClassCastException e) {
            _logger.log(Level.FINE, "Pool: resourceEnlisted:transaction is not J2EETransaction but a " + tran.getClass().getName(), e);
        }
        ResourceState state = this.getResourceState(resource);
        state.setEnlisted(true);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resourceEnlisted: " + resource);
        }
    }

    public synchronized void transactionCompleted(Transaction tran, int status) throws IllegalStateException {
        try {
            J2EETransaction j2eetran = (J2EETransaction)tran;
            Set set = j2eetran.getResources(this.name);
            if (set == null) {
                return;
            }
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                ResourceHandle resource = (ResourceHandle)iter.next();
                ResourceState state = this.getResourceState(resource);
                state.setEnlisted(false);
                if (this.isResourceUnused(resource)) {
                    this.free.add(resource);
                    if (this.monitoringEnabled) {
                        this.poolCounters.decrementNumConnUsed(false);
                    }
                }
                iter.remove();
                this.notifyWaitingThreads();
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Pool: transactionCompleted: " + resource);
            }
        }
        catch (ClassCastException e) {
            _logger.log(Level.FINE, "Pool: transactionCompleted: transaction is not J2EETransaction but a " + tran.getClass().getName(), e);
        }
    }

    protected boolean isResourceUnused(ResourceHandle h) {
        return this.getResourceState(h).isFree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWaitingThreads() {
        Object waitMonitor = null;
        LinkedList linkedList = this.waitQueue;
        synchronized (linkedList) {
            if (this.waitQueue.size() > 0) {
                waitMonitor = this.waitQueue.removeFirst();
            }
        }
        if (waitMonitor != null) {
            linkedList = waitMonitor;
            synchronized (linkedList) {
                waitMonitor.notify();
            }
        }
    }

    public int getNumThreadWaiting() {
        return this.waitQueue.size();
    }

    public long getNumConnFailedValidation() {
        return this.poolCounters.numConnFailedValidation;
    }

    public long getNumConnTimedOut() {
        return this.poolCounters.numConnTimedOut;
    }

    public synchronized long getNumConnFree() {
        return this.poolCounters.currNumConnFree;
    }

    public long getMaxNumConnFree() {
        return this.poolCounters.maxNumConnFree;
    }

    public long getMinNumConnFree() {
        if (this.poolCounters.minNumConnFree != Long.MAX_VALUE) {
            return this.poolCounters.minNumConnFree;
        }
        return 0L;
    }

    public synchronized long getNumConnInUse() {
        return this.poolCounters.currNumConnUsed;
    }

    public long getMaxNumConnUsed() {
        return this.poolCounters.maxNumConnUsed;
    }

    public long getCurrentConnRequestWaitTime() {
        return this.poolCounters.currConnectionRequestWait;
    }

    public long getMaxConnRequestWaitTime() {
        return this.poolCounters.maxConnectionRequestWait;
    }

    public long getMinConnRequestWaitTime() {
        if (this.poolCounters.minConnectionRequestWait != Long.MAX_VALUE) {
            return this.poolCounters.minConnectionRequestWait;
        }
        return 0L;
    }

    public long getTotalConnectionRequestWaitTime() {
        return this.poolCounters.totalConnectionRequestWait;
    }

    public long getMinNumConnUsed() {
        if (this.poolCounters.minNumConnUsed != Long.MAX_VALUE) {
            return this.poolCounters.minNumConnUsed;
        }
        return 0L;
    }

    public long getNumConnCreated() {
        return this.poolCounters.numConnCreated;
    }

    public long getNumConnDestroyed() {
        return this.poolCounters.numConnDestroyed;
    }

    public long getNumConnAcquired() {
        return this.poolCounters.numConnAcquired;
    }

    public long getNumConnReleased() {
        return this.poolCounters.numConnReleased;
    }

    public long getNumConnSuccessfullyMatched() {
        return this.poolCounters.numConnSuccessfullyMatched;
    }

    public long getNumConnNotSuccessfullyMatched() {
        return this.poolCounters.numConnNotSuccessfullyMatched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resizePool(boolean forced) {
        int overSize;
        LinkedList linkedList = this.waitQueue;
        synchronized (linkedList) {
            if (this.waitQueue.size() > 0) {
                return;
            }
        }
        if (this.validation) {
            _logger.log(Level.FINE, "CP.Resizer.Validation-Turned-On");
            this.removeInvalidResources();
        }
        if ((overSize = this.resources.size() - this.steadyPoolSize) > 0) {
            int numResourcesToBeDestroyed = this.resizeQuantity < overSize ? this.resizeQuantity : overSize;
            Iterator iter = this.free.iterator();
            long currentTime = System.currentTimeMillis();
            while (numResourcesToBeDestroyed > 0 && iter.hasNext()) {
                ResourceHandle h = (ResourceHandle)iter.next();
                ResourceState state = this.getResourceState(h);
                if (!forced && currentTime - state.getTimestamp() <= this.idletime) continue;
                this.resources.remove(h);
                this.destroyResource(h);
                iter.remove();
                --numResourcesToBeDestroyed;
            }
        }
        if (this.resources.size() < this.steadyPoolSize) {
            for (int i = this.resources.size(); i < this.steadyPoolSize; ++i) {
                try {
                    this.createResourceAndAddToPool();
                    continue;
                }
                catch (PoolingException ex) {
                    _logger.log(Level.WARNING, "resource_pool.resize_pool_error", ex.getMessage() != null ? ex.getMessage() : " ");
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: Name = " + this.name);
            _logger.log(Level.FINE, "Pool: Resource held: " + this.resources.size());
        }
    }

    private void removeInvalidResources() {
        try {
            HashSet<Object> freeManagedConnections = new HashSet<Object>();
            for (ResourceHandle element : this.free) {
                freeManagedConnections.add(element.getResource());
            }
            _logger.log(Level.FINE, "Sending to RA a set of free connections of size", new Integer(freeManagedConnections.size()));
            Set invalidManagedConnections = this.allocator.getInvalidConnections(freeManagedConnections);
            if (invalidManagedConnections != null) {
                _logger.log(Level.FINE, "Received from RA invalid connections # ", new Integer(invalidManagedConnections.size()));
                for (ManagedConnection invalidManagedConnection : invalidManagedConnections) {
                    Iterator freeResourcesIter = this.free.iterator();
                    while (freeResourcesIter.hasNext()) {
                        ResourceHandle handle = (ResourceHandle)freeResourcesIter.next();
                        if (!invalidManagedConnection.equals(handle.getResource())) continue;
                        this.resources.remove(handle);
                        this.destroyResource(handle);
                        freeResourcesIter.remove();
                    }
                }
            } else {
                _logger.log(Level.FINE, "RA does not support ValidatingManagedConnectionFactory");
            }
        }
        catch (ResourceException re) {
            _logger.log(Level.FINE, "ResourceException while trying to get invalid connections from MCF", re);
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Exception while trying to get invalid connections from MCF", e);
        }
    }

    private ResourceState getResourceState(ResourceHandle h) {
        return h.getResourceState();
    }

    public synchronized void emptyPool() {
        this.logFine("EmptyPool: Name = " + this.name);
        for (ResourceHandle h : this.resources) {
            this.destroyResource(h);
        }
        this.free.clear();
        this.resources.clear();
    }

    public synchronized void emptyFreeConnectionsInPool() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Emptying free connections in pool : " + this.name);
        }
        for (ResourceHandle h : this.free) {
            this.resources.remove(h);
            this.destroyResource(h);
        }
        this.free.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Pool [");
        sb.append(this.name);
        sb.append("] PoolSize=");
        sb.append(this.resources.size());
        sb.append("  FreeResources=");
        sb.append(this.free.size());
        sb.append("  QueueSize=");
        sb.append(this.waitQueue.size());
        sb.append(" matching=");
        sb.append(this.matchConnections ? "on" : "off");
        sb.append(" validation=");
        sb.append(this.validation ? "on" : "off");
        return sb.toString();
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public void disableMonitoring() {
        this.monitoringEnabled = false;
    }

    public void setMonitoringEnabledHigh() {
        int numConnFree;
        this.logFine("Enabling monitoring to level : HIGH");
        int n = numConnFree = this.poolInitialized ? this.free.size() : this.steadyPoolSize;
        if (this.poolCounters == null) {
            this.poolCounters = new HighPoolCounters(numConnFree);
        }
        this.poolCounters.reset(numConnFree);
        this.monitoringEnabled = true;
    }

    public void setMonitoringEnabledLow() {
        this.logFine("Enabling monitoring to level : LOW");
        if (this.poolCounters == null) {
            this.poolCounters = new LowPoolCounters(0);
        }
        this.poolCounters.reset(0);
        this.monitoringEnabled = true;
    }

    public synchronized void reconfigPoolProperties(ConnectorConnectionPool poolResource) throws PoolingException {
        int _idleTime = Integer.parseInt(poolResource.getIdleTimeoutInSeconds()) * 1000;
        if ((long)_idleTime != this.idletime && _idleTime != 0) {
            this.scheduleResizerTask();
        }
        if (_idleTime == 0) {
            this.cancelResizerTask();
        }
        this.idletime = _idleTime;
        this.resizeQuantity = Integer.parseInt(poolResource.getPoolResizeQuantity());
        this.maxWaitTime = Integer.parseInt(poolResource.getMaxWaitTimeInMillis());
        if (this.maxWaitTime < 0) {
            this.maxWaitTime = 0;
        }
        this.validation = poolResource.isIsConnectionValidationRequired();
        this.failAllConnections = poolResource.isFailAllConnections();
        this.matchConnections = poolResource.matchConnections();
        this.lazyConnectionAssoc_ = poolResource.isLazyConnectionAssoc();
        this.lazyConnectionEnlist_ = poolResource.isLazyConnectionEnlist();
        this.associateWithThread_ = poolResource.isAssociateWithThread();
        this.connectionLeakTracing_ = poolResource.isConnectionLeakTracing();
        if (!this.isSelfManaged()) {
            int _maxPoolSize = Integer.parseInt(poolResource.getMaxPoolSize());
            if (_maxPoolSize < this.maxPoolSize) {
                int toKill = this.resources.size() - _maxPoolSize;
                this.killExtraResources(toKill);
            }
            this.maxPoolSize = _maxPoolSize < this.steadyPoolSize ? this.steadyPoolSize : _maxPoolSize;
            int _steadyPoolSize = Integer.parseInt(poolResource.getSteadyPoolSize());
            if (_steadyPoolSize > this.steadyPoolSize) {
                this.increaseSteadyPoolSize(_steadyPoolSize);
            }
            this.steadyPoolSize = _steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : _steadyPoolSize;
        }
    }

    private void killExtraResources(int numToKill) {
        this.cancelResizerTask();
        Iterator iter = this.free.iterator();
        for (int i = 0; iter.hasNext() && i < numToKill; ++i) {
            ResourceHandle h = (ResourceHandle)iter.next();
            ResourceState s = this.getResourceState(h);
            this.resources.remove(h);
            this.destroyResource(h);
            iter.remove();
        }
        this.scheduleResizerTask();
    }

    private void increaseSteadyPoolSize(int newSteadyPoolSize) throws PoolingException {
        this.cancelResizerTask();
        for (int i = this.resources.size(); i < newSteadyPoolSize; ++i) {
            this.createResourceAndAddToPool();
        }
        this.scheduleResizerTask();
    }

    private void createResourceAndAddToPool() throws PoolingException {
        ResourceHandle resourceHandle = this.allocator.createResource();
        this.addResource(this.resourceSpec, resourceHandle);
        this.getResourceState(resourceHandle).setBusy(false);
        this.free.add(resourceHandle);
        if (this.monitoringEnabled) {
            this.poolCounters.incrementNumConnCreated();
        }
    }

    public void switchOnMatching() {
        this.matchConnections = true;
    }

    public String getPoolName() {
        return this.name;
    }

    public synchronized void cancelResizerTask() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.finest("Cancelling resizer");
        }
        if (this.resizerTask != null) {
            this.resizerTask.cancel();
        }
        this.resizerTask = null;
        if (this.timer != null) {
            this.timer.purge();
        }
    }

    public synchronized void dumpPoolStatus() {
        _logger.log(Level.INFO, "Name of pool :" + this.name);
        _logger.log(Level.INFO, "Free connections :" + this.free.size());
        _logger.log(Level.INFO, "Total connections :" + this.resources.size());
        _logger.log(Level.INFO, "Pool's matching is :" + this.matchConnections);
        _logger.log(Level.INFO, "Free Table is :" + this.free);
        _logger.log(Level.INFO, "Resource Table is :" + this.resources);
    }

    public PoolCounters getPoolCounters() {
        return this.poolCounters;
    }

    private void logFine(String msg) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getSteadyPoolSize() {
        return this.steadyPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPoolSize(int size) {
        if (size < this.resources.size()) {
            AbstractResourcePool abstractResourcePool = this;
            synchronized (abstractResourcePool) {
                block7: {
                    int toKill = this.resources.size() - size;
                    if (toKill > 0) {
                        try {
                            this.killExtraResources(toKill);
                        }
                        catch (Exception re) {
                            if (!_logger.isLoggable(Level.FINE)) break block7;
                            _logger.fine("setMaxPoolSize:: killExtraResources throws exception: " + re.getMessage());
                        }
                    }
                }
            }
        }
        this.maxPoolSize = size;
    }

    public void setSteadyPoolSize(int size) {
        this.steadyPoolSize = size;
    }

    public void setSelfManaged(boolean selfManaged) {
        this.logFine("Setting selfManaged to : " + selfManaged + " in pool : " + this.name);
        this.selfManaged_ = selfManaged;
    }

    protected boolean isSelfManaged() {
        return this.selfManaged_;
    }

    class HighPoolCounters
    extends LowPoolCounters {
        HighPoolCounters(int freePoolSize) {
            super(freePoolSize);
        }

        public synchronized void setWaitTime(long elapsedWaitTime) {
            this.currConnectionRequestWait = elapsedWaitTime;
            if (elapsedWaitTime > this.maxConnectionRequestWait) {
                this.maxConnectionRequestWait = elapsedWaitTime;
            }
            if (elapsedWaitTime < this.minConnectionRequestWait) {
                this.minConnectionRequestWait = elapsedWaitTime;
            }
            this.totalConnectionRequestWait += elapsedWaitTime;
        }

        protected void incrementNumConnAcquired() {
            ++this.numConnAcquired;
        }

        protected void incrementNumConnTimedOut() {
            ++this.numConnTimedOut;
        }

        protected void incrementNumConnReleased() {
            ++this.numConnReleased;
        }

        protected void incrementNumConnFailedValidation(int incr) {
            this.numConnFailedValidation += (long)incr;
        }

        protected void incrementNumConnSuccessfullyMatched() {
            ++this.numConnSuccessfullyMatched;
        }

        protected void incrementNumConnNotSuccessfullyMatched() {
            ++this.numConnNotSuccessfullyMatched;
        }
    }

    class LowPoolCounters
    extends PoolCounters {
        LowPoolCounters(int freePoolSize) {
            super(freePoolSize);
        }

        protected void incrementNumConnCreated() {
            ++this.numConnCreated;
        }

        protected void incrementNumConnDestroyed() {
            ++this.numConnDestroyed;
        }

        protected synchronized void incrementNumConnUsed() {
            this.setNumConnUsed(++this.currNumConnUsed);
            this.setNumConnFree(--this.currNumConnFree);
        }

        protected synchronized void decrementNumConnUsed(boolean isConnectionDestroyed) {
            this.setNumConnUsed(--this.currNumConnUsed);
            if (isConnectionDestroyed) {
                if (AbstractResourcePool.this.poolCounters.currNumConnFree + AbstractResourcePool.this.poolCounters.currNumConnUsed < (long)AbstractResourcePool.this.steadyPoolSize) {
                    this.setNumConnFree(++this.currNumConnFree);
                }
            } else {
                this.setNumConnFree(++this.currNumConnFree);
            }
        }

        protected synchronized void decrementNumConnFree() {
            if (AbstractResourcePool.this.poolCounters.currNumConnFree + AbstractResourcePool.this.poolCounters.currNumConnUsed > (long)AbstractResourcePool.this.steadyPoolSize) {
                this.setNumConnFree(--this.currNumConnFree);
            }
        }

        protected void setNumConnUsed(long numConnInUse) {
            if (numConnInUse > this.maxNumConnUsed) {
                this.maxNumConnUsed = numConnInUse;
            }
            if (numConnInUse < this.minNumConnUsed) {
                this.minNumConnUsed = numConnInUse <= 0L ? 0L : numConnInUse;
            }
            this.currNumConnUsed = numConnInUse;
        }

        protected void setNumConnFree(long numConnFree) {
            if (numConnFree > this.maxNumConnFree) {
                this.maxNumConnFree = numConnFree;
            }
            if (numConnFree < this.minNumConnFree) {
                this.minNumConnFree = numConnFree <= 0L ? 0L : numConnFree;
            }
            this.currNumConnFree = numConnFree >= 0L ? numConnFree : 0L;
        }
    }

    class PoolCounters {
        long numConnFailedValidation = 0L;
        long numConnTimedOut = 0L;
        long numConnAcquired = 0L;
        long numConnReleased = 0L;
        long maxNumConnUsed = 0L;
        long minNumConnUsed = Long.MAX_VALUE;
        long currNumConnUsed = 0L;
        long currConnectionRequestWait = 0L;
        long maxConnectionRequestWait = 0L;
        long minConnectionRequestWait = Long.MAX_VALUE;
        long totalConnectionRequestWait = 0L;
        long maxNumConnFree = 0L;
        long minNumConnFree = Long.MAX_VALUE;
        long currNumConnFree = 0L;
        long numConnCreated = 0L;
        long numConnDestroyed = 0L;
        long numConnSuccessfullyMatched = 0L;
        long numConnNotSuccessfullyMatched = 0L;

        PoolCounters(int freePoolSize) {
            this.currNumConnFree = freePoolSize;
        }

        protected void reset(int freePoolSize) {
            this.maxNumConnUsed = 0L;
            this.minNumConnUsed = Long.MAX_VALUE;
            this.currNumConnUsed = 0L;
            this.numConnFailedValidation = 0L;
            this.numConnTimedOut = 0L;
            this.maxConnectionRequestWait = 0L;
            this.minConnectionRequestWait = Long.MAX_VALUE;
            this.totalConnectionRequestWait = 0L;
            this.maxNumConnFree = 0L;
            this.minNumConnFree = Long.MAX_VALUE;
            this.currNumConnFree = freePoolSize;
            this.numConnCreated = 0L;
            this.numConnDestroyed = 0L;
            this.numConnSuccessfullyMatched = 0L;
            this.numConnNotSuccessfullyMatched = 0L;
        }

        protected synchronized void setWaitTime(long elapsedWaitTime) {
        }

        protected synchronized void incrementNumConnUsed() {
        }

        protected synchronized void decrementNumConnUsed(boolean isConnectionDestroyed) {
        }

        protected synchronized void decrementNumConnFree() {
        }

        protected void setNumConnUsed(long numConnInUse) {
        }

        protected void setNumConnFree(long numConnFree) {
        }

        protected void incrementNumConnCreated() {
        }

        protected void incrementNumConnDestroyed() {
        }

        protected void incrementNumConnMatched() {
        }

        protected void incrementNumConnNotMatched() {
        }

        protected void incrementNumConnAcquired() {
        }

        protected void incrementNumConnTimedOut() {
        }

        protected void incrementNumConnReleased() {
        }

        protected void incrementNumConnFailedValidation(int incr) {
        }

        protected void incrementNumConnSuccessfullyMatched() {
        }

        protected void incrementNumConnNotSuccessfullyMatched() {
        }

        public String toString() {
            String str = "PoolCounters: ";
            str = str + "\n numConnFailedValidation = " + this.numConnFailedValidation;
            str = str + "\n numConnTimedOut = " + this.numConnTimedOut;
            str = str + "\n numConnAcquired = " + this.numConnAcquired;
            str = str + "\n numConnReleased = " + this.numConnReleased;
            str = str + "\n maxNumConnUsed = " + this.maxNumConnUsed;
            str = str + "\n minNumConnUsed = " + this.minNumConnUsed;
            str = str + "\n currNumConnUsed = " + this.currNumConnUsed;
            str = str + "\n maxConnectionRequestWait = " + this.maxConnectionRequestWait;
            str = str + "\n minConnectionRequestWait = " + this.minConnectionRequestWait;
            str = str + "\n maxNumConnFree =  = " + this.maxNumConnFree;
            str = str + "\n minNumConnFree = " + this.minNumConnFree;
            str = str + "\n currNumConnFree = " + this.currNumConnFree;
            str = str + "\n numConnCreated = " + this.numConnCreated;
            str = str + "\n numConnDestroyed = " + this.numConnDestroyed;
            str = str + "\n numConnSuccessfullyMatched = " + this.numConnSuccessfullyMatched;
            str = str + "\n numConnNotSuccessfullyMatched = " + this.numConnNotSuccessfullyMatched;
            return str;
        }
    }

    class Resizer
    extends TimerTask {
        Resizer() {
        }

        public void run() {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "AbstractResourcePool: resize pool " + AbstractResourcePool.this.name);
            }
            AbstractResourcePool.this.resizePool(false);
        }
    }
}

