/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.repository.IASJ2EEResourceFactoryImpl;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExternalJndiResourceDeployer
implements ResourceDeployer {
    private static final StringManager localStrings = StringManager.getManager("com.sun.enterprise.resource");
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public synchronized void deployResource(Object resource) throws Exception {
        ExternalJndiResource jndiRes = (ExternalJndiResource)resource;
        if (jndiRes.isEnabled()) {
            J2EEResource j2eeRes = IASJ2EEResourceFactoryImpl.toExternalJndiJ2EEResource(jndiRes);
            ResourceInstaller installer = Switch.getSwitch().getResourceInstaller();
            installer.installExternalJndiResource((com.sun.enterprise.repository.ExternalJndiResource)j2eeRes);
            installer.addResource(j2eeRes);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{jndiRes.getJndiName(), "external-jndi-resource"});
        }
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        ExternalJndiResource jndiRes = (ExternalJndiResource)resource;
        J2EEResource j2eeResource = IASJ2EEResourceFactoryImpl.toExternalJndiJ2EEResource(jndiRes);
        ResourceInstaller installer = Switch.getSwitch().getResourceInstaller();
        installer.uninstallExternalJndiResource(j2eeResource);
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public Object getResource(String name, Resources rbeans) throws Exception {
        ExternalJndiResource res = rbeans.getExternalJndiResourceByJndiName(name);
        if (res == null) {
            String msg = localStrings.getString("resource.no_resource", name);
            throw new Exception(msg);
        }
        return res;
    }
}

