/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ManagementObjectManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.JdbcConnectionPoolDeployer;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.server.ResourcesUtil;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;

public class JdbcResourceDeployer
implements ResourceDeployer {
    private static final StringManager localStrings = StringManager.getManager("com.sun.enterprise.resource");
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static final String PM_JNDI_EXTENSION = "__pm";

    public synchronized void deployResource(Object resource) throws Exception {
        JdbcResource jdbcRes = (JdbcResource)resource;
        if (jdbcRes.isEnabled()) {
            String jndiName = jdbcRes.getJndiName();
            String poolName = jdbcRes.getPoolName();
            this.loadPool(jdbcRes);
            ManagementObjectManager mgr = Switch.getSwitch().getManagementObjectManager();
            mgr.registerJDBCResource(jndiName);
            ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
            runtime.createConnectorResource(jndiName, poolName, null);
            runtime.createConnectorResource(this.getPMJndiName(jndiName), poolName, null);
            _logger.finest("deployed resource " + jndiName);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{jdbcRes.getJndiName(), "jdbc-resource"});
        }
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        JdbcResource jdbcRes = (JdbcResource)resource;
        String jndiName = jdbcRes.getJndiName();
        String pmJndiName = this.getPMJndiName(jdbcRes.getJndiName());
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        runtime.deleteConnectorResource(jndiName);
        runtime.deleteConnectorResource(pmJndiName);
        ManagementObjectManager mgr = Switch.getSwitch().getManagementObjectManager();
        mgr.unregisterJDBCResource(jndiName);
        this.checkAndDeletePool(jdbcRes);
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public Object getResource(String name, Resources rbeans) throws Exception {
        JdbcResource res = rbeans.getJdbcResourceByJndiName(name);
        if (res == null) {
            String msg = localStrings.getString("resource.no_resource", name);
            throw new Exception(msg);
        }
        return res;
    }

    private String getPMJndiName(String jndiName) {
        return jndiName + PM_JNDI_EXTENSION;
    }

    private void loadPool(JdbcResource jr) throws Exception {
        String poolName = jr.getPoolName();
        Resources resources = (Resources)jr.parent();
        JdbcConnectionPool cb = resources.getJdbcConnectionPoolByName(poolName);
        if (cb != null) {
            try {
                InitialContext ic = new InitialContext();
                ic.lookup(ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName));
            }
            catch (Exception e) {
                JdbcConnectionPoolDeployer deployer = new JdbcConnectionPoolDeployer();
                deployer.actualDeployResource(cb);
            }
        }
    }

    private void checkAndDeletePool(JdbcResource cr) throws Exception {
        String poolName = cr.getPoolName();
        Resources res = (Resources)cr.parent();
        try {
            boolean poolReferred = ResourcesUtil.getInstance().isJdbcPoolReferredInServerInstance(poolName);
            if (!poolReferred) {
                _logger.fine("Deleting JDBC pool " + poolName + "as there is no more " + "resource-refs to the pool in this server instance");
                JdbcConnectionPool jcp = res.getJdbcConnectionPoolByName(poolName);
                JdbcConnectionPoolDeployer deployer = new JdbcConnectionPoolDeployer();
                deployer.actualUndeployResource(jcp);
            }
        }
        catch (ConfigException ce) {
            _logger.warning(ce.getMessage());
            _logger.fine("Exception while deleting pool : " + ce);
            throw ce;
        }
    }
}

