/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.admin.server.core.channel.ReconfigHelper;
import com.sun.enterprise.server.AbstractMonitor;
import com.sun.enterprise.server.MonitorListener;
import com.sun.enterprise.server.MonitorableEntry;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class ReloadMonitor
extends AbstractMonitor {
    static final String RELOAD_FILE = ".reload";
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static ReloadMonitor _instance = null;

    private ReloadMonitor(long pollInterval) {
        super(pollInterval);
    }

    static ReloadMonitor getInstance(long pollInterval) {
        if (_instance == null) {
            _instance = new ReloadMonitor(pollInterval);
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeMonitoredEntry(String id) {
        boolean removed = false;
        if (id == null) {
            return removed;
        }
        HashSet hashSet = this._monitoredEntries;
        synchronized (hashSet) {
            for (MonitorableEntry entry : this._monitoredEntries) {
                if (!id.equals(entry.getId())) continue;
                this._monitoredEntries.remove(entry);
                removed = true;
                break;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ArrayList<MonitorableEntry> reloadList = new ArrayList<MonitorableEntry>();
            HashSet hashSet = this._monitoredEntries;
            synchronized (hashSet) {
                Iterator iter = this._monitoredEntries.iterator();
                MonitorableEntry entry = null;
                while (iter.hasNext()) {
                    long lastReloadedAt;
                    entry = (MonitorableEntry)iter.next();
                    File file = entry.getMonitoredFile();
                    long lastModified = file.lastModified();
                    if (lastModified <= (lastReloadedAt = entry.getLastReloadedTimeStamp())) continue;
                    entry.setLastReloadedTimeStamp(lastModified);
                    reloadList.add(entry);
                }
            }
            if (reloadList.size() > 0) {
                _logger.log(Level.FINEST, "[ReloadMonitor] Monitor detected reloadable entry!");
                int size = reloadList.size();
                MonitorableEntry entry = null;
                for (int i = 0; i < size; ++i) {
                    entry = (MonitorableEntry)reloadList.get(i);
                    MonitorListener l = entry.getListener();
                    boolean success = l.reload(entry);
                    if (success) {
                        _logger.log(Level.INFO, "core.application_reload_successful", entry.getDisplayName());
                        continue;
                    }
                    _logger.log(Level.INFO, "core.application_reload_failed", entry.getDisplayName());
                }
                ReconfigHelper.sendReconfigMessage("");
                reloadList.clear();
            }
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "core.exception", t);
        }
    }
}

