/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.server.logging.LoggingImplHook;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.management.MBeanServer;
import javax.management.ObjectName;

final class AMXLoggingHook {
    private ObjectName mLoggingObjectName;
    private MBeanServer mMBeanServer;
    private boolean mLoggingAvailable;
    private LoggingImplHook mLoggingImplHook;
    private Level mMinimumLogLevel;
    private static final boolean DEBUG = false;
    private final Output mOut;
    private final String mServerName = System.getProperty("com.sun.aas.instanceName");
    private static final String LOGGING_IMPL_CLASSNAME = "com.sun.enterprise.management.ext.logging.LoggingImpl";

    private void dumpSystemProps(Output output) {
        Properties props = System.getProperties();
        Object[] keys = props.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object key : keys) {
            this.debug((String)key + "=" + props.getProperty((String)key));
        }
    }

    AMXLoggingHook() {
        String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
        this.mOut = AMXLoggingHook.createOutput(false, instanceRoot + "/AMXLoggingHook-" + this.mServerName + ".debug");
        this.mLoggingObjectName = null;
        this.mMBeanServer = this.getMBeanServer();
        this.mMinimumLogLevel = Level.FINEST;
        this.mLoggingImplHook = null;
    }

    private static Output createOutput(boolean debug, String fileName) {
        try {
            File f = new File(fileName);
            return debug ? new FileOutput(f) : new NullOutput();
        }
        catch (Throwable throwable) {
            return new NullOutput();
        }
    }

    private final void debug(Object o) {
        this.mOut.println(o.toString());
    }

    private MBeanServer getMBeanServer() {
        if (this.mMBeanServer == null) {
            this.mMBeanServer = MBeanServerFactory.getMBeanServer();
            if (this.mMBeanServer != null) {
                this.debug("MBeanServer NOW EXISTS, creating LoggingImpl");
                this.initLogging(this.mMBeanServer);
            }
        }
        return this.mMBeanServer;
    }

    private void initLogging(MBeanServer mbeanServer) {
        try {
            Class<?> loggingClass = Class.forName(LOGGING_IMPL_CLASSNAME);
            Constructor<?> constructor = loggingClass.getConstructor(String.class);
            this.mLoggingImplHook = (LoggingImplHook)constructor.newInstance(this.mServerName);
            Method getObjectNameMethod = loggingClass.getMethod("getObjectName", String.class);
            this.mLoggingObjectName = (ObjectName)getObjectNameMethod.invoke((Object)this.mLoggingImplHook, this.mServerName);
            this.debug("registering Logging as: " + this.mLoggingObjectName);
            mbeanServer.registerMBean(this.mLoggingImplHook, this.mLoggingObjectName);
        }
        catch (Exception e) {
            String msg = "Can't load com.sun.enterprise.management.ext.logging.LoggingImpl, caught: " + e;
            this.debug(msg);
            throw new Error(msg);
        }
    }

    public Level getMinimumLogLevel() {
        return this.mMinimumLogLevel;
    }

    public void setMinimumLogLevel(Level level) {
        this.mMinimumLogLevel = level;
    }

    void publish(LogRecord record, Formatter theFormatter) {
        if (record.getLevel().intValue() < this.mMinimumLogLevel.intValue()) {
            return;
        }
        this.debug("publish: " + theFormatter.format(record));
        MBeanServer server = this.getMBeanServer();
        if (server != null) {
            if (!this.mLoggingAvailable) {
                this.mLoggingAvailable = server.isRegistered(this.mLoggingObjectName);
                if (this.mLoggingAvailable) {
                    this.debug("Logging MBean is now available: " + this.mLoggingObjectName);
                }
            }
            if (this.mLoggingAvailable) {
                try {
                    this.mLoggingImplHook.privateLoggingHook(record, theFormatter);
                }
                catch (Throwable t) {
                    this.debug("AMXLoggingHook.publish: Exception calling privateLoggingHook: " + t);
                }
            } else {
                this.debug("publish: no Logging yet.");
            }
        } else {
            this.debug("publish: no MBeanServer yet.");
        }
    }

    private static final class NullOutput
    implements Output {
        NullOutput() {
        }

        public void println(Object o) {
        }
    }

    private static final class FileOutput
    implements Output {
        private PrintStream mOut;

        public FileOutput(File f) throws IOException {
            this.mOut = new PrintStream(new FileOutputStream(f));
        }

        public void println(Object o) {
            this.mOut.println(o.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.mOut != null) {
                try {
                    this.mOut.close();
                }
                finally {
                    this.mOut = null;
                }
            }
        }
    }

    private static interface Output {
        public void println(Object var1);
    }
}

