/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ondemand;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ondemand.OnDemandServer;
import com.sun.enterprise.server.ondemand.OnDemandServices;
import com.sun.enterprise.server.ondemand.ServiceGroup;
import com.sun.enterprise.server.ondemand.ServiceGroupException;
import com.sun.enterprise.server.ondemand.SystemAppLoader;
import com.sun.enterprise.server.ondemand.entry.EntryContext;
import java.util.logging.Level;

public class ResourcesServiceGroup
extends ServiceGroup {
    public void start(EntryContext context) throws ServiceGroupException {
        try {
            this.startLifecycleServices(context.getServerContext());
        }
        catch (Exception e) {
            throw new ServiceGroupException(e);
        }
    }

    public boolean analyseEntryContext(EntryContext context) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "Analysing the context in Resources ServiceGroup :" + context);
        }
        if (context.get() == null) {
            return false;
        }
        boolean result = false;
        try {
            String portStr;
            ConfigContext ctxt = context.getServerContext().getConfigContext();
            Config conf = ServerBeansFactory.getConfigBean(ctxt);
            JmsService jmsService_ = conf.getJmsService();
            String defaultJmsHost = jmsService_.getDefaultJmsHost();
            JmsHost jmsHost_ = null;
            boolean embedded = true;
            jmsHost_ = defaultJmsHost == null || defaultJmsHost.equals("") ? ServerBeansFactory.getJmsHostBean(ctxt) : jmsService_.getJmsHostByName(defaultJmsHost);
            if (jmsHost_ == null || jmsService_.getType() == null || !jmsService_.getType().equalsIgnoreCase("embedded")) {
                embedded = false;
            }
            if (context.getEntryPointType() == 3) {
                // empty if block
            }
            if (context.getEntryPointType() == 5) {
                boolean onDemandStartup = (Boolean)context.get();
                if (onDemandStartup && !embedded) {
                    result = true;
                }
            } else if (!embedded) {
                return false;
            }
            if (context.getEntryPointType() == 2) {
                ConnectorDescriptor cd;
                Application app;
                String mqRA = ConnectorRuntime.DEFAULT_JMS_ADAPTER;
                Descriptor desc = (Descriptor)context.get();
                if (desc instanceof Application) {
                    Application application = (Application)desc;
                    for (ConnectorDescriptor cd2 : application.getRarDescriptors()) {
                        Application app2 = cd2.getApplication();
                        if (app2 == null || !mqRA.equals(app2.getRegistrationName())) continue;
                        result = true;
                    }
                } else if (desc instanceof ConnectorDescriptor && (app = (cd = (ConnectorDescriptor)desc).getApplication()) != null && mqRA.equals(app.getRegistrationName())) {
                    result = true;
                }
            }
            if (context.getEntryPointType() == 1 && Integer.parseInt((portStr = jmsHost_.getPort()).trim()) == (Integer)context.get()) {
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    private void loadSystemApps() {
        SystemAppLoader loader = OnDemandServer.getSystemAppLoader();
        loader.loadSystemApps(loader.getResourcesServiceGroupSystemApps());
    }

    private void startLifecycleServices(ServerContext context) {
        String[][] services = OnDemandServices.getResourcesServiceGroupServices();
        super.startLifecycleServices(services, context);
    }

    public void stop(EntryContext context) throws ServiceGroupException {
        super.stopLifecycleServices();
    }

    public void abort(EntryContext context) {
        super.stopLifecycleServices();
    }
}

