/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;

public class WebURI
extends ApplicationTest
implements AppCheck {
    public Result check(Application descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getWebBundleDescriptors().size() > 0) {
            boolean oneFailed = false;
            for (WebBundleDescriptor wbd : descriptor.getWebBundleDescriptors()) {
                if (wbd.getModuleDescriptor().getArchiveUri().endsWith(".war")) {
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] specifies the URI [ {1} ] of web application file, relative to the top level of the application package [ {2} ].", new Object[]{wbd.getName(), wbd.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not specify the URI [ {1} ] of web application file, relative to the top level of the application package [ {2} ]or does not end with \".war\"", new Object[]{wbd.getName(), wbd.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no web components in application [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

