/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigDescriptor {
    private final String MANAGED_BEAN_CLASS = "managed-bean-class";
    private final String facesConfigFileName = "WEB-INF/faces-config.xml";
    private Context context;
    private Document facesConfigDocument;

    public FacesConfigDescriptor(Context context, WebBundleDescriptor descriptor) {
        try {
            this.context = context;
            this.readFacesConfigDocument(descriptor);
        }
        catch (Exception ex) {
            this.facesConfigDocument = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFacesConfigDocument(WebBundleDescriptor webd) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        ModuleDescriptor moduleDesc = webd.getModuleDescriptor();
        String archBase = this.context.getAbstractArchive().getArchiveUri();
        String uri = null;
        uri = moduleDesc.isStandalone() ? archBase : archBase + File.separator + FileUtils.makeFriendlyFileName(moduleDesc.getArchiveUri());
        FileArchive arch = new FileArchive();
        arch.open(uri);
        InputStream is = arch.getEntry("WEB-INF/faces-config.xml");
        InputSource source = new InputSource(is);
        try {
            this.facesConfigDocument = builder.parse(source);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<String> getManagedBeanClasses() {
        if (this.facesConfigDocument == null) {
            return new ArrayList<String>();
        }
        NodeList nl = this.facesConfigDocument.getElementsByTagName("managed-bean-class");
        ArrayList<String> classes = new ArrayList<String>();
        if (nl != null) {
            int size = nl.getLength();
            for (int i = 0; i < size; ++i) {
                classes.add(nl.item(i).getFirstChild().getNodeValue().trim());
            }
        }
        return classes;
    }
}

