/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.pool;

import com.sun.enterprise.util.collection.DList;
import com.sun.enterprise.util.collection.DListNode;
import com.sun.enterprise.util.collection.FastStack;
import com.sun.enterprise.util.pool.AbstractPool;
import com.sun.enterprise.util.pool.ObjectFactory;
import com.sun.enterprise.util.pool.PoolException;
import com.sun.enterprise.util.scheduler.PeriodicallyServicable;
import com.sun.logging.LogDomains;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SoftObjectPool
extends AbstractPool
implements PeriodicallyServicable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    protected DList list;
    protected int minSize;
    protected int initialSize;
    protected int maxLimit;
    protected long maxIdleTime;
    protected int maxStrongRefs;
    protected Boolean isBounded;

    public SoftObjectPool(ObjectFactory factory, int minSize, int initialSize, long maxIdleTime, int maxStrongRefs) {
        this.factory = factory;
        this.minSize = minSize;
        this.initialSize = initialSize;
        this.maxIdleTime = maxIdleTime;
        this.maxStrongRefs = maxStrongRefs;
        this.setMaxLimit(-1);
        this.initPool();
    }

    public SoftObjectPool(ObjectFactory factory, int minSize, int initialSize, int maxLimit, long maxIdleTime, int maxStrongRefs) {
        this.factory = factory;
        this.minSize = minSize;
        this.maxIdleTime = maxIdleTime;
        this.initialSize = initialSize;
        this.maxStrongRefs = maxStrongRefs;
        this.setMaxLimit(maxLimit);
        this.initPool();
    }

    public int getMaxLimit() {
        return this.maxLimit;
    }

    public void setMaxLimit(int limit) {
        if (limit <= 0 || limit >= 0x7FFFFFFE) {
            this.isBounded = null;
        } else {
            this.isBounded = new Boolean(true);
            this.maxLimit = limit;
        }
    }

    private void initPool() {
        this.list = new DList();
        this.collection = this.list;
        super.preload(this.minSize < this.initialSize ? this.initialSize : this.minSize);
        this.scheduler.addTimeRepeatableTask(this, (int)this.maxIdleTime);
    }

    protected boolean canCreate() {
        return this.isBounded == null ? true : this.createdCount < this.maxLimit;
    }

    protected Object checkin(Object object) {
        int size = this.list.size();
        long now = _clock.getTime();
        if (size < this.maxStrongRefs) {
            this.list.addAsLastNode(new TimeStampedSoftDListNode(object, now, object));
        } else {
            this.list.addAsLastNode(new TimeStampedSoftDListNode(new SoftReference<Object>(object), now, null));
        }
        return this;
    }

    private Object obtainObject(Object param) {
        Object object = null;
        int notifyCount = 0;
        for (int size = this.list.size(); size > 0; --size) {
            TimeStampedSoftDListNode tsNode = (TimeStampedSoftDListNode)this.list.getDListNodeAt(0);
            this.list.delink(tsNode);
            if (tsNode.isSoftRef == null) {
                SoftReference ref = (SoftReference)tsNode.object;
                object = ref.get();
                if (object != null) break;
                ++notifyCount;
                continue;
            }
            object = tsNode.object;
            break;
        }
        if (object == null) {
            try {
                object = this.factory.create(param);
                this.afterCreate(object);
            }
            catch (PoolException poolEx) {
                // empty catch block
            }
        }
        this.createdCount -= notifyCount;
        if (notifyCount == 1) {
            this.collection.notify();
        } else if (notifyCount > 1) {
            this.collection.notifyAll();
        }
        return object;
    }

    protected Object checkout(Object param) {
        return this.obtainObject(param);
    }

    public void prolog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service() {
        int killedCount = 0;
        long now = _clock.getTime();
        long allowed = now - this.maxIdleTime;
        TimeStampedSoftDListNode tsNode = null;
        FastStack stack = new FastStack();
        Collection collection = this.collection;
        synchronized (collection) {
            Object done = null;
            while (done == null) {
                tsNode = (TimeStampedSoftDListNode)this.list.getFirstDListNode();
                if (tsNode == null) {
                    done = new Object();
                    continue;
                }
                if (tsNode.timeStamp <= allowed) {
                    this.list.delink(tsNode);
                    stack.push(tsNode.object);
                    ++killedCount;
                    continue;
                }
                done = new Object();
            }
            this.createdCount -= killedCount;
            int deficit = this.list.size() - this.minSize;
            super.preload(0 - deficit);
            if (killedCount != 0) {
                if (killedCount == 1) {
                    this.collection.notify();
                } else {
                    this.collection.notifyAll();
                }
            }
        }
        while (!stack.isEmpty()) {
            Object object = stack.pop();
            this.beforeDestroy(object);
            this.factory.destroy(object);
        }
        _logger.log(Level.FINE, "Leaving service after killing " + killedCount + " (idle) objects. Now size: " + this.list.size());
    }

    public void epilog() {
    }

    public long getFrequency() {
        return this.maxIdleTime;
    }

    public boolean getExecuteIfMissed() {
        return true;
    }

    public boolean getExecutionTolerance(long missedByMillis) {
        return true;
    }

    public String toString() {
        return "";
    }

    class TimeStampedSoftDListNode
    extends DListNode {
        long timeStamp;
        Object isSoftRef;

        public TimeStampedSoftDListNode(Object object, long ts, Object isSoftRef) {
            super(object);
            this.timeStamp = ts;
            this.isSoftRef = isSoftRef;
            _logger.log(Level.FINE, this + ": created DListNode at: " + ts);
        }

        public String toString() {
            return "TSDListNode: " + this.object + "; isSoftRef: " + this.isSoftRef;
        }
    }
}

