/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.threadpool;

import com.sun.enterprise.util.collection.BlockingQueue;
import com.sun.enterprise.util.collection.QueueClosedException;
import com.sun.enterprise.util.collection.TooManyTasksException;
import com.sun.enterprise.util.threadpool.Servicable;
import com.sun.enterprise.util.threadpool.TaskFactory;
import java.util.ArrayList;

public class TaskQueue
extends BlockingQueue {
    private TaskFactory taskFactory;

    public TaskQueue(TaskFactory factory) {
        this.taskFactory = factory;
    }

    public TaskQueue(int queueLimit, TaskFactory factory) {
        super(queueLimit);
        this.taskFactory = factory;
    }

    public void addFirst(Object o) throws TooManyTasksException, QueueClosedException {
        super.addFirst(this.taskFactory.createTask(o));
    }

    public void addFirst(Servicable ser) throws TooManyTasksException, QueueClosedException {
        super.addFirst(ser);
    }

    public void addLast(Object o) throws TooManyTasksException, QueueClosedException {
        super.addLast(this.taskFactory.createTask(o));
    }

    public void addLast(Servicable ser) throws TooManyTasksException, QueueClosedException {
        super.addLast(ser);
    }

    public void add(int index, Object object) throws TooManyTasksException, QueueClosedException {
        super.add(index, this.taskFactory.createTask(object));
    }

    public void addAll(ArrayList arrayList) throws TooManyTasksException, QueueClosedException {
        for (int i = 0; i < arrayList.size(); ++i) {
            Servicable o = this.taskFactory.createTask(arrayList.get(i));
            arrayList.set(i, o);
        }
        super.addAll(arrayList);
    }

    public void destroyTask(Object o) {
        this.taskFactory.deleteTask(o);
    }
}

